/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway.handlers;

import com.google.common.collect.ImmutableList;
import com.uber.nullaway.Config;
import com.uber.nullaway.handlers.ApacheThriftIsSetHandler;
import com.uber.nullaway.handlers.AssertionHandler;
import com.uber.nullaway.handlers.CompositeHandler;
import com.uber.nullaway.handlers.ContractHandler;
import com.uber.nullaway.handlers.Handler;
import com.uber.nullaway.handlers.InferredJARModelsHandler;
import com.uber.nullaway.handlers.LibraryModelsHandler;
import com.uber.nullaway.handlers.MethodNameUtil;
import com.uber.nullaway.handlers.OptionalEmptinessHandler;
import com.uber.nullaway.handlers.RestrictiveAnnotationHandler;
import com.uber.nullaway.handlers.StreamNullabilityPropagatorFactory;

public class Handlers {
    private Handlers() {
    }

    public static Handler buildDefault(Config config) {
        ImmutableList.Builder handlerListBuilder = ImmutableList.builder();
        MethodNameUtil methodNameUtil = new MethodNameUtil();
        if (config.acknowledgeRestrictiveAnnotations()) {
            handlerListBuilder.add((Object)new RestrictiveAnnotationHandler(config));
        }
        if (config.isJarInferEnabled()) {
            handlerListBuilder.add((Object)new InferredJARModelsHandler(config));
        }
        if (config.handleTestAssertionLibraries()) {
            handlerListBuilder.add((Object)new AssertionHandler(methodNameUtil));
        }
        handlerListBuilder.add((Object)new LibraryModelsHandler());
        handlerListBuilder.add((Object)StreamNullabilityPropagatorFactory.getRxStreamNullabilityPropagator());
        handlerListBuilder.add((Object)StreamNullabilityPropagatorFactory.getJavaStreamNullabilityPropagator());
        handlerListBuilder.add((Object)new ContractHandler());
        handlerListBuilder.add((Object)new ApacheThriftIsSetHandler());
        if (config.checkOptionalEmptiness()) {
            handlerListBuilder.add((Object)new OptionalEmptinessHandler(config, methodNameUtil));
        }
        return new CompositeHandler((ImmutableList<Handler>)handlerListBuilder.build());
    }

    public static Handler buildEmpty() {
        return new CompositeHandler((ImmutableList<Handler>)ImmutableList.of());
    }
}

