/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway.handlers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.VisitorState;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.uber.nullaway.Config;
import com.uber.nullaway.NullAway;
import com.uber.nullaway.dataflow.AccessPathNullnessPropagation;
import com.uber.nullaway.handlers.BaseNoOpHandler;
import com.uber.nullaway.handlers.Handler;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import shadow.checkerframework.dataflow.cfg.node.MethodInvocationNode;

public class InferredJARModelsHandler
extends BaseNoOpHandler {
    private static boolean DEBUG = false;
    private static boolean VERBOSE = false;
    private static final int VERSION_0_FILE_MAGIC_NUMBER = 691458791;
    private static final String DEFAULT_ASTUBX_LOCATION = "META-INF/nullaway/jarinfer.astubx";
    private static final String ANDROID_ASTUBX_LOCATION = "jarinfer.astubx";
    private static final String ANDROID_MODEL_CLASS = "com.uber.nullaway.jarinfer.AndroidJarInferModels";
    private static final int RETURN = -1;
    private final Map<String, Map<String, Map<Integer, Set<String>>>> argAnnotCache;
    private final Map<String, Set<String>> mapModelJarLocations;
    private final Set<String> loadedJars;
    private final Config config;

    private static void LOG(boolean cond, String tag, String msg) {
        if (cond) {
            System.out.println("[JI " + tag + "] " + msg);
        }
    }

    public InferredJARModelsHandler(Config config) {
        this.config = config;
        this.argAnnotCache = new LinkedHashMap<String, Map<String, Map<Integer, Set<String>>>>();
        this.mapModelJarLocations = new LinkedHashMap<String, Set<String>>();
        this.loadedJars = new LinkedHashSet<String>();
        try {
            InputStream androidStubxIS = Class.forName(ANDROID_MODEL_CLASS).getClassLoader().getResourceAsStream(ANDROID_ASTUBX_LOCATION);
            if (androidStubxIS != null) {
                this.parseStubStream(androidStubxIS, "android.jar: jarinfer.astubx");
                InferredJARModelsHandler.LOG(DEBUG, "DEBUG", "Loaded Android RT models.");
            }
        }
        catch (ClassNotFoundException e) {
            InferredJARModelsHandler.LOG(DEBUG, "DEBUG", "Cannot find Android RT models locator class. This is expected if not in an Android project, or the Android SDK JarInfer models Jar has not been set up for this build.");
        }
        catch (Exception e) {
            InferredJARModelsHandler.LOG(DEBUG, "DEBUG", "Cannot load Android RT models.");
        }
    }

    private void processClassPath() {
        URL[] classLoaderUrls;
        for (URL url : classLoaderUrls = ((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs()) {
            String path = url.getFile();
            if (!path.matches(this.config.getJarInferRegexStripModelJarName())) continue;
            String name = path.replaceAll(this.config.getJarInferRegexStripModelJarName(), "$1");
            InferredJARModelsHandler.LOG(DEBUG, "DEBUG", "model jar name: " + name + "\tjar path: " + path);
            if (!this.mapModelJarLocations.containsKey(name)) {
                this.mapModelJarLocations.put(name, new LinkedHashSet());
            }
            this.mapModelJarLocations.get(name).add(path);
        }
    }

    @Override
    public ImmutableSet<Integer> onUnannotatedInvocationGetNonNullPositions(NullAway analysis, VisitorState state, Symbol.MethodSymbol methodSymbol, java.util.List<? extends ExpressionTree> actualParams, ImmutableSet<Integer> nonNullPositions) {
        if (this.mapModelJarLocations.isEmpty()) {
            this.processClassPath();
        }
        Symbol.ClassSymbol classSymbol = methodSymbol.enclClass();
        String className = classSymbol.getQualifiedName().toString();
        if (methodSymbol.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            InferredJARModelsHandler.LOG(VERBOSE, "Warn", "Skipping abstract method: " + className + " : " + methodSymbol.getQualifiedName());
            return nonNullPositions;
        }
        if (!this.lookupAndBuildCache(classSymbol)) {
            return nonNullPositions;
        }
        String methodSign = this.getMethodSignature(methodSymbol);
        Map<Integer, Set<String>> methodArgAnnotations = this.lookupMethodInCache(className, methodSign);
        if (methodArgAnnotations == null) {
            return nonNullPositions;
        }
        LinkedHashSet<Integer> jiNonNullParams = new LinkedHashSet<Integer>();
        for (Map.Entry<Integer, Set<String>> annotationEntry : methodArgAnnotations.entrySet()) {
            if (annotationEntry.getKey() == -1 || !annotationEntry.getValue().contains("javax.annotation.Nonnull")) continue;
            jiNonNullParams.add(annotationEntry.getKey() - (methodSymbol.isStatic() ? 0 : 1));
        }
        if (!jiNonNullParams.isEmpty()) {
            InferredJARModelsHandler.LOG(DEBUG, "DEBUG", "Nonnull params: " + ((Object)jiNonNullParams).toString() + " for " + methodSign);
        }
        return Sets.union(nonNullPositions, jiNonNullParams).immutableCopy();
    }

    @Override
    public Handler.NullnessHint onDataflowVisitMethodInvocation(MethodInvocationNode node, Types types, Context context, AccessPathNullnessPropagation.SubNodeValues inputs, AccessPathNullnessPropagation.Updates thenUpdates, AccessPathNullnessPropagation.Updates elseUpdates, AccessPathNullnessPropagation.Updates bothUpdates) {
        if (this.isReturnAnnotatedNullable(ASTHelpers.getSymbol((MethodInvocationTree)node.getTree()))) {
            return Handler.NullnessHint.HINT_NULLABLE;
        }
        return Handler.NullnessHint.UNKNOWN;
    }

    @Override
    public boolean onOverrideMayBeNullExpr(NullAway analysis, ExpressionTree expr, VisitorState state, boolean exprMayBeNull) {
        if (expr.getKind().equals((Object)Tree.Kind.METHOD_INVOCATION)) {
            return exprMayBeNull || this.isReturnAnnotatedNullable(ASTHelpers.getSymbol((MethodInvocationTree)((MethodInvocationTree)expr)));
        }
        return exprMayBeNull;
    }

    private boolean isReturnAnnotatedNullable(Symbol.MethodSymbol methodSymbol) {
        if (this.config.isJarInferUseReturnAnnotations()) {
            Set<String> methodAnnotations;
            String methodSign;
            Map<Integer, Set<String>> methodArgAnnotations;
            Preconditions.checkNotNull((Object)methodSymbol);
            Symbol.ClassSymbol classSymbol = methodSymbol.enclClass();
            String className = classSymbol.getQualifiedName().toString();
            if (this.lookupAndBuildCache(classSymbol) && (methodArgAnnotations = this.lookupMethodInCache(className, methodSign = this.getMethodSignature(methodSymbol))) != null && (methodAnnotations = methodArgAnnotations.get(-1)) != null && methodAnnotations.contains("javax.annotation.Nullable")) {
                InferredJARModelsHandler.LOG(DEBUG, "DEBUG", "Nullable return for method: " + methodSign);
                return true;
            }
        }
        return false;
    }

    private boolean lookupAndBuildCache(Symbol.ClassSymbol klass) {
        String className = klass.getQualifiedName().toString();
        try {
            InferredJARModelsHandler.LOG(DEBUG, "DEBUG", "Looking for class: " + className);
            if (klass.classfile == null) {
                InferredJARModelsHandler.LOG(VERBOSE, "Warn", "Cannot resolve source for class: " + className);
                return false;
            }
            String jarPath = "";
            if (!this.argAnnotCache.containsKey(className)) {
                URLConnection uc = klass.classfile.toUri().toURL().openConnection();
                if (!(uc instanceof JarURLConnection)) {
                    return false;
                }
                JarURLConnection juc = (JarURLConnection)uc;
                jarPath = juc.getJarFileURL().getPath();
                InferredJARModelsHandler.LOG(DEBUG, "DEBUG", "Found source of class: " + className + ", jar: " + jarPath);
                if (!this.loadedJars.contains(jarPath)) {
                    this.loadedJars.add(jarPath);
                    String jarName = jarPath.replaceAll(this.config.getJarInferRegexStripCodeJarName(), "$1");
                    InferredJARModelsHandler.LOG(DEBUG, "DEBUG", "code jar name: " + jarName + "\tjar path: " + jarPath);
                    if (!this.mapModelJarLocations.containsKey(jarName)) {
                        InferredJARModelsHandler.LOG(VERBOSE, "Warn", "Cannot find model jar for class: " + className + ", jar: " + jarName);
                        return false;
                    }
                    for (String modelJarPath : this.mapModelJarLocations.get(jarName)) {
                        JarFile jar = new JarFile(modelJarPath);
                        InferredJARModelsHandler.LOG(DEBUG, "DEBUG", "Found model jar at: " + modelJarPath);
                        JarEntry astubxJE = jar.getJarEntry(DEFAULT_ASTUBX_LOCATION);
                        if (astubxJE == null) {
                            InferredJARModelsHandler.LOG(VERBOSE, "Warn", "Cannot find jarinfer.astubx in jar: " + modelJarPath);
                            return false;
                        }
                        InputStream astubxIS = jar.getInputStream(astubxJE);
                        if (astubxIS == null) {
                            InferredJARModelsHandler.LOG(VERBOSE, "Warn", "Cannot load jarinfer.astubx in jar: " + modelJarPath);
                            return false;
                        }
                        this.parseStubStream(astubxIS, modelJarPath + ": " + DEFAULT_ASTUBX_LOCATION);
                        InferredJARModelsHandler.LOG(DEBUG, "DEBUG", "Loaded " + this.argAnnotCache.keySet().size() + " astubx for class: " + className + " from jar: " + modelJarPath);
                    }
                } else {
                    InferredJARModelsHandler.LOG(DEBUG, "DEBUG", "Skipping already loaded jar: " + jarPath);
                }
            } else {
                InferredJARModelsHandler.LOG(DEBUG, "DEBUG", "Hit annotation cache for class: " + className);
            }
            if (!this.argAnnotCache.containsKey(className)) {
                InferredJARModelsHandler.LOG(VERBOSE, "Warn", "Cannot find Annotation Cache for class: " + className + ", jar: " + jarPath);
                return false;
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
        return true;
    }

    private Map<Integer, Set<String>> lookupMethodInCache(String className, String methodSign) {
        if (!this.argAnnotCache.containsKey(className)) {
            return null;
        }
        Map<Integer, Set<String>> methodArgAnnotations = this.argAnnotCache.get(className).get(methodSign);
        if (methodArgAnnotations == null) {
            InferredJARModelsHandler.LOG(VERBOSE, "Warn", "Cannot find Annotation Cache entry for method: " + methodSign + " in class: " + className);
            return null;
        }
        InferredJARModelsHandler.LOG(DEBUG, "DEBUG", "Found Annotation Cache entry for method: " + methodSign + " in class: " + className + " -- " + methodArgAnnotations.toString());
        return methodArgAnnotations;
    }

    private String getMethodSignature(Symbol.MethodSymbol method) {
        String methodSign = method.enclClass().getQualifiedName().toString() + ":" + (method.isStaticOrInstanceInit() ? "" : this.getSimpleTypeName(method.getReturnType()) + " ") + method.getSimpleName() + "(";
        if (!((List)method.getParameters()).isEmpty()) {
            for (Symbol.VarSymbol var : method.getParameters()) {
                methodSign = methodSign + this.getSimpleTypeName(var.type) + ", ";
            }
            methodSign = methodSign.substring(0, methodSign.lastIndexOf(44));
        }
        methodSign = methodSign + ")";
        InferredJARModelsHandler.LOG(DEBUG, "DEBUG", "@ method sign: " + methodSign);
        return methodSign;
    }

    private String getSimpleTypeName(Type typ) {
        if (typ.getKind() == TypeKind.TYPEVAR) {
            return ((Name)typ.getUpperBound().tsym.getSimpleName()).toString();
        }
        return ((Name)typ.tsym.getSimpleName()).toString();
    }

    private void parseStubStream(InputStream stubxInputStream, String stubxLocation) throws IOException {
        DataInputStream in = new DataInputStream(stubxInputStream);
        if (in.readInt() != 691458791) {
            throw new Error("Invalid file version/magic number for stubx file!" + stubxLocation);
        }
        int numStrings = in.readInt();
        String[] strings = new String[numStrings];
        for (int i = 0; i < numStrings; ++i) {
            strings[i] = in.readUTF();
        }
        int numPackages = in.readInt();
        for (int i = 0; i < numPackages; ++i) {
            in.readInt();
            in.readInt();
        }
        int numTypes = in.readInt();
        for (int i = 0; i < numTypes; ++i) {
            in.readInt();
            in.readInt();
        }
        int numMethods = in.readInt();
        for (int i = 0; i < numMethods; ++i) {
            String methodSig = strings[in.readInt()];
            String annotation = strings[in.readInt()];
            InferredJARModelsHandler.LOG(DEBUG, "DEBUG", "method: " + methodSig + ", return annotation: " + annotation);
            this.cacheAnnotation(methodSig, -1, annotation);
        }
        int numArgumentRecords = in.readInt();
        for (int i = 0; i < numArgumentRecords; ++i) {
            String methodSig = strings[in.readInt()];
            if (methodSig.lastIndexOf(58) == -1 || methodSig.split(":")[0].lastIndexOf(46) == -1) {
                throw new Error("Invalid method signature " + methodSig + " in stubx file " + stubxLocation);
            }
            int argNum = in.readInt();
            String annotation = strings[in.readInt()];
            InferredJARModelsHandler.LOG(DEBUG, "DEBUG", "method: " + methodSig + ", argNum: " + argNum + ", arg annotation: " + annotation);
            this.cacheAnnotation(methodSig, argNum, annotation);
        }
    }

    private void cacheAnnotation(String methodSig, Integer argNum, String annotation) {
        String className = methodSig.split(":")[0].replace('$', '.');
        if (!this.argAnnotCache.containsKey(className)) {
            this.argAnnotCache.put(className, new LinkedHashMap());
        }
        if (!this.argAnnotCache.get(className).containsKey(methodSig)) {
            this.argAnnotCache.get(className).put(methodSig, new LinkedHashMap());
        }
        if (!this.argAnnotCache.get(className).get(methodSig).containsKey(argNum)) {
            this.argAnnotCache.get(className).get(methodSig).put(argNum, new LinkedHashSet());
        }
        this.argAnnotCache.get(className).get(methodSig).get(argNum).add(annotation);
    }
}

