/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway.handlers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.VisitorState;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.uber.nullaway.LibraryModels;
import com.uber.nullaway.NullAway;
import com.uber.nullaway.Nullness;
import com.uber.nullaway.dataflow.AccessPath;
import com.uber.nullaway.dataflow.AccessPathNullnessPropagation;
import com.uber.nullaway.handlers.BaseNoOpHandler;
import com.uber.nullaway.handlers.Handler;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import shadow.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import shadow.checkerframework.dataflow.cfg.node.Node;

public class LibraryModelsHandler
extends BaseNoOpHandler {
    private final LibraryModels libraryModels = LibraryModelsHandler.loadLibraryModels();
    @Nullable
    private OptimizedLibraryModels optLibraryModels;

    @Override
    public ImmutableSet<Integer> onUnannotatedInvocationGetNonNullPositions(NullAway analysis, VisitorState state, Symbol.MethodSymbol methodSymbol, List<? extends ExpressionTree> actualParams, ImmutableSet<Integer> nonNullPositions) {
        return Sets.union(nonNullPositions, this.getOptLibraryModels(state.context).nonNullParameters(methodSymbol)).immutableCopy();
    }

    @Override
    public ImmutableSet<Integer> onUnannotatedInvocationGetExplicitlyNullablePositions(Context context, Symbol.MethodSymbol methodSymbol, ImmutableSet<Integer> explicitlyNullablePositions) {
        return Sets.union((Set)Sets.difference(explicitlyNullablePositions, this.getOptLibraryModels(context).nonNullParameters(methodSymbol)), this.getOptLibraryModels(context).explicitlyNullableParameters(methodSymbol)).immutableCopy();
    }

    @Override
    public boolean onOverrideMayBeNullExpr(NullAway analysis, ExpressionTree expr, VisitorState state, boolean exprMayBeNull) {
        if (expr.getKind() == Tree.Kind.METHOD_INVOCATION) {
            Symbol.MethodSymbol methodSymbol;
            OptimizedLibraryModels optLibraryModels = this.getOptLibraryModels(state.context);
            if (optLibraryModels.hasNullableReturn(methodSymbol = (Symbol.MethodSymbol)ASTHelpers.getSymbol((Tree)expr), state.getTypes()) || !optLibraryModels.nullImpliesNullParameters(methodSymbol).isEmpty()) {
                return analysis.nullnessFromDataflow(state, expr) || exprMayBeNull;
            }
            if (optLibraryModels.hasNonNullReturn(methodSymbol, state.getTypes())) {
                return false;
            }
        }
        return exprMayBeNull;
    }

    @Override
    public Handler.NullnessHint onDataflowVisitMethodInvocation(MethodInvocationNode node, Types types, Context context, AccessPathNullnessPropagation.SubNodeValues inputs, AccessPathNullnessPropagation.Updates thenUpdates, AccessPathNullnessPropagation.Updates elseUpdates, AccessPathNullnessPropagation.Updates bothUpdates) {
        Symbol.MethodSymbol callee = ASTHelpers.getSymbol((MethodInvocationTree)node.getTree());
        Preconditions.checkNotNull((Object)callee);
        this.setUnconditionalArgumentNullness(bothUpdates, node.getArguments(), callee, context);
        this.setConditionalArgumentNullness(thenUpdates, elseUpdates, node.getArguments(), callee, context);
        ImmutableSet<Integer> nullImpliesNullIndexes = this.getOptLibraryModels(context).nullImpliesNullParameters(callee);
        if (!nullImpliesNullIndexes.isEmpty()) {
            boolean anyNull = false;
            UnmodifiableIterator unmodifiableIterator = nullImpliesNullIndexes.iterator();
            while (unmodifiableIterator.hasNext()) {
                int idx = (Integer)unmodifiableIterator.next();
                if (inputs.valueOfSubNode(node.getArgument(idx)).equals(Nullness.NONNULL)) continue;
                anyNull = true;
            }
            return anyNull ? Handler.NullnessHint.HINT_NULLABLE : Handler.NullnessHint.FORCE_NONNULL;
        }
        if (this.getOptLibraryModels(context).hasNonNullReturn(callee, types)) {
            return Handler.NullnessHint.FORCE_NONNULL;
        }
        if (this.getOptLibraryModels(context).hasNullableReturn(callee, types)) {
            return Handler.NullnessHint.HINT_NULLABLE;
        }
        return Handler.NullnessHint.UNKNOWN;
    }

    private void setConditionalArgumentNullness(AccessPathNullnessPropagation.Updates thenUpdates, AccessPathNullnessPropagation.Updates elseUpdates, List<Node> arguments, Symbol.MethodSymbol callee, Context context) {
        ImmutableSet<Integer> nullImpliesTrueParameters = this.getOptLibraryModels(context).nullImpliesTrueParameters(callee);
        ImmutableSet<Integer> nullImpliesFalseParameters = this.getOptLibraryModels(context).nullImpliesFalseParameters(callee);
        for (AccessPath accessPath : LibraryModelsHandler.accessPathsAtIndexes(nullImpliesTrueParameters, arguments)) {
            elseUpdates.set(accessPath, Nullness.NONNULL);
        }
        for (AccessPath accessPath : LibraryModelsHandler.accessPathsAtIndexes(nullImpliesFalseParameters, arguments)) {
            thenUpdates.set(accessPath, Nullness.NONNULL);
        }
    }

    private static Iterable<AccessPath> accessPathsAtIndexes(Set<Integer> indexes, List<Node> arguments) {
        ArrayList<AccessPath> result = new ArrayList<AccessPath>();
        for (Integer i : indexes) {
            Node argument;
            AccessPath ap;
            Preconditions.checkArgument((i >= 0 && i < arguments.size() ? 1 : 0) != 0, (Object)("Invalid argument index: " + i));
            if (i < 0 || i >= arguments.size() || (ap = AccessPath.getAccessPathForNodeNoMapGet(argument = arguments.get(i))) == null) continue;
            result.add(ap);
        }
        return result;
    }

    private OptimizedLibraryModels getOptLibraryModels(Context context) {
        if (this.optLibraryModels == null) {
            this.optLibraryModels = new OptimizedLibraryModels(this.libraryModels, context);
        }
        return this.optLibraryModels;
    }

    private void setUnconditionalArgumentNullness(AccessPathNullnessPropagation.Updates bothUpdates, List<Node> arguments, Symbol.MethodSymbol callee, Context context) {
        ImmutableSet<Integer> requiredNonNullParameters = this.getOptLibraryModels(context).failIfNullParameters(callee);
        for (AccessPath accessPath : LibraryModelsHandler.accessPathsAtIndexes(requiredNonNullParameters, arguments)) {
            bothUpdates.set(accessPath, Nullness.NONNULL);
        }
    }

    private static LibraryModels loadLibraryModels() {
        ServiceLoader<LibraryModels> externalLibraryModels = ServiceLoader.load(LibraryModels.class, LibraryModels.class.getClassLoader());
        ImmutableSet.Builder libModelsBuilder = new ImmutableSet.Builder();
        libModelsBuilder.add((Object)new DefaultLibraryModels()).addAll(externalLibraryModels);
        return new CombinedLibraryModels((Iterable<LibraryModels>)libModelsBuilder.build());
    }

    private static class OptimizedLibraryModels {
        private final NameIndexedMap<ImmutableSet<Integer>> failIfNullParams;
        private final NameIndexedMap<ImmutableSet<Integer>> explicitlyNullableParams;
        private final NameIndexedMap<ImmutableSet<Integer>> nonNullParams;
        private final NameIndexedMap<ImmutableSet<Integer>> nullImpliesTrueParams;
        private final NameIndexedMap<ImmutableSet<Integer>> nullImpliesFalseParams;
        private final NameIndexedMap<ImmutableSet<Integer>> nullImpliesNullParams;
        private final NameIndexedMap<Boolean> nullableRet;
        private final NameIndexedMap<Boolean> nonNullRet;

        public OptimizedLibraryModels(LibraryModels models, Context context) {
            Names names = Names.instance(context);
            this.failIfNullParams = this.makeOptimizedIntSetLookup(names, models.failIfNullParameters());
            this.explicitlyNullableParams = this.makeOptimizedIntSetLookup(names, models.explicitlyNullableParameters());
            this.nonNullParams = this.makeOptimizedIntSetLookup(names, models.nonNullParameters());
            this.nullImpliesTrueParams = this.makeOptimizedIntSetLookup(names, models.nullImpliesTrueParameters());
            this.nullImpliesFalseParams = this.makeOptimizedIntSetLookup(names, models.nullImpliesFalseParameters());
            this.nullImpliesNullParams = this.makeOptimizedIntSetLookup(names, models.nullImpliesNullParameters());
            this.nullableRet = this.makeOptimizedBoolLookup(names, models.nullableReturns());
            this.nonNullRet = this.makeOptimizedBoolLookup(names, models.nonNullReturns());
        }

        public boolean hasNonNullReturn(Symbol.MethodSymbol symbol, Types types) {
            return OptimizedLibraryModels.lookupHandlingOverrides(symbol, types, this.nonNullRet) != null;
        }

        public boolean hasNullableReturn(Symbol.MethodSymbol symbol, Types types) {
            return OptimizedLibraryModels.lookupHandlingOverrides(symbol, types, this.nullableRet) != null;
        }

        ImmutableSet<Integer> failIfNullParameters(Symbol.MethodSymbol symbol) {
            return this.lookupImmutableSet(symbol, this.failIfNullParams);
        }

        ImmutableSet<Integer> explicitlyNullableParameters(Symbol.MethodSymbol symbol) {
            return this.lookupImmutableSet(symbol, this.explicitlyNullableParams);
        }

        ImmutableSet<Integer> nonNullParameters(Symbol.MethodSymbol symbol) {
            return this.lookupImmutableSet(symbol, this.nonNullParams);
        }

        ImmutableSet<Integer> nullImpliesTrueParameters(Symbol.MethodSymbol symbol) {
            return this.lookupImmutableSet(symbol, this.nullImpliesTrueParams);
        }

        ImmutableSet<Integer> nullImpliesFalseParameters(Symbol.MethodSymbol symbol) {
            return this.lookupImmutableSet(symbol, this.nullImpliesFalseParams);
        }

        ImmutableSet<Integer> nullImpliesNullParameters(Symbol.MethodSymbol symbol) {
            return this.lookupImmutableSet(symbol, this.nullImpliesNullParams);
        }

        private ImmutableSet<Integer> lookupImmutableSet(Symbol.MethodSymbol symbol, NameIndexedMap<ImmutableSet<Integer>> lookup) {
            ImmutableSet<Integer> result = lookup.get(symbol);
            return result == null ? ImmutableSet.of() : result;
        }

        private NameIndexedMap<ImmutableSet<Integer>> makeOptimizedIntSetLookup(Names names, ImmutableSetMultimap<LibraryModels.MethodRef, Integer> ref2Ints) {
            return this.makeOptimizedLookup(names, (Set<LibraryModels.MethodRef>)ref2Ints.keySet(), arg_0 -> ref2Ints.get(arg_0));
        }

        private NameIndexedMap<Boolean> makeOptimizedBoolLookup(Names names, ImmutableSet<LibraryModels.MethodRef> refs) {
            return this.makeOptimizedLookup(names, (Set<LibraryModels.MethodRef>)refs, (Function)ref -> true);
        }

        private <T> NameIndexedMap<T> makeOptimizedLookup(Names names, Set<LibraryModels.MethodRef> refs, Function<LibraryModels.MethodRef, T> getValForRef) {
            LinkedHashMap nameMapping = new LinkedHashMap();
            for (LibraryModels.MethodRef ref : refs) {
                Name methodName = names.fromString(ref.methodName);
                LinkedHashMap<LibraryModels.MethodRef, T> mapForName = (LinkedHashMap<LibraryModels.MethodRef, T>)nameMapping.get(methodName);
                if (mapForName == null) {
                    mapForName = new LinkedHashMap<LibraryModels.MethodRef, T>();
                    nameMapping.put(methodName, mapForName);
                }
                mapForName.put(ref, getValForRef.apply(ref));
            }
            return new NameIndexedMap(nameMapping);
        }

        @Nullable
        private static Symbol.MethodSymbol lookupHandlingOverrides(Symbol.MethodSymbol symbol, Types types, NameIndexedMap<Boolean> optLookup) {
            if (optLookup.nameNotPresent(symbol)) {
                return null;
            }
            if (optLookup.get(symbol) != null) {
                return symbol;
            }
            for (Symbol.MethodSymbol superSymbol : ASTHelpers.findSuperMethods((Symbol.MethodSymbol)symbol, (Types)types)) {
                if (optLookup.get(superSymbol) == null) continue;
                return superSymbol;
            }
            return null;
        }

        private static class NameIndexedMap<T> {
            private final Map<Name, Map<LibraryModels.MethodRef, T>> state;

            NameIndexedMap(Map<Name, Map<LibraryModels.MethodRef, T>> state) {
                this.state = state;
            }

            @Nullable
            public T get(Symbol.MethodSymbol symbol) {
                Map<LibraryModels.MethodRef, T> methodRefTMap = this.state.get(symbol.name);
                if (methodRefTMap == null) {
                    return null;
                }
                LibraryModels.MethodRef ref = LibraryModels.MethodRef.fromSymbol(symbol);
                return methodRefTMap.get(ref);
            }

            public boolean nameNotPresent(Symbol.MethodSymbol symbol) {
                return this.state.get(symbol.name) == null;
            }
        }
    }

    private static class CombinedLibraryModels
    implements LibraryModels {
        private final ImmutableSetMultimap<LibraryModels.MethodRef, Integer> failIfNullParameters;
        private final ImmutableSetMultimap<LibraryModels.MethodRef, Integer> explicitlyNullableParameters;
        private final ImmutableSetMultimap<LibraryModels.MethodRef, Integer> nonNullParameters;
        private final ImmutableSetMultimap<LibraryModels.MethodRef, Integer> nullImpliesTrueParameters;
        private final ImmutableSetMultimap<LibraryModels.MethodRef, Integer> nullImpliesFalseParameters;
        private final ImmutableSetMultimap<LibraryModels.MethodRef, Integer> nullImpliesNullParameters;
        private final ImmutableSet<LibraryModels.MethodRef> nullableReturns;
        private final ImmutableSet<LibraryModels.MethodRef> nonNullReturns;

        public CombinedLibraryModels(Iterable<LibraryModels> models) {
            ImmutableSetMultimap.Builder failIfNullParametersBuilder = new ImmutableSetMultimap.Builder();
            ImmutableSetMultimap.Builder explicitlyNullableParametersBuilder = new ImmutableSetMultimap.Builder();
            ImmutableSetMultimap.Builder nonNullParametersBuilder = new ImmutableSetMultimap.Builder();
            ImmutableSetMultimap.Builder nullImpliesTrueParametersBuilder = new ImmutableSetMultimap.Builder();
            ImmutableSetMultimap.Builder nullImpliesFalseParametersBuilder = new ImmutableSetMultimap.Builder();
            ImmutableSetMultimap.Builder nullImpliesNullParametersBuilder = new ImmutableSetMultimap.Builder();
            ImmutableSet.Builder nullableReturnsBuilder = new ImmutableSet.Builder();
            ImmutableSet.Builder nonNullReturnsBuilder = new ImmutableSet.Builder();
            for (LibraryModels libraryModels : models) {
                for (Map.Entry entry : libraryModels.failIfNullParameters().entries()) {
                    failIfNullParametersBuilder.put(entry);
                }
                for (Map.Entry entry : libraryModels.explicitlyNullableParameters().entries()) {
                    explicitlyNullableParametersBuilder.put(entry);
                }
                for (Map.Entry entry : libraryModels.nonNullParameters().entries()) {
                    nonNullParametersBuilder.put(entry);
                }
                for (Map.Entry entry : libraryModels.nullImpliesTrueParameters().entries()) {
                    nullImpliesTrueParametersBuilder.put(entry);
                }
                for (Map.Entry entry : libraryModels.nullImpliesFalseParameters().entries()) {
                    nullImpliesFalseParametersBuilder.put(entry);
                }
                for (Map.Entry entry : libraryModels.nullImpliesNullParameters().entries()) {
                    nullImpliesNullParametersBuilder.put(entry);
                }
                for (LibraryModels.MethodRef name : libraryModels.nullableReturns()) {
                    nullableReturnsBuilder.add((Object)name);
                }
                for (LibraryModels.MethodRef name : libraryModels.nonNullReturns()) {
                    nonNullReturnsBuilder.add((Object)name);
                }
            }
            this.failIfNullParameters = failIfNullParametersBuilder.build();
            this.explicitlyNullableParameters = explicitlyNullableParametersBuilder.build();
            this.nonNullParameters = nonNullParametersBuilder.build();
            this.nullImpliesTrueParameters = nullImpliesTrueParametersBuilder.build();
            this.nullImpliesFalseParameters = nullImpliesFalseParametersBuilder.build();
            this.nullImpliesNullParameters = nullImpliesNullParametersBuilder.build();
            this.nullableReturns = nullableReturnsBuilder.build();
            this.nonNullReturns = nonNullReturnsBuilder.build();
        }

        @Override
        public ImmutableSetMultimap<LibraryModels.MethodRef, Integer> failIfNullParameters() {
            return this.failIfNullParameters;
        }

        @Override
        public ImmutableSetMultimap<LibraryModels.MethodRef, Integer> explicitlyNullableParameters() {
            return this.explicitlyNullableParameters;
        }

        @Override
        public ImmutableSetMultimap<LibraryModels.MethodRef, Integer> nonNullParameters() {
            return this.nonNullParameters;
        }

        @Override
        public ImmutableSetMultimap<LibraryModels.MethodRef, Integer> nullImpliesTrueParameters() {
            return this.nullImpliesTrueParameters;
        }

        @Override
        public ImmutableSetMultimap<LibraryModels.MethodRef, Integer> nullImpliesFalseParameters() {
            return this.nullImpliesFalseParameters;
        }

        @Override
        public ImmutableSetMultimap<LibraryModels.MethodRef, Integer> nullImpliesNullParameters() {
            return this.nullImpliesNullParameters;
        }

        @Override
        public ImmutableSet<LibraryModels.MethodRef> nullableReturns() {
            return this.nullableReturns;
        }

        @Override
        public ImmutableSet<LibraryModels.MethodRef> nonNullReturns() {
            return this.nonNullReturns;
        }
    }

    private static class DefaultLibraryModels
    implements LibraryModels {
        private static final ImmutableSetMultimap<LibraryModels.MethodRef, Integer> FAIL_IF_NULL_PARAMETERS = new ImmutableSetMultimap.Builder().put((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Preconditions", "<T>checkNotNull(T)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Preconditions", "<T>checkNotNull(T,java.lang.Object)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Preconditions", "<T>checkNotNull(T,java.lang.String,java.lang.Object...)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Preconditions", "<T>checkNotNull(T,java.lang.String,char)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Preconditions", "<T>checkNotNull(T,java.lang.String,int)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Preconditions", "<T>checkNotNull(T,java.lang.String,long)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Preconditions", "<T>checkNotNull(T,java.lang.String,java.lang.Object)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Preconditions", "<T>checkNotNull(T,java.lang.String,char,char)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Preconditions", "<T>checkNotNull(T,java.lang.String,char,int)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Preconditions", "<T>checkNotNull(T,java.lang.String,char,long)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Preconditions", "<T>checkNotNull(T,java.lang.String,char,java.lang.Object)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Preconditions", "<T>checkNotNull(T,java.lang.String,int,char)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Preconditions", "<T>checkNotNull(T,java.lang.String,int,int)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Preconditions", "<T>checkNotNull(T,java.lang.String,int,long)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Preconditions", "<T>checkNotNull(T,java.lang.String,int,java.lang.Object)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Preconditions", "<T>checkNotNull(T,java.lang.String,long,char)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Preconditions", "<T>checkNotNull(T,java.lang.String,long,int)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Preconditions", "<T>checkNotNull(T,java.lang.String,long,long)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Preconditions", "<T>checkNotNull(T,java.lang.String,long,java.lang.Object)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Preconditions", "<T>checkNotNull(T,java.lang.String,java.lang.Object,char)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Preconditions", "<T>checkNotNull(T,java.lang.String,java.lang.Object,int)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Preconditions", "<T>checkNotNull(T,java.lang.String,java.lang.Object,long)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Preconditions", "<T>checkNotNull(T,java.lang.String,java.lang.Object,java.lang.Object)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Preconditions", "<T>checkNotNull(T,java.lang.String,java.lang.Object,java.lang.Object,java.lang.Object)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Preconditions", "<T>checkNotNull(T,java.lang.String,java.lang.Object,java.lang.Object,java.lang.Object,java.lang.Object)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("java.util.Objects", "<T>requireNonNull(T)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("java.util.Objects", "<T>requireNonNull(T,java.lang.String)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("org.junit.Assert", "assertNotNull(java.lang.Object)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("org.junit.Assert", "assertNotNull(java.lang.String,java.lang.Object)"), (Object)1).put((Object)LibraryModels.MethodRef.methodRef("org.junit.jupiter.api.Assertions", "assertNotNull(java.lang.Object)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("org.junit.jupiter.api.Assertions", "assertNotNull(java.lang.Object,java.lang.String)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("org.junit.jupiter.api.Assertions", "assertNotNull(java.lang.Object,java.util.function.Supplier<java.lang.String>)"), (Object)0).build();
        private static final ImmutableSetMultimap<LibraryModels.MethodRef, Integer> EXPLICITLY_NULLABLE_PARAMETERS = new ImmutableSetMultimap.Builder().put((Object)LibraryModels.MethodRef.methodRef("android.view.GestureDetector.OnGestureListener", "onScroll(android.view.MotionEvent,android.view.MotionEvent,float,float)"), (Object)0).build();
        private static final ImmutableSetMultimap<LibraryModels.MethodRef, Integer> NON_NULL_PARAMETERS = new ImmutableSetMultimap.Builder().put((Object)LibraryModels.MethodRef.methodRef("com.android.sdklib.build.ApkBuilder", "ApkBuilder(java.io.File,java.io.File,java.io.File,java.lang.String,java.io.PrintStream)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.android.sdklib.build.ApkBuilder", "ApkBuilder(java.io.File,java.io.File,java.io.File,java.lang.String,java.io.PrintStream)"), (Object)1).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.collect.ImmutableList.Builder", "add(E)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.collect.ImmutableList.Builder", "addAll(java.lang.Iterable<? extends E>)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.collect.ImmutableSet.Builder", "add(E)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.collect.ImmutableSet.Builder", "addAll(java.lang.Iterable<? extends E>)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.collect.ImmutableSortedSet.Builder", "add(E)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.collect.ImmutableSortedSet.Builder", "addAll(java.lang.Iterable<? extends E>)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.collect.Iterables", "<T>getFirst(java.lang.Iterable<? extends T>,T)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.util.concurrent.SettableFuture", "setException(java.lang.Throwable)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Function", "apply(F)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Predicate", "apply(T)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("com.google.common.util.concurrent.AsyncFunction", "apply(I)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("java.io.File", "File(java.lang.String)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("java.lang.Class", "getResource(java.lang.String)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("java.lang.Class", "isAssignableFrom(java.lang.Class<?>)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("java.lang.System", "getProperty(java.lang.String)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("java.net.URLClassLoader", "newInstance(java.net.URL[],java.lang.ClassLoader)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("javax.lang.model.element.Element", "<A>getAnnotation(java.lang.Class<A>)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("javax.lang.model.util.Elements", "getPackageElement(java.lang.CharSequence)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("javax.lang.model.util.Elements", "getTypeElement(java.lang.CharSequence)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("javax.lang.model.util.Elements", "getDocComment(javax.lang.model.element.Element)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("java.util.Optional", "<T>of(T)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("java.util.Deque", "addFirst(E)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("java.util.Deque", "addLast(E)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("java.util.Deque", "offerFirst(E)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("java.util.Deque", "offerLast(E)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("java.util.Deque", "add(E)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("java.util.Deque", "offer(E)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("java.util.Deque", "push(E)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("java.util.Collection", "<T>toArray(T[])"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("java.util.ArrayDeque", "addFirst(E)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("java.util.ArrayDeque", "addLast(E)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("java.util.ArrayDeque", "offerFirst(E)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("java.util.ArrayDeque", "offerLast(E)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("java.util.ArrayDeque", "add(E)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("java.util.ArrayDeque", "offer(E)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("java.util.ArrayDeque", "push(E)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("java.util.ArrayDeque", "<T>toArray(T[])"), (Object)0).build();
        private static final ImmutableSetMultimap<LibraryModels.MethodRef, Integer> NULL_IMPLIES_TRUE_PARAMETERS = new ImmutableSetMultimap.Builder().put((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Strings", "isNullOrEmpty(java.lang.String)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("java.util.Objects", "isNull(java.lang.Object)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("android.text.TextUtils", "isEmpty(java.lang.CharSequence)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("org.apache.commons.lang.StringUtils", "isEmpty(java.lang.String)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("org.apache.commons.lang3.StringUtils", "isEmpty(java.lang.CharSequence)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("org.apache.commons.lang.StringUtils", "isBlank(java.lang.String)"), (Object)0).put((Object)LibraryModels.MethodRef.methodRef("org.apache.commons.lang3.StringUtils", "isBlank(java.lang.CharSequence)"), (Object)0).build();
        private static final ImmutableSetMultimap<LibraryModels.MethodRef, Integer> NULL_IMPLIES_FALSE_PARAMETERS = new ImmutableSetMultimap.Builder().put((Object)LibraryModels.MethodRef.methodRef("java.util.Objects", "nonNull(java.lang.Object)"), (Object)0).build();
        private static final ImmutableSetMultimap<LibraryModels.MethodRef, Integer> NULL_IMPLIES_NULL_PARAMETERS = new ImmutableSetMultimap.Builder().put((Object)LibraryModels.MethodRef.methodRef("java.util.Optional", "orElse(T)"), (Object)0).build();
        private static final ImmutableSet<LibraryModels.MethodRef> NULLABLE_RETURNS = new ImmutableSet.Builder().add((Object)LibraryModels.MethodRef.methodRef("java.lang.ref.Reference", "get()")).add((Object)LibraryModels.MethodRef.methodRef("java.lang.ref.PhantomReference", "get()")).add((Object)LibraryModels.MethodRef.methodRef("java.lang.ref.SoftReference", "get()")).add((Object)LibraryModels.MethodRef.methodRef("java.lang.ref.WeakReference", "get()")).add((Object)LibraryModels.MethodRef.methodRef("java.util.concurrent.atomic.AtomicReference", "get()")).add((Object)LibraryModels.MethodRef.methodRef("java.util.Map", "get(java.lang.Object)")).add((Object)LibraryModels.MethodRef.methodRef("javax.lang.model.element.Element", "getEnclosingElement()")).add((Object)LibraryModels.MethodRef.methodRef("javax.lang.model.element.ExecutableElement", "getDefaultValue()")).add((Object)LibraryModels.MethodRef.methodRef("javax.lang.model.element.PackageElement", "getEnclosingElement()")).add((Object)LibraryModels.MethodRef.methodRef("javax.lang.model.element.VariableElement", "getConstantValue()")).add((Object)LibraryModels.MethodRef.methodRef("javax.lang.model.type.WildcardType", "getSuperBound()")).add((Object)LibraryModels.MethodRef.methodRef("android.app.ActivityManager", "getRunningAppProcesses()")).add((Object)LibraryModels.MethodRef.methodRef("android.view.View", "getHandler()")).add((Object)LibraryModels.MethodRef.methodRef("java.lang.Throwable", "getMessage()")).add((Object)LibraryModels.MethodRef.methodRef("android.webkit.WebView", "getUrl()")).add((Object)LibraryModels.MethodRef.methodRef("com.sun.source.tree.CompilationUnitTree", "getPackageName()")).build();
        private static final ImmutableSet<LibraryModels.MethodRef> NONNULL_RETURNS = new ImmutableSet.Builder().add((Object)LibraryModels.MethodRef.methodRef("com.google.gson", "<T>fromJson(String,Class)")).add((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Function", "apply(F)")).add((Object)LibraryModels.MethodRef.methodRef("com.google.common.base.Predicate", "apply(T)")).add((Object)LibraryModels.MethodRef.methodRef("com.google.common.util.concurrent.AsyncFunction", "apply(I)")).add((Object)LibraryModels.MethodRef.methodRef("android.app.Activity", "<T>findViewById(int)")).add((Object)LibraryModels.MethodRef.methodRef("android.view.View", "<T>findViewById(int)")).add((Object)LibraryModels.MethodRef.methodRef("android.view.View", "getResources()")).add((Object)LibraryModels.MethodRef.methodRef("android.view.ViewGroup", "getChildAt(int)")).add((Object)LibraryModels.MethodRef.methodRef("android.content.res.Resources", "getDrawable(int,android.content.res.Resources.Theme)")).add((Object)LibraryModels.MethodRef.methodRef("android.support.v4.app.Fragment", "getActivity()")).add((Object)LibraryModels.MethodRef.methodRef("androidx.fragment.app.Fragment", "getActivity()")).add((Object)LibraryModels.MethodRef.methodRef("android.support.v4.app.Fragment", "getArguments()")).add((Object)LibraryModels.MethodRef.methodRef("androidx.fragment.app.Fragment", "getArguments()")).add((Object)LibraryModels.MethodRef.methodRef("android.support.v4.app.Fragment", "getContext()")).add((Object)LibraryModels.MethodRef.methodRef("androidx.fragment.app.Fragment", "getContext()")).add((Object)LibraryModels.MethodRef.methodRef("android.support.v4.app.Fragment", "onCreateView(android.view.LayoutInflater,android.view.ViewGroup,android.os.Bundle)")).add((Object)LibraryModels.MethodRef.methodRef("androidx.fragment.app.Fragment", "onCreateView(android.view.LayoutInflater,android.view.ViewGroup,android.os.Bundle)")).add((Object)LibraryModels.MethodRef.methodRef("android.support.v4.content.ContextCompat", "getDrawable(android.content.Context,int)")).add((Object)LibraryModels.MethodRef.methodRef("androidx.core.content.ContextCompat", "getDrawable(android.content.Context,int)")).add((Object)LibraryModels.MethodRef.methodRef("android.support.v7.app.AppCompatDialog", "<T>findViewById(int)")).add((Object)LibraryModels.MethodRef.methodRef("androidx.appcompat.app.AppCompatDialog", "<T>findViewById(int)")).add((Object)LibraryModels.MethodRef.methodRef("android.support.v7.content.res.AppCompatResources", "getDrawable(android.content.Context,int)")).add((Object)LibraryModels.MethodRef.methodRef("androidx.appcompat.content.res.AppCompatResources", "getDrawable(android.content.Context,int)")).add((Object)LibraryModels.MethodRef.methodRef("android.support.design.widget.TextInputLayout", "getEditText()")).build();

        private DefaultLibraryModels() {
        }

        @Override
        public ImmutableSetMultimap<LibraryModels.MethodRef, Integer> failIfNullParameters() {
            return FAIL_IF_NULL_PARAMETERS;
        }

        @Override
        public ImmutableSetMultimap<LibraryModels.MethodRef, Integer> explicitlyNullableParameters() {
            return EXPLICITLY_NULLABLE_PARAMETERS;
        }

        @Override
        public ImmutableSetMultimap<LibraryModels.MethodRef, Integer> nonNullParameters() {
            return NON_NULL_PARAMETERS;
        }

        @Override
        public ImmutableSetMultimap<LibraryModels.MethodRef, Integer> nullImpliesTrueParameters() {
            return NULL_IMPLIES_TRUE_PARAMETERS;
        }

        @Override
        public ImmutableSetMultimap<LibraryModels.MethodRef, Integer> nullImpliesFalseParameters() {
            return NULL_IMPLIES_FALSE_PARAMETERS;
        }

        @Override
        public ImmutableSetMultimap<LibraryModels.MethodRef, Integer> nullImpliesNullParameters() {
            return NULL_IMPLIES_NULL_PARAMETERS;
        }

        @Override
        public ImmutableSet<LibraryModels.MethodRef> nullableReturns() {
            return NULLABLE_RETURNS;
        }

        @Override
        public ImmutableSet<LibraryModels.MethodRef> nonNullReturns() {
            return NONNULL_RETURNS;
        }
    }
}

