/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway.handlers;

import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import shadow.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import shadow.checkerframework.dataflow.cfg.node.Node;

class MethodNameUtil {
    private static final String IS_NOT_NULL_METHOD = "isNotNull";
    private static final String IS_NOT_NULL_OWNER = "com.google.common.truth.Subject";
    private static final String IS_TRUE_METHOD = "isTrue";
    private static final String IS_TRUE_OWNER = "com.google.common.truth.BooleanSubject";
    private static final String ASSERT_THAT_METHOD = "assertThat";
    private static final String ASSERT_THAT_OWNER = "com.google.common.truth.Truth";
    private static final String HAMCREST_ASSERT_CLASS = "org.hamcrest.MatcherAssert";
    private static final String JUNIT_ASSERT_CLASS = "org.junit.Assert";
    private static final String MATCHERS_CLASS = "org.hamcrest.Matchers";
    private static final String CORE_MATCHERS_CLASS = "org.hamcrest.CoreMatchers";
    private static final String CORE_IS_NULL_CLASS = "org.hamcrest.core.IsNull";
    private static final String IS_MATCHER = "is";
    private static final String NOT_MATCHER = "not";
    private static final String NOT_NULL_VALUE_MATCHER = "notNullValue";
    private static final String NULL_VALUE_MATCHER = "nullValue";
    private Name isNotNull;
    private Name isNotNullOwner;
    private Name isTrue;
    private Name isTrueOwner;
    private Name assertThat;
    private Name assertThatOwner;
    private Name hamcrestAssertClass;
    private Name junitAssertClass;
    private Name matchersClass;
    private Name coreMatchersClass;
    private Name coreIsNullClass;
    private Name isMatcher;
    private Name notMatcher;
    private Name notNullValueMatcher;
    private Name nullValueMatcher;

    MethodNameUtil() {
    }

    void initializeMethodNames(Name.Table table) {
        this.isNotNull = table.fromString(IS_NOT_NULL_METHOD);
        this.isNotNullOwner = table.fromString(IS_NOT_NULL_OWNER);
        this.isTrue = table.fromString(IS_TRUE_METHOD);
        this.isTrueOwner = table.fromString(IS_TRUE_OWNER);
        this.assertThat = table.fromString(ASSERT_THAT_METHOD);
        this.assertThatOwner = table.fromString(ASSERT_THAT_OWNER);
        this.hamcrestAssertClass = table.fromString(HAMCREST_ASSERT_CLASS);
        this.junitAssertClass = table.fromString(JUNIT_ASSERT_CLASS);
        this.matchersClass = table.fromString(MATCHERS_CLASS);
        this.coreMatchersClass = table.fromString(CORE_MATCHERS_CLASS);
        this.coreIsNullClass = table.fromString(CORE_IS_NULL_CLASS);
        this.isMatcher = table.fromString(IS_MATCHER);
        this.notMatcher = table.fromString(NOT_MATCHER);
        this.notNullValueMatcher = table.fromString(NOT_NULL_VALUE_MATCHER);
        this.nullValueMatcher = table.fromString(NULL_VALUE_MATCHER);
    }

    boolean isMethodIsNotNull(Symbol.MethodSymbol methodSymbol) {
        return this.matchesMethod(methodSymbol, this.isNotNull, this.isNotNullOwner);
    }

    boolean isMethodIsTrue(Symbol.MethodSymbol methodSymbol) {
        return this.matchesMethod(methodSymbol, this.isTrue, this.isTrueOwner);
    }

    boolean isMethodAssertThat(Symbol.MethodSymbol methodSymbol) {
        return this.matchesMethod(methodSymbol, this.assertThat, this.assertThatOwner);
    }

    boolean isMethodHamcrestAssertThat(Symbol.MethodSymbol methodSymbol) {
        return this.matchesMethod(methodSymbol, this.assertThat, this.hamcrestAssertClass);
    }

    boolean isMethodJunitAssertThat(Symbol.MethodSymbol methodSymbol) {
        return this.matchesMethod(methodSymbol, this.assertThat, this.junitAssertClass);
    }

    boolean isMatcherIsNotNull(Node node) {
        if (this.matchesMatcherMethod(node, this.isMatcher, this.matchersClass) || this.matchesMatcherMethod(node, this.isMatcher, this.coreMatchersClass)) {
            return this.isMatcherNotNull(((MethodInvocationNode)node).getArgument(0));
        }
        return false;
    }

    private boolean isMatcherNotNull(Node node) {
        if (this.matchesMatcherMethod(node, this.notMatcher, this.matchersClass) || this.matchesMatcherMethod(node, this.notMatcher, this.coreMatchersClass)) {
            return this.isMatcherNull(((MethodInvocationNode)node).getArgument(0));
        }
        return this.matchesMatcherMethod(node, this.notNullValueMatcher, this.matchersClass) || this.matchesMatcherMethod(node, this.notNullValueMatcher, this.coreMatchersClass) || this.matchesMatcherMethod(node, this.notNullValueMatcher, this.coreIsNullClass);
    }

    private boolean isMatcherNull(Node node) {
        return this.matchesMatcherMethod(node, this.nullValueMatcher, this.matchersClass) || this.matchesMatcherMethod(node, this.nullValueMatcher, this.coreMatchersClass) || this.matchesMatcherMethod(node, this.nullValueMatcher, this.coreIsNullClass);
    }

    private boolean matchesMatcherMethod(Node node, Name matcherName, Name matcherClass) {
        if (node instanceof MethodInvocationNode) {
            MethodInvocationNode methodInvocationNode = (MethodInvocationNode)node;
            Symbol.MethodSymbol callee = ASTHelpers.getSymbol((MethodInvocationTree)methodInvocationNode.getTree());
            return this.matchesMethod(callee, matcherName, matcherClass);
        }
        return false;
    }

    private boolean matchesMethod(Symbol.MethodSymbol methodSymbol, Name toMatchMethodName, Name toMatchOwnerName) {
        return methodSymbol.name.equals(toMatchMethodName) && methodSymbol.owner.getQualifiedName().equals(toMatchOwnerName);
    }

    boolean isUtilInitialized() {
        return this.isNotNull != null;
    }
}

