/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway.handlers;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.uber.nullaway.Config;
import com.uber.nullaway.ErrorMessage;
import com.uber.nullaway.NullAway;
import com.uber.nullaway.Nullness;
import com.uber.nullaway.dataflow.AccessPath;
import com.uber.nullaway.dataflow.AccessPathElement;
import com.uber.nullaway.dataflow.AccessPathNullnessAnalysis;
import com.uber.nullaway.dataflow.AccessPathNullnessPropagation;
import com.uber.nullaway.handlers.BaseNoOpHandler;
import com.uber.nullaway.handlers.Handler;
import com.uber.nullaway.handlers.MethodNameUtil;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import shadow.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import shadow.checkerframework.dataflow.cfg.node.Node;

public class OptionalEmptinessHandler
extends BaseNoOpHandler {
    @Nullable
    private ImmutableSet<Type> optionalTypes;
    private NullAway analysis;
    private final Config config;
    private final MethodNameUtil methodNameUtil;
    public static final VariableElement OPTIONAL_CONTENT = OptionalEmptinessHandler.getOptionalContentElement();

    OptionalEmptinessHandler(Config config, MethodNameUtil methodNameUtil) {
        this.config = config;
        this.methodNameUtil = methodNameUtil;
    }

    @Override
    public boolean onOverrideMayBeNullExpr(NullAway analysis, ExpressionTree expr, VisitorState state, boolean exprMayBeNull) {
        if (expr.getKind() == Tree.Kind.METHOD_INVOCATION && this.optionalIsGetCall((Symbol.MethodSymbol)ASTHelpers.getSymbol((Tree)expr), state.getTypes())) {
            return true;
        }
        return exprMayBeNull;
    }

    @Override
    public void onMatchTopLevelClass(NullAway analysis, ClassTree tree, VisitorState state, Symbol.ClassSymbol classSymbol) {
        this.analysis = analysis;
        this.optionalTypes = (ImmutableSet)this.config.getOptionalClassPaths().stream().map(arg_0 -> ((VisitorState)state).getTypeFromString(arg_0)).filter(Objects::nonNull).map(state.getTypes()::erasure).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public Handler.NullnessHint onDataflowVisitMethodInvocation(MethodInvocationNode node, Types types, Context context, AccessPathNullnessPropagation.SubNodeValues inputs, AccessPathNullnessPropagation.Updates thenUpdates, AccessPathNullnessPropagation.Updates elseUpdates, AccessPathNullnessPropagation.Updates bothUpdates) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodInvocationTree)node.getTree());
        if (this.optionalIsPresentCall(symbol, types)) {
            this.updateNonNullAPsForOptionalContent(thenUpdates, node.getTarget().getReceiver());
        } else if (this.config.handleTestAssertionLibraries() && this.methodNameUtil.isMethodIsTrue(symbol)) {
            this.updateIfAssertIsPresentTrueOnOptional(node, types, bothUpdates);
        }
        return Handler.NullnessHint.UNKNOWN;
    }

    @Override
    public Optional<ErrorMessage> onExpressionDereference(ExpressionTree expr, ExpressionTree baseExpr, VisitorState state) {
        if (ASTHelpers.getSymbol((Tree)expr) instanceof Symbol.MethodSymbol && this.optionalIsGetCall((Symbol.MethodSymbol)ASTHelpers.getSymbol((Tree)expr), state.getTypes()) && this.isOptionalContentNullable(state, baseExpr, this.analysis.getNullnessAnalysis(state))) {
            String message = "Invoking get() on possibly empty Optional " + baseExpr;
            return Optional.of(new ErrorMessage(ErrorMessage.MessageTypes.GET_ON_EMPTY_OPTIONAL, message));
        }
        return Optional.empty();
    }

    private boolean isOptionalContentNullable(VisitorState state, ExpressionTree baseExpr, AccessPathNullnessAnalysis analysis) {
        return analysis.getNullnessOfExpressionNamedField(new TreePath(state.getPath(), baseExpr), state.context, OPTIONAL_CONTENT) == Nullness.NULLABLE;
    }

    @Override
    public boolean includeApInfoInSavedContext(AccessPath accessPath, VisitorState state) {
        AccessPath.Root root;
        if (accessPath.getElements().size() == 1 && !(root = accessPath.getRoot()).isReceiver()) {
            Element e = root.getVarElement();
            return e.getKind().equals((Object)ElementKind.LOCAL_VARIABLE) && ((AccessPathElement)accessPath.getElements().get(0)).getJavaElement().equals(OPTIONAL_CONTENT);
        }
        return false;
    }

    private void updateIfAssertIsPresentTrueOnOptional(MethodInvocationNode node, Types types, AccessPathNullnessPropagation.Updates bothUpdates) {
        MethodInvocationNode argMethod;
        Symbol.MethodSymbol argSymbol;
        Node unwrappedArg;
        Node arg;
        MethodInvocationNode receiverMethod;
        Symbol.MethodSymbol receiverSymbol;
        Node receiver = node.getTarget().getReceiver();
        if (receiver instanceof MethodInvocationNode && this.methodNameUtil.isMethodAssertThat(receiverSymbol = ASTHelpers.getSymbol((MethodInvocationTree)(receiverMethod = (MethodInvocationNode)receiver).getTree())) && (arg = receiverMethod.getArgument(0)) instanceof MethodInvocationNode && (unwrappedArg = ((MethodInvocationNode)arg).getArgument(0)) instanceof MethodInvocationNode && this.optionalIsPresentCall(argSymbol = ASTHelpers.getSymbol((MethodInvocationTree)(argMethod = (MethodInvocationNode)unwrappedArg).getTree()), types)) {
            this.updateNonNullAPsForOptionalContent(bothUpdates, argMethod.getTarget().getReceiver());
        }
    }

    private void updateNonNullAPsForOptionalContent(AccessPathNullnessPropagation.Updates updates, Node base) {
        AccessPath ap = AccessPath.fromBaseAndElement(base, OPTIONAL_CONTENT);
        if (ap != null && base.getTree() != null) {
            updates.set(ap, Nullness.NONNULL);
        }
    }

    private boolean optionalIsPresentCall(Symbol.MethodSymbol symbol, Types types) {
        for (Type optionalType : this.optionalTypes) {
            if (!((Name)symbol.getSimpleName()).toString().equals("isPresent") || ((List)symbol.getParameters()).length() != 0 || !types.isSubtype(symbol.owner.type, optionalType)) continue;
            return true;
        }
        return false;
    }

    private boolean optionalIsGetCall(Symbol.MethodSymbol symbol, Types types) {
        for (Type optionalType : this.optionalTypes) {
            if (!((Name)symbol.getSimpleName()).toString().equals("get") || ((List)symbol.getParameters()).length() != 0 || !types.isSubtype(symbol.owner.type, optionalType)) continue;
            return true;
        }
        return false;
    }

    private static VariableElement getOptionalContentElement() {
        return new VariableElement(){

            @Override
            public Object getConstantValue() {
                return null;
            }

            @Override
            public javax.lang.model.element.Name getSimpleName() {
                return null;
            }

            @Override
            public Element getEnclosingElement() {
                return null;
            }

            @Override
            public java.util.List<? extends Element> getEnclosedElements() {
                return null;
            }

            @Override
            public java.util.List<? extends AnnotationMirror> getAnnotationMirrors() {
                return null;
            }

            @Override
            public <A extends Annotation> A getAnnotation(Class<A> aClass) {
                return null;
            }

            @Override
            public <A extends Annotation> A[] getAnnotationsByType(Class<A> aClass) {
                return null;
            }

            @Override
            public <R, P> R accept(ElementVisitor<R, P> elementVisitor, P p) {
                return null;
            }

            @Override
            public TypeMirror asType() {
                return null;
            }

            @Override
            public ElementKind getKind() {
                return null;
            }

            @Override
            public Set<Modifier> getModifiers() {
                return null;
            }

            public String toString() {
                return "OPTIONAL_CONTENT";
            }
        };
    }
}

