/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway.handlers;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.uber.nullaway.Config;
import com.uber.nullaway.NullAway;
import com.uber.nullaway.NullabilityUtil;
import com.uber.nullaway.Nullness;
import com.uber.nullaway.dataflow.AccessPathNullnessPropagation;
import com.uber.nullaway.handlers.BaseNoOpHandler;
import com.uber.nullaway.handlers.Handler;
import java.util.Collection;
import java.util.HashSet;
import shadow.checkerframework.dataflow.cfg.node.MethodInvocationNode;

public class RestrictiveAnnotationHandler
extends BaseNoOpHandler {
    private final Config config;

    RestrictiveAnnotationHandler(Config config) {
        this.config = config;
    }

    @Override
    public ImmutableSet<Integer> onUnannotatedInvocationGetNonNullPositions(NullAway analysis, VisitorState state, Symbol.MethodSymbol methodSymbol, java.util.List<? extends ExpressionTree> actualParams, ImmutableSet<Integer> nonNullPositions) {
        HashSet<Integer> positions = new HashSet<Integer>();
        positions.addAll((Collection<Integer>)nonNullPositions);
        for (int i = 0; i < ((List)methodSymbol.getParameters()).size(); ++i) {
            if (!Nullness.paramHasNonNullAnnotation(methodSymbol, i, this.config)) continue;
            positions.add(i);
        }
        return ImmutableSet.copyOf(positions);
    }

    @Override
    public boolean onOverrideMayBeNullExpr(NullAway analysis, ExpressionTree expr, VisitorState state, boolean exprMayBeNull) {
        if (expr.getKind().equals((Object)Tree.Kind.METHOD_INVOCATION)) {
            Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodInvocationTree)((MethodInvocationTree)expr));
            if (NullabilityUtil.isUnannotated(methodSymbol, this.config)) {
                if (this.config.treatGeneratedAsUnannotated() && NullabilityUtil.isGenerated(methodSymbol)) {
                    return exprMayBeNull;
                }
                return Nullness.hasNullableAnnotation(methodSymbol, this.config) || exprMayBeNull;
            }
            return exprMayBeNull;
        }
        return exprMayBeNull;
    }

    @Override
    public ImmutableSet<Integer> onUnannotatedInvocationGetExplicitlyNullablePositions(Context context, Symbol.MethodSymbol methodSymbol, ImmutableSet<Integer> explicitlyNullablePositions) {
        HashSet<Integer> positions = new HashSet<Integer>();
        positions.addAll((Collection<Integer>)explicitlyNullablePositions);
        for (int i = 0; i < ((List)methodSymbol.getParameters()).size(); ++i) {
            if (!Nullness.paramHasNullableAnnotation(methodSymbol, i, this.config)) continue;
            positions.add(i);
        }
        return ImmutableSet.copyOf(positions);
    }

    @Override
    public boolean onUnannotatedInvocationGetExplicitlyNonNullReturn(Symbol.MethodSymbol methodSymbol, boolean explicitlyNonNullReturn) {
        return Nullness.hasNonNullAnnotation(methodSymbol, this.config) || explicitlyNonNullReturn;
    }

    @Override
    public Handler.NullnessHint onDataflowVisitMethodInvocation(MethodInvocationNode node, Types types, Context context, AccessPathNullnessPropagation.SubNodeValues inputs, AccessPathNullnessPropagation.Updates thenUpdates, AccessPathNullnessPropagation.Updates elseUpdates, AccessPathNullnessPropagation.Updates bothUpdates) {
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodInvocationTree)node.getTree());
        if (NullabilityUtil.isUnannotated(methodSymbol, this.config) && Nullness.hasNullableAnnotation(methodSymbol, this.config)) {
            return Handler.NullnessHint.HINT_NULLABLE;
        }
        return Handler.NullnessHint.UNKNOWN;
    }
}

