/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway.handlers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.VisitorState;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.uber.nullaway.NullAway;
import com.uber.nullaway.NullabilityUtil;
import com.uber.nullaway.Nullness;
import com.uber.nullaway.dataflow.AccessPath;
import com.uber.nullaway.dataflow.AccessPathElement;
import com.uber.nullaway.dataflow.AccessPathNullnessAnalysis;
import com.uber.nullaway.dataflow.NullnessStore;
import com.uber.nullaway.handlers.BaseNoOpHandler;
import com.uber.nullaway.handlers.stream.MaplikeMethodRecord;
import com.uber.nullaway.handlers.stream.MaplikeToFilterInstanceRecord;
import com.uber.nullaway.handlers.stream.StreamTypeRecord;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import shadow.checkerframework.dataflow.cfg.UnderlyingAST;
import shadow.checkerframework.dataflow.cfg.node.LocalVariableNode;

class StreamNullabilityPropagator
extends BaseNoOpHandler {
    private final Set<Tree> filterMethodOrLambdaSet = new LinkedHashSet<Tree>();
    private final Map<MethodInvocationTree, MethodInvocationTree> observableOuterCallInChain = new LinkedHashMap<MethodInvocationTree, MethodInvocationTree>();
    private final Map<MethodInvocationTree, Tree> observableCallToInnerMethodOrLambda = new LinkedHashMap<MethodInvocationTree, Tree>();
    private final Map<Tree, MaplikeToFilterInstanceRecord> mapToFilterMap = new LinkedHashMap<Tree, MaplikeToFilterInstanceRecord>();
    private final Map<Tree, NullnessStore> filterToNSMap = new LinkedHashMap<Tree, NullnessStore>();
    private final Map<Tree, Tree> bodyToMethodOrLambda = new LinkedHashMap<Tree, Tree>();
    private final Map<ReturnTree, Tree> returnToEnclosingMethodOrLambda = new LinkedHashMap<ReturnTree, Tree>();
    private final Map<ExpressionTree, LambdaExpressionTree> expressionBodyToFilterLambda = new LinkedHashMap<ExpressionTree, LambdaExpressionTree>();
    private final ImmutableList<StreamTypeRecord> models;

    StreamNullabilityPropagator(ImmutableList<StreamTypeRecord> models) {
        this.models = models;
    }

    @Override
    public void onMatchTopLevelClass(NullAway analysis, ClassTree tree, VisitorState state, Symbol.ClassSymbol classSymbol) {
        this.filterMethodOrLambdaSet.clear();
        this.observableOuterCallInChain.clear();
        this.observableCallToInnerMethodOrLambda.clear();
        this.mapToFilterMap.clear();
        this.filterToNSMap.clear();
        this.bodyToMethodOrLambda.clear();
        this.returnToEnclosingMethodOrLambda.clear();
    }

    @Override
    public void onMatchMethodInvocation(NullAway analysis, MethodInvocationTree tree, VisitorState state, Symbol.MethodSymbol methodSymbol) {
        Type receiverType = ASTHelpers.getReceiverType((ExpressionTree)tree);
        for (StreamTypeRecord streamType : this.models) {
            ClassTree annonClassBody;
            ExpressionTree argTree;
            if (!streamType.matchesType(receiverType, state)) continue;
            this.buildObservableCallChain(tree);
            if (streamType.isFilterMethod(methodSymbol) && ((List)methodSymbol.getParameters()).length() == 1) {
                argTree = tree.getArguments().get(0);
                if (argTree instanceof NewClassTree) {
                    annonClassBody = ((NewClassTree)argTree).getClassBody();
                    if (annonClassBody == null) continue;
                    this.handleFilterAnonClass(streamType, tree, annonClassBody, state);
                    continue;
                }
                if (!(argTree instanceof LambdaExpressionTree)) continue;
                LambdaExpressionTree lambdaTree = (LambdaExpressionTree)argTree;
                this.handleFilterLambda(streamType, tree, lambdaTree, state);
                continue;
            }
            if (!streamType.isMapMethod(methodSymbol) || ((List)methodSymbol.getParameters()).length() != 1) continue;
            argTree = tree.getArguments().get(0);
            if (argTree instanceof NewClassTree) {
                annonClassBody = ((NewClassTree)argTree).getClassBody();
                if (annonClassBody == null) continue;
                MaplikeMethodRecord methodRecord = streamType.getMaplikeMethodRecord(methodSymbol);
                this.handleMapAnonClass(methodRecord, tree, annonClassBody);
                continue;
            }
            if (argTree instanceof LambdaExpressionTree) {
                this.observableCallToInnerMethodOrLambda.put(tree, argTree);
                continue;
            }
            if (!(argTree instanceof MemberReferenceTree)) continue;
            this.observableCallToInnerMethodOrLambda.put(tree, argTree);
        }
    }

    private void buildObservableCallChain(MethodInvocationTree tree) {
        ExpressionTree receiverExpression;
        ExpressionTree methodSelect = tree.getMethodSelect();
        if (methodSelect instanceof MemberSelectTree && (receiverExpression = ((MemberSelectTree)methodSelect).getExpression()) instanceof MethodInvocationTree) {
            this.observableOuterCallInChain.put((MethodInvocationTree)receiverExpression, tree);
        }
    }

    private void handleChainFromFilter(StreamTypeRecord streamType, MethodInvocationTree observableDotFilter, Tree filterMethodOrLambda, VisitorState state) {
        MethodInvocationTree outerCallInChain = observableDotFilter;
        if (outerCallInChain == null) {
            return;
        }
        do {
            Symbol.MethodSymbol mapMethod;
            if (!this.observableCallToInnerMethodOrLambda.containsKey(outerCallInChain = this.observableOuterCallInChain.get(outerCallInChain)) || !streamType.isMapMethod(mapMethod = ASTHelpers.getSymbol((MethodInvocationTree)outerCallInChain))) continue;
            MaplikeToFilterInstanceRecord record = new MaplikeToFilterInstanceRecord(streamType.getMaplikeMethodRecord(mapMethod), filterMethodOrLambda);
            this.mapToFilterMap.put(this.observableCallToInnerMethodOrLambda.get(outerCallInChain), record);
        } while (outerCallInChain != null && streamType.matchesType(ASTHelpers.getReceiverType((ExpressionTree)outerCallInChain), state) && streamType.isPassthroughMethod(ASTHelpers.getSymbol((MethodInvocationTree)outerCallInChain)));
    }

    private void handleFilterAnonClass(StreamTypeRecord streamType, MethodInvocationTree observableDotFilter, ClassTree annonClassBody, VisitorState state) {
        for (Tree tree : annonClassBody.getMembers()) {
            if (!(tree instanceof MethodTree) || !((MethodTree)tree).getName().toString().equals("test")) continue;
            this.filterMethodOrLambdaSet.add(tree);
            this.observableCallToInnerMethodOrLambda.put(observableDotFilter, tree);
            this.handleChainFromFilter(streamType, observableDotFilter, tree, state);
        }
    }

    private void handleFilterLambda(StreamTypeRecord streamType, MethodInvocationTree observableDotFilter, LambdaExpressionTree lambdaTree, VisitorState state) {
        this.filterMethodOrLambdaSet.add(lambdaTree);
        this.observableCallToInnerMethodOrLambda.put(observableDotFilter, lambdaTree);
        this.handleChainFromFilter(streamType, observableDotFilter, lambdaTree, state);
    }

    private void handleMapAnonClass(MaplikeMethodRecord methodRecord, MethodInvocationTree observableDotMap, ClassTree annonClassBody) {
        for (Tree tree : annonClassBody.getMembers()) {
            if (!(tree instanceof MethodTree) || !((MethodTree)tree).getName().toString().equals(methodRecord.getInnerMethodName())) continue;
            this.observableCallToInnerMethodOrLambda.put(observableDotMap, tree);
        }
    }

    @Override
    public void onMatchMethod(NullAway analysis, MethodTree tree, VisitorState state, Symbol.MethodSymbol methodSymbol) {
        if (this.mapToFilterMap.containsKey(tree)) {
            this.bodyToMethodOrLambda.put(tree.getBody(), tree);
        }
    }

    @Override
    public void onMatchLambdaExpression(NullAway analysis, LambdaExpressionTree tree, VisitorState state, Symbol.MethodSymbol methodSymbol) {
        if (this.filterMethodOrLambdaSet.contains(tree) && tree.getBodyKind().equals((Object)LambdaExpressionTree.BodyKind.EXPRESSION)) {
            this.expressionBodyToFilterLambda.put((ExpressionTree)tree.getBody(), tree);
            AccessPathNullnessAnalysis nullnessAnalysis = analysis.getNullnessAnalysis(state);
            nullnessAnalysis.forceRunOnMethod(state.getPath(), state.context);
        }
        if (this.mapToFilterMap.containsKey(tree)) {
            this.bodyToMethodOrLambda.put(tree.getBody(), tree);
        }
    }

    @Override
    public void onMatchMethodReference(NullAway analysis, MemberReferenceTree tree, VisitorState state, Symbol.MethodSymbol methodSymbol) {
        if (this.mapToFilterMap.containsKey(tree) && ((JCTree.JCMemberReference)tree).kind.isUnbound()) {
            MaplikeToFilterInstanceRecord callInstanceRecord = this.mapToFilterMap.get(tree);
            Tree filterTree = callInstanceRecord.getFilter();
            assert (filterTree instanceof MethodTree || filterTree instanceof LambdaExpressionTree);
            NullnessStore filterNullnessStore = this.filterToNSMap.get(filterTree);
            assert (filterNullnessStore != null);
            for (AccessPath ap : filterNullnessStore.getAccessPathsWithValue(Nullness.NONNULL)) {
                Element element;
                ImmutableList<AccessPathElement> elements = ap.getElements();
                if (elements.size() != 1 || !(element = ((AccessPathElement)elements.get(0)).getJavaElement()).getKind().equals((Object)ElementKind.METHOD) || !element.getSimpleName().equals(methodSymbol.getSimpleName()) || ((ExecutableElement)element).getParameters().size() != 0) continue;
                analysis.setComputedNullness(tree, Nullness.NONNULL);
            }
        }
    }

    private boolean canBooleanExpressionEvalToTrue(ExpressionTree expressionTree) {
        if (expressionTree instanceof LiteralTree) {
            LiteralTree expressionAsLiteral = (LiteralTree)expressionTree;
            if (expressionAsLiteral.getValue() instanceof Boolean) {
                return (Boolean)expressionAsLiteral.getValue();
            }
            throw new RuntimeException("not a boolean expression!");
        }
        return true;
    }

    @Override
    public void onMatchReturn(NullAway analysis, ReturnTree tree, VisitorState state) {
        TreePath enclosingMethodOrLambda = NullabilityUtil.findEnclosingMethodOrLambdaOrInitializer(state.getPath());
        if (enclosingMethodOrLambda == null) {
            throw new RuntimeException("no enclosing method, lambda or initializer!");
        }
        if (!(enclosingMethodOrLambda.getLeaf() instanceof MethodTree) && !(enclosingMethodOrLambda.getLeaf() instanceof LambdaExpressionTree)) {
            throw new RuntimeException("return statement outside of a method or lambda! (e.g. in an initializer block)");
        }
        Tree leaf = enclosingMethodOrLambda.getLeaf();
        if (this.filterMethodOrLambdaSet.contains(leaf)) {
            this.returnToEnclosingMethodOrLambda.put(tree, leaf);
            AccessPathNullnessAnalysis nullnessAnalysis = analysis.getNullnessAnalysis(state);
            nullnessAnalysis.forceRunOnMethod(new TreePath(state.getPath(), leaf), state.context);
        }
    }

    @Override
    public NullnessStore.Builder onDataflowInitialStore(UnderlyingAST underlyingAST, java.util.List<LocalVariableNode> parameters, NullnessStore.Builder nullnessBuilder) {
        Tree tree = this.bodyToMethodOrLambda.get(underlyingAST.getCode());
        if (tree == null) {
            return nullnessBuilder;
        }
        assert (tree instanceof MethodTree || tree instanceof LambdaExpressionTree);
        if (this.mapToFilterMap.containsKey(tree)) {
            MaplikeToFilterInstanceRecord callInstanceRecord = this.mapToFilterMap.get(tree);
            Tree filterTree = callInstanceRecord.getFilter();
            assert (filterTree instanceof MethodTree || filterTree instanceof LambdaExpressionTree);
            MaplikeMethodRecord mapMR = callInstanceRecord.getMaplikeMethodRecord();
            for (int argIdx : mapMR.getArgsFromStream()) {
                LocalVariableNode filterLocalName = filterTree instanceof MethodTree ? new LocalVariableNode(((MethodTree)filterTree).getParameters().get(0)) : new LocalVariableNode(((LambdaExpressionTree)filterTree).getParameters().get(0));
                LocalVariableNode mapLocalName = tree instanceof MethodTree ? new LocalVariableNode(((MethodTree)tree).getParameters().get(argIdx)) : new LocalVariableNode(((LambdaExpressionTree)tree).getParameters().get(argIdx));
                NullnessStore filterNullnessStore = this.filterToNSMap.get(filterTree);
                assert (filterNullnessStore != null);
                NullnessStore renamedRootsNullnessStore = filterNullnessStore.uprootAccessPaths((Map<LocalVariableNode, LocalVariableNode>)ImmutableMap.of((Object)filterLocalName, (Object)mapLocalName));
                for (AccessPath ap : renamedRootsNullnessStore.getAccessPathsWithValue(Nullness.NONNULL)) {
                    nullnessBuilder.setInformation(ap, Nullness.NONNULL);
                }
            }
        }
        return nullnessBuilder;
    }

    @Override
    public void onDataflowVisitReturn(ReturnTree tree, NullnessStore thenStore, NullnessStore elseStore) {
        if (this.returnToEnclosingMethodOrLambda.containsKey(tree)) {
            Tree filterTree = this.returnToEnclosingMethodOrLambda.get(tree);
            assert (filterTree instanceof MethodTree || filterTree instanceof LambdaExpressionTree);
            ExpressionTree retExpression = tree.getExpression();
            if (this.canBooleanExpressionEvalToTrue(retExpression)) {
                if (this.filterToNSMap.containsKey(filterTree)) {
                    this.filterToNSMap.put(filterTree, this.filterToNSMap.get(filterTree).leastUpperBound(thenStore));
                } else {
                    this.filterToNSMap.put(filterTree, thenStore);
                }
            }
        }
    }

    @Override
    public void onDataflowVisitLambdaResultExpression(ExpressionTree tree, NullnessStore thenStore, NullnessStore elseStore) {
        if (this.expressionBodyToFilterLambda.containsKey(tree)) {
            LambdaExpressionTree filterTree = this.expressionBodyToFilterLambda.get(tree);
            if (this.canBooleanExpressionEvalToTrue(tree)) {
                this.filterToNSMap.put(filterTree, thenStore);
            }
        }
    }
}

