/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway.handlers.stream;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.predicates.TypePredicate;
import com.uber.nullaway.handlers.stream.MaplikeMethodRecord;
import com.uber.nullaway.handlers.stream.StreamTypeRecord;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class StreamModelBuilder {
    private final List<StreamTypeRecord> typeRecords = new ArrayList<StreamTypeRecord>();
    private TypePredicate tp = null;
    private ImmutableSet.Builder<String> filterMethodSigs;
    private ImmutableSet.Builder<String> filterMethodSimpleNames;
    private ImmutableMap.Builder<String, MaplikeMethodRecord> mapMethodSigToRecord;
    private ImmutableMap.Builder<String, MaplikeMethodRecord> mapMethodSimpleNameToRecord;
    private ImmutableSet.Builder<String> passthroughMethodSigs;
    private ImmutableSet.Builder<String> passthroughMethodSimpleNames;

    private StreamModelBuilder() {
    }

    public static StreamModelBuilder start() {
        return new StreamModelBuilder();
    }

    private void finalizeOpenStreamTypeRecord() {
        if (this.tp != null) {
            this.typeRecords.add(new StreamTypeRecord(this.tp, (ImmutableSet<String>)this.filterMethodSigs.build(), (ImmutableSet<String>)this.filterMethodSimpleNames.build(), (ImmutableMap<String, MaplikeMethodRecord>)this.mapMethodSigToRecord.build(), (ImmutableMap<String, MaplikeMethodRecord>)this.mapMethodSimpleNameToRecord.build(), (ImmutableSet<String>)this.passthroughMethodSigs.build(), (ImmutableSet<String>)this.passthroughMethodSimpleNames.build()));
        }
    }

    public StreamModelBuilder addStreamType(TypePredicate tp) {
        this.finalizeOpenStreamTypeRecord();
        this.tp = tp;
        this.filterMethodSigs = ImmutableSet.builder();
        this.filterMethodSimpleNames = ImmutableSet.builder();
        this.mapMethodSigToRecord = ImmutableMap.builder();
        this.mapMethodSimpleNameToRecord = ImmutableMap.builder();
        this.passthroughMethodSigs = ImmutableSet.builder();
        this.passthroughMethodSimpleNames = ImmutableSet.builder();
        return this;
    }

    public StreamModelBuilder withFilterMethodFromSignature(String filterMethodSig) {
        this.filterMethodSigs.add((Object)filterMethodSig);
        return this;
    }

    public StreamModelBuilder withFilterMethodAllFromName(String methodSimpleName) {
        this.filterMethodSimpleNames.add((Object)methodSimpleName);
        return this;
    }

    public StreamModelBuilder withMapMethodFromSignature(String methodSig, String innerMethodName, ImmutableSet<Integer> argsFromStream) {
        this.mapMethodSigToRecord.put((Object)methodSig, (Object)new MaplikeMethodRecord(innerMethodName, (Set<Integer>)argsFromStream));
        return this;
    }

    public StreamModelBuilder withMapMethodAllFromName(String methodSimpleName, String innerMethodName, ImmutableSet<Integer> argsFromStream) {
        this.mapMethodSimpleNameToRecord.put((Object)methodSimpleName, (Object)new MaplikeMethodRecord(innerMethodName, (Set<Integer>)argsFromStream));
        return this;
    }

    public StreamModelBuilder withPassthroughMethodFromSignature(String passthroughMethodSig) {
        this.passthroughMethodSigs.add((Object)passthroughMethodSig);
        return this;
    }

    public StreamModelBuilder withPassthroughMethodAllFromName(String methodSimpleName) {
        this.passthroughMethodSimpleNames.add((Object)methodSimpleName);
        return this;
    }

    public StreamModelBuilder withUseAndPassthroughMethodFromSignature(String passthroughMethodSig, String innerMethodName, ImmutableSet<Integer> argsFromStream) {
        this.mapMethodSigToRecord.put((Object)passthroughMethodSig, (Object)new MaplikeMethodRecord(innerMethodName, (Set<Integer>)argsFromStream));
        this.passthroughMethodSigs.add((Object)passthroughMethodSig);
        return this;
    }

    public StreamModelBuilder withUseAndPassthroughMethodAllFromName(String methodSimpleName, String innerMethodName, ImmutableSet<Integer> argsFromStream) {
        this.mapMethodSimpleNameToRecord.put((Object)methodSimpleName, (Object)new MaplikeMethodRecord(innerMethodName, (Set<Integer>)argsFromStream));
        this.passthroughMethodSimpleNames.add((Object)methodSimpleName);
        return this;
    }

    public ImmutableList<StreamTypeRecord> end() {
        this.finalizeOpenStreamTypeRecord();
        return ImmutableList.copyOf(this.typeRecords);
    }
}

