/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway.handlers.stream;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.google.errorprone.predicates.TypePredicate;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.uber.nullaway.handlers.stream.MaplikeMethodRecord;

public class StreamTypeRecord {
    private final TypePredicate typePredicate;
    private final ImmutableSet<String> filterMethodSigs;
    private final ImmutableSet<String> filterMethodSimpleNames;
    private final ImmutableMap<String, MaplikeMethodRecord> mapMethodSigToRecord;
    private final ImmutableMap<String, MaplikeMethodRecord> mapMethodSimpleNameToRecord;
    private final ImmutableSet<String> passthroughMethodSigs;
    private final ImmutableSet<String> passthroughMethodSimpleNames;

    public StreamTypeRecord(TypePredicate typePredicate, ImmutableSet<String> filterMethodSigs, ImmutableSet<String> filterMethodSimpleNames, ImmutableMap<String, MaplikeMethodRecord> mapMethodSigToRecord, ImmutableMap<String, MaplikeMethodRecord> mapMethodSimpleNameToRecord, ImmutableSet<String> passthroughMethodSigs, ImmutableSet<String> passthroughMethodSimpleNames) {
        this.typePredicate = typePredicate;
        this.filterMethodSigs = filterMethodSigs;
        this.filterMethodSimpleNames = filterMethodSimpleNames;
        this.mapMethodSigToRecord = mapMethodSigToRecord;
        this.mapMethodSimpleNameToRecord = mapMethodSimpleNameToRecord;
        this.passthroughMethodSigs = passthroughMethodSigs;
        this.passthroughMethodSimpleNames = passthroughMethodSimpleNames;
    }

    public boolean matchesType(Type type, VisitorState state) {
        return this.typePredicate.apply(type, state);
    }

    public boolean isFilterMethod(Symbol.MethodSymbol methodSymbol) {
        return this.filterMethodSigs.contains((Object)methodSymbol.toString()) || this.filterMethodSimpleNames.contains((Object)methodSymbol.getQualifiedName().toString());
    }

    public boolean isMapMethod(Symbol.MethodSymbol methodSymbol) {
        return this.mapMethodSigToRecord.containsKey((Object)methodSymbol.toString()) || this.mapMethodSimpleNameToRecord.containsKey((Object)methodSymbol.getQualifiedName().toString());
    }

    public MaplikeMethodRecord getMaplikeMethodRecord(Symbol.MethodSymbol methodSymbol) {
        MaplikeMethodRecord record = (MaplikeMethodRecord)this.mapMethodSigToRecord.get((Object)methodSymbol.toString());
        if (record == null) {
            record = (MaplikeMethodRecord)this.mapMethodSimpleNameToRecord.get((Object)methodSymbol.getQualifiedName().toString());
        }
        return record;
    }

    public boolean isPassthroughMethod(Symbol.MethodSymbol methodSymbol) {
        return this.passthroughMethodSigs.contains((Object)methodSymbol.toString()) || this.passthroughMethodSimpleNames.contains((Object)methodSymbol.getQualifiedName().toString());
    }
}

