/*
 * Decompiled with CFR 0.152.
 */
package org.plumelib.javadoc;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.tools.doclets.standard.Standard;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import shadow.checkerframework.checker.formatter.qual.Format;
import shadow.checkerframework.checker.formatter.qual.UnknownFormat;
import shadow.checkerframework.checker.index.qual.LessThanUnknown;
import shadow.checkerframework.checker.index.qual.LowerBoundUnknown;
import shadow.checkerframework.checker.index.qual.SameLenUnknown;
import shadow.checkerframework.checker.index.qual.SearchIndexUnknown;
import shadow.checkerframework.checker.index.qual.SubstringIndexUnknown;
import shadow.checkerframework.checker.index.qual.UpperBoundUnknown;
import shadow.checkerframework.checker.initialization.qual.Initialized;
import shadow.checkerframework.checker.interning.qual.Interned;
import shadow.checkerframework.checker.interning.qual.UnknownInterned;
import shadow.checkerframework.checker.lock.qual.GuardSatisfied;
import shadow.checkerframework.checker.lock.qual.GuardedBy;
import shadow.checkerframework.checker.lock.qual.LockPossiblyHeld;
import shadow.checkerframework.checker.nullness.qual.MonotonicNonNull;
import shadow.checkerframework.checker.nullness.qual.NonNull;
import shadow.checkerframework.checker.nullness.qual.NonRaw;
import shadow.checkerframework.checker.nullness.qual.Nullable;
import shadow.checkerframework.checker.nullness.qual.UnknownKeyFor;
import shadow.checkerframework.checker.regex.RegexUtil;
import shadow.checkerframework.checker.regex.qual.UnknownRegex;
import shadow.checkerframework.checker.signature.qual.SignatureUnknown;
import shadow.checkerframework.common.value.qual.ArrayLenRange;
import shadow.checkerframework.common.value.qual.MinLen;
import shadow.checkerframework.common.value.qual.UnknownVal;
import shadow.checkerframework.dataflow.qual.Pure;
import shadow.checkerframework.dataflow.qual.SideEffectFree;

public class RequireJavadoc
extends Standard {
    @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown List<@UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown RequireJavadoc. @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown Undocumented> errors = new ArrayList<Undocumented>();
    @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown Set<@UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown PackageDoc> packages = new HashSet<PackageDoc>();
    static @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown boolean relativePaths = false;
    static @MonotonicNonNull @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown Pattern skip = null;
    private static final @Format(value={}) @Format(value={}) @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown String USAGE = "Provided by RequireJavadoc doclet:%n-skip <classname>      Don't report problems in the given class%n-relative              Report relative rather than absolute filenames%nSee the documentation for more details.%n";

    RequireJavadoc() {
    }

    public static @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown boolean start(@UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown RootDoc root) {
        RequireJavadoc doclet = new RequireJavadoc();
        for (ClassDoc cd2 : root.classes()) {
            doclet.processClass(cd2);
        }
        Path currentPath = Paths.get("", new String[0]).toAbsolutePath();
        Collections.sort(doclet.errors);
        for (Undocumented error : doclet.errors) {
            SourcePosition position = error.position;
            if (position == null) {
                System.err.printf("missing documentation for %s%n", error.name);
                continue;
            }
            File file = position.file();
            Path path = relativePaths ? currentPath.relativize(file.toPath()) : file.toPath();
            System.err.printf("%s:%d: missing documentation for %s%n", file, position.line(), error.name);
        }
        return doclet.errors.isEmpty();
    }

    private void processClass(@UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown ClassDoc cd2) {
        SourcePosition classPosition = cd2.position();
        if (skip != null && (skip.matcher(cd2.name()).find() || skip.matcher(cd2.qualifiedName()).find() || classPosition != null && skip.matcher(classPosition.file().toString()).find())) {
            return;
        }
        this.requireCommentText((Doc)cd2);
        PackageDoc pd = cd2.containingPackage();
        if (this.packages.add(pd)) {
            this.requireCommentText((Doc)pd);
        }
        for (ConstructorDoc constructorDoc : cd2.constructors()) {
            if (constructorDoc.isSynthetic() || this.isSyntheticForNestedConstructor(constructorDoc)) continue;
            this.requireCommentText((Doc)constructorDoc);
        }
        for (ConstructorDoc constructorDoc : cd2.enumConstants()) {
            this.requireCommentText((Doc)constructorDoc);
        }
        for (ConstructorDoc constructorDoc : cd2.fields()) {
            if (constructorDoc.name().equals("serialVersionUID") && constructorDoc.type().toString().equals("long")) continue;
            this.requireCommentText((Doc)constructorDoc);
        }
        for (ConstructorDoc constructorDoc : cd2.innerClasses()) {
            this.requireCommentText((Doc)constructorDoc);
        }
        for (ConstructorDoc constructorDoc : cd2.methods()) {
            if (this.isOverride((MethodDoc)constructorDoc) || constructorDoc.isSynthetic() || this.isEnumValuesOrValueOf((MethodDoc)constructorDoc)) continue;
            this.requireCommentText((Doc)constructorDoc);
        }
    }

    private @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown boolean isOverride(@UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown MethodDoc md) {
        for (AnnotationDesc anno : md.annotations()) {
            if (!anno.toString().equals("@java.lang.Override")) continue;
            return true;
        }
        return false;
    }

    private @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown boolean isSyntheticForNestedConstructor(@UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown ConstructorDoc cd2) {
        SourcePosition constructorPosition = cd2.position();
        if (constructorPosition == null) {
            return false;
        }
        @NonNull ClassDoc containingClass = cd2.containingClass();
        SourcePosition classPosition = containingClass.position();
        assert (classPosition != null) : "@AssumeAssertion(nullness): a class has a position";
        return classPosition.file().equals(constructorPosition.file()) && classPosition.line() == constructorPosition.line();
    }

    private @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown boolean isEnumValuesOrValueOf(@UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown MethodDoc md) {
        return md.containingClass().isEnum() && (md.name().equals("values") && md.parameters().length == 0 || md.name().equals("valueOf") && md.parameters().length == 1 && md.parameters()[0].type().qualifiedTypeName().equals("java.lang.String"));
    }

    private void requireCommentText(@UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown Doc d) {
        if (skip != null && skip.matcher(d.name()).find()) {
            return;
        }
        String text = d.getRawCommentText();
        if (text.isEmpty()) {
            this.errors.add(new Undocumented(d.name(), d.position()));
        }
    }

    public static @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int optionLength(@UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown String option) {
        switch (option) {
            case "-relative": {
                return 1;
            }
            case "-skip": {
                return 2;
            }
        }
        return Standard.optionLength((String)option);
    }

    public static @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown boolean validOptions(@UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown String @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown [] @ArrayLenRange(from=1, to=0x7FFFFFFF) @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @MinLen(value=1) @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown [] options, @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown DocErrorReporter reporter) {
        ArrayList<String[]> remaining = new ArrayList<String[]>();
        block10: for (int oi = 0; oi < options.length; ++oi) {
            String opt;
            String[] os = options[oi];
            switch (opt = os[0].toLowerCase()) {
                case "-relative": {
                    relativePaths = true;
                    continue block10;
                }
                case "-skip": {
                    if (!RegexUtil.isRegex(os[1])) {
                        System.err.printf("Error parsing regex %s %s%n", os[1], RegexUtil.regexError(os[1]));
                        System.exit(2);
                    }
                    skip = Pattern.compile(os[1]);
                    continue block10;
                }
                case "-help": {
                    System.out.printf(USAGE, new Object[0]);
                    return false;
                }
                default: {
                    remaining.add(os);
                }
            }
        }
        return Standard.validOptions((String[][])((String[][])remaining.toArray((T[])new String[0][])), (DocErrorReporter)reporter);
    }

    private class Undocumented
    implements Comparable<Undocumented> {
        final @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown String name;
        final @Nullable @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown SourcePosition position;

        public Undocumented(@Nullable @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown String name, SourcePosition position) {
            this.name = name;
            this.position = position;
        }

        @Override
        @Pure
        public @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int compareTo(@UnknownVal @GuardSatisfied @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown Undocumented this, @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown RequireJavadoc. @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown Undocumented other) {
            if (other.position == null) {
                return -1;
            }
            if (this.position == null) {
                return 1;
            }
            File thisFile = this.position.file();
            File otherFile = other.position.file();
            if (thisFile == null) {
                return 1;
            }
            int cmp = thisFile.compareTo(otherFile);
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.position.line() - other.position.line();
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.position.column() - other.position.column();
            return cmp;
        }

        @SideEffectFree
        public @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown String toString(@UnknownVal @GuardSatisfied @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown Undocumented this) {
            return String.format("Undocumented(%s, %s)", this.name, this.position);
        }
    }
}

