/*
 * Decompiled with CFR 0.152.
 */
package org.plumelib.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import shadow.checkerframework.checker.formatter.qual.UnknownFormat;
import shadow.checkerframework.checker.index.qual.LessThanUnknown;
import shadow.checkerframework.checker.index.qual.LowerBoundUnknown;
import shadow.checkerframework.checker.index.qual.SameLenUnknown;
import shadow.checkerframework.checker.index.qual.SearchIndexUnknown;
import shadow.checkerframework.checker.index.qual.SubstringIndexBottom;
import shadow.checkerframework.checker.index.qual.SubstringIndexUnknown;
import shadow.checkerframework.checker.index.qual.UpperBoundUnknown;
import shadow.checkerframework.checker.initialization.qual.Initialized;
import shadow.checkerframework.checker.interning.qual.Interned;
import shadow.checkerframework.checker.interning.qual.UnknownInterned;
import shadow.checkerframework.checker.lock.qual.GuardedBy;
import shadow.checkerframework.checker.lock.qual.LockPossiblyHeld;
import shadow.checkerframework.checker.nullness.qual.NonNull;
import shadow.checkerframework.checker.nullness.qual.NonRaw;
import shadow.checkerframework.checker.nullness.qual.UnknownKeyFor;
import shadow.checkerframework.checker.regex.qual.UnknownRegex;
import shadow.checkerframework.checker.signature.qual.SignatureUnknown;
import shadow.checkerframework.common.value.qual.UnknownVal;

public class RandomSelector<@SubstringIndexBottom T> {
    private @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown boolean coinTossMode;
    private @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown double keepProbability = -1.0;
    private @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int numElts = -1;
    private @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int observed = -1;
    private @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown Random generator;
    private @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown ArrayList<T> values = new ArrayList();

    public RandomSelector(@UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int numElts) {
        this(numElts, new Random());
    }

    public RandomSelector(@UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int numElts, @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown Random r) {
        this.coinTossMode = false;
        this.numElts = numElts;
        this.observed = 0;
        this.generator = r;
    }

    public RandomSelector(@UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown double keepProbability, @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown Random r) {
        this.coinTossMode = true;
        this.keepProbability = keepProbability;
        this.generator = r;
    }

    public void accept(T next) {
        int n;
        if (this.coinTossMode) {
            if (this.generator.nextDouble() < this.keepProbability) {
                this.values.add(next);
            }
            return;
        }
        ++this.observed;
        if (this.generator.nextDouble() < (double)this.numElts / (double)n) {
            if (this.values.size() < this.numElts) {
                this.values.add(next);
            } else {
                int rem = this.generator.nextInt(this.values.size());
                this.values.set(rem, next);
            }
        }
    }

    public @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown List<T> getValues() {
        ArrayList<T> ret = new ArrayList<T>();
        ret.addAll(this.values);
        return ret;
    }
}

