/*
 * Decompiled with CFR 0.152.
 */
package shadow.checkerframework.dataflow.analysis;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import shadow.checkerframework.checker.nullness.qual.Nullable;
import shadow.checkerframework.dataflow.analysis.AbstractValue;
import shadow.checkerframework.dataflow.analysis.AnalysisResult;
import shadow.checkerframework.dataflow.analysis.RegularTransferResult;
import shadow.checkerframework.dataflow.analysis.Store;
import shadow.checkerframework.dataflow.analysis.TransferFunction;
import shadow.checkerframework.dataflow.analysis.TransferInput;
import shadow.checkerframework.dataflow.analysis.TransferResult;
import shadow.checkerframework.dataflow.cfg.ControlFlowGraph;
import shadow.checkerframework.dataflow.cfg.UnderlyingAST;
import shadow.checkerframework.dataflow.cfg.block.Block;
import shadow.checkerframework.dataflow.cfg.block.ConditionalBlock;
import shadow.checkerframework.dataflow.cfg.block.ExceptionBlock;
import shadow.checkerframework.dataflow.cfg.block.RegularBlock;
import shadow.checkerframework.dataflow.cfg.block.SpecialBlock;
import shadow.checkerframework.dataflow.cfg.node.AssignmentNode;
import shadow.checkerframework.dataflow.cfg.node.LocalVariableNode;
import shadow.checkerframework.dataflow.cfg.node.Node;
import shadow.checkerframework.dataflow.cfg.node.ReturnNode;
import shadow.checkerframework.javacutil.ElementUtils;
import shadow.checkerframework.javacutil.Pair;

public class Analysis<A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> {
    protected boolean isRunning = false;
    protected T transferFunction;
    protected ControlFlowGraph cfg;
    protected final ProcessingEnvironment env;
    protected final Types types;
    protected final IdentityHashMap<Block, S> thenStores;
    protected final IdentityHashMap<Block, S> elseStores;
    protected final IdentityHashMap<Block, Integer> blockCount;
    protected final int maxCountBeforeWidening;
    protected final IdentityHashMap<Block, TransferInput<A, S>> inputs;
    protected final IdentityHashMap<ReturnNode, TransferResult<A, S>> storesAtReturnStatements;
    protected final Worklist worklist;
    protected final IdentityHashMap<Node, A> nodeValues;
    public final HashMap<Element, A> finalLocalValues;
    protected Node currentNode;
    protected Tree currentTree;
    protected TransferInput<A, S> currentInput;

    public Tree getCurrentTree() {
        return this.currentTree;
    }

    public void setCurrentTree(Tree currentTree) {
        this.currentTree = currentTree;
    }

    public Analysis(ProcessingEnvironment env) {
        this(null, -1, env);
    }

    public Analysis(T transfer, ProcessingEnvironment env) {
        this(transfer, -1, env);
    }

    public Analysis(T transfer, int maxCountBeforeWidening, ProcessingEnvironment env) {
        this.env = env;
        this.types = env.getTypeUtils();
        this.transferFunction = transfer;
        this.maxCountBeforeWidening = maxCountBeforeWidening;
        this.thenStores = new IdentityHashMap();
        this.elseStores = new IdentityHashMap();
        this.blockCount = maxCountBeforeWidening == -1 ? null : new IdentityHashMap();
        this.inputs = new IdentityHashMap();
        this.storesAtReturnStatements = new IdentityHashMap();
        this.worklist = new Worklist();
        this.nodeValues = new IdentityHashMap();
        this.finalLocalValues = new HashMap();
    }

    public T getTransferFunction() {
        return this.transferFunction;
    }

    public Types getTypes() {
        return this.types;
    }

    public ProcessingEnvironment getEnv() {
        return this.env;
    }

    public void performAnalysis(ControlFlowGraph cfg) {
        assert (!this.isRunning);
        this.isRunning = true;
        try {
            this.init(cfg);
            while (!this.worklist.isEmpty()) {
                Block b = this.worklist.poll();
                this.performAnalysisBlock(b);
            }
        }
        finally {
            assert (this.isRunning);
            this.isRunning = false;
        }
    }

    protected void performAnalysisBlock(Block b) {
        switch (b.getType()) {
            case REGULAR_BLOCK: {
                RegularBlock rb = (RegularBlock)b;
                TransferInput<A, S> inputBefore = this.getInputBefore(rb);
                this.currentInput = inputBefore.copy();
                TransferResult<A, S> transferResult = null;
                Node lastNode = null;
                boolean addToWorklistAgain = false;
                for (Node n : rb.getContents()) {
                    transferResult = this.callTransferFunction(n, this.currentInput);
                    addToWorklistAgain |= this.updateNodeValues(n, transferResult);
                    this.currentInput = new TransferInput(n, this, transferResult);
                    lastNode = n;
                }
                Block succ = rb.getSuccessor();
                assert (succ != null) : "regular basic block without non-exceptional successor unexpected";
                this.propagateStoresTo(succ, lastNode, this.currentInput, rb.getFlowRule(), addToWorklistAgain);
                break;
            }
            case EXCEPTION_BLOCK: {
                ExceptionBlock eb = (ExceptionBlock)b;
                TransferInput<A, S> inputBefore = this.getInputBefore(eb);
                this.currentInput = inputBefore.copy();
                Node node = eb.getNode();
                TransferResult<A, S> transferResult = this.callTransferFunction(node, this.currentInput);
                boolean addToWorklistAgain = this.updateNodeValues(node, transferResult);
                Block succ = eb.getSuccessor();
                if (succ != null) {
                    this.currentInput = new TransferInput(node, this, transferResult);
                    this.propagateStoresTo(succ, node, this.currentInput, eb.getFlowRule(), addToWorklistAgain);
                }
                for (Map.Entry<TypeMirror, Set<Block>> e : eb.getExceptionalSuccessors().entrySet()) {
                    TypeMirror cause = e.getKey();
                    S exceptionalStore = transferResult.getExceptionalStore(cause);
                    if (exceptionalStore != null) {
                        for (Block exceptionSucc : e.getValue()) {
                            this.addStoreBefore(exceptionSucc, node, exceptionalStore, Store.Kind.BOTH, addToWorklistAgain);
                        }
                        continue;
                    }
                    for (Block exceptionSucc : e.getValue()) {
                        this.addStoreBefore(exceptionSucc, node, inputBefore.copy().getRegularStore(), Store.Kind.BOTH, addToWorklistAgain);
                    }
                }
                break;
            }
            case CONDITIONAL_BLOCK: {
                ConditionalBlock cb = (ConditionalBlock)b;
                TransferInput<A, S> inputBefore = this.getInputBefore(cb);
                TransferInput<A, S> input = inputBefore.copy();
                Block thenSucc = cb.getThenSuccessor();
                Block elseSucc = cb.getElseSuccessor();
                this.propagateStoresTo(thenSucc, null, input, cb.getThenFlowRule(), false);
                this.propagateStoresTo(elseSucc, null, input, cb.getElseFlowRule(), false);
                break;
            }
            case SPECIAL_BLOCK: {
                SpecialBlock sb = (SpecialBlock)b;
                Block succ = sb.getSuccessor();
                if (succ == null) break;
                this.propagateStoresTo(succ, null, this.getInputBefore(b), sb.getFlowRule(), false);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    protected void propagateStoresTo(Block succ, Node node, TransferInput<A, S> currentInput, Store.FlowRule flowRule, boolean addToWorklistAgain) {
        switch (flowRule) {
            case EACH_TO_EACH: {
                if (currentInput.containsTwoStores()) {
                    this.addStoreBefore(succ, node, currentInput.getThenStore(), Store.Kind.THEN, addToWorklistAgain);
                    this.addStoreBefore(succ, node, currentInput.getElseStore(), Store.Kind.ELSE, addToWorklistAgain);
                    break;
                }
                this.addStoreBefore(succ, node, currentInput.getRegularStore(), Store.Kind.BOTH, addToWorklistAgain);
                break;
            }
            case THEN_TO_BOTH: {
                this.addStoreBefore(succ, node, currentInput.getThenStore(), Store.Kind.BOTH, addToWorklistAgain);
                break;
            }
            case ELSE_TO_BOTH: {
                this.addStoreBefore(succ, node, currentInput.getElseStore(), Store.Kind.BOTH, addToWorklistAgain);
                break;
            }
            case THEN_TO_THEN: {
                this.addStoreBefore(succ, node, currentInput.getThenStore(), Store.Kind.THEN, addToWorklistAgain);
                break;
            }
            case ELSE_TO_ELSE: {
                this.addStoreBefore(succ, node, currentInput.getElseStore(), Store.Kind.ELSE, addToWorklistAgain);
            }
        }
    }

    protected boolean updateNodeValues(Node node, TransferResult<A, S> transferResult) {
        A newVal = transferResult.getResultValue();
        boolean nodeValueChanged = false;
        if (newVal != null) {
            AbstractValue oldVal = (AbstractValue)this.nodeValues.get(node);
            this.nodeValues.put(node, newVal);
            nodeValueChanged = !Objects.equals(oldVal, newVal);
        }
        return nodeValueChanged || transferResult.storeChanged();
    }

    protected TransferResult<A, S> callTransferFunction(Node node, TransferInput<A, S> store) {
        LocalVariableNode lhs;
        Element elem;
        AssignmentNode assignment;
        Node lhst;
        if (node.isLValue()) {
            return new RegularTransferResult<Object, S>(null, store.getRegularStore());
        }
        store.node = node;
        this.currentNode = node;
        TransferResult transferResult = (TransferResult)node.accept(this.transferFunction, store);
        this.currentNode = null;
        if (node instanceof ReturnNode) {
            this.storesAtReturnStatements.put((ReturnNode)node, transferResult);
        }
        if (node instanceof AssignmentNode && (lhst = (assignment = (AssignmentNode)node).getTarget()) instanceof LocalVariableNode && ElementUtils.isEffectivelyFinal(elem = (lhs = (LocalVariableNode)lhst).getElement())) {
            this.finalLocalValues.put(elem, transferResult.getResultValue());
        }
        return transferResult;
    }

    protected void init(ControlFlowGraph cfg) {
        this.thenStores.clear();
        this.elseStores.clear();
        if (this.blockCount != null) {
            this.blockCount.clear();
        }
        this.inputs.clear();
        this.storesAtReturnStatements.clear();
        this.nodeValues.clear();
        this.finalLocalValues.clear();
        this.cfg = cfg;
        this.worklist.process(cfg);
        this.worklist.add(cfg.getEntryBlock());
        ArrayList<LocalVariableNode> parameters = null;
        UnderlyingAST underlyingAST = cfg.getUnderlyingAST();
        if (underlyingAST.getKind() == UnderlyingAST.Kind.METHOD) {
            MethodTree tree = ((UnderlyingAST.CFGMethod)underlyingAST).getMethod();
            parameters = new ArrayList<LocalVariableNode>();
            for (VariableTree variableTree : tree.getParameters()) {
                LocalVariableNode var = new LocalVariableNode(variableTree);
                parameters.add(var);
            }
        } else if (underlyingAST.getKind() == UnderlyingAST.Kind.LAMBDA) {
            LambdaExpressionTree lambda = ((UnderlyingAST.CFGLambda)underlyingAST).getLambdaTree();
            parameters = new ArrayList();
            for (VariableTree variableTree : lambda.getParameters()) {
                LocalVariableNode var = new LocalVariableNode(variableTree);
                parameters.add(var);
            }
        }
        Object initialStore = this.transferFunction.initialStore(underlyingAST, parameters);
        SpecialBlock entry = cfg.getEntryBlock();
        this.thenStores.put(entry, initialStore);
        this.elseStores.put(entry, initialStore);
        this.inputs.put(entry, new TransferInput(null, this, initialStore));
    }

    protected void addToWorklist(Block b) {
        if (!this.worklist.contains(b)) {
            this.worklist.add(b);
        }
    }

    protected void addStoreBefore(Block b, Node node, S s2, Store.Kind kind, boolean addBlockToWorklist) {
        S thenStore = this.getStoreBefore(b, Store.Kind.THEN);
        S elseStore = this.getStoreBefore(b, Store.Kind.ELSE);
        boolean shouldWiden = false;
        if (this.blockCount != null) {
            Integer count = this.blockCount.get(b);
            if (count == null) {
                count = 0;
            }
            boolean bl = shouldWiden = count >= this.maxCountBeforeWidening;
            if (shouldWiden) {
                this.blockCount.put(b, 0);
            } else {
                this.blockCount.put(b, count + 1);
            }
        }
        switch (kind) {
            case THEN: {
                S newThenStore = this.mergeStores(s2, thenStore, shouldWiden);
                if (newThenStore.equals(thenStore)) break;
                this.thenStores.put(b, newThenStore);
                if (elseStore == null) break;
                this.inputs.put(b, new TransferInput(node, this, newThenStore, elseStore));
                addBlockToWorklist = true;
                break;
            }
            case ELSE: {
                S newElseStore = this.mergeStores(s2, elseStore, shouldWiden);
                if (newElseStore.equals(elseStore)) break;
                this.elseStores.put(b, newElseStore);
                if (thenStore == null) break;
                this.inputs.put(b, new TransferInput(node, this, thenStore, newElseStore));
                addBlockToWorklist = true;
                break;
            }
            case BOTH: {
                S newElseStore;
                if (thenStore == elseStore) {
                    S newStore = this.mergeStores(s2, thenStore, shouldWiden);
                    if (newStore.equals(thenStore)) break;
                    this.thenStores.put(b, newStore);
                    this.elseStores.put(b, newStore);
                    this.inputs.put(b, new TransferInput(node, this, newStore));
                    addBlockToWorklist = true;
                    break;
                }
                boolean storeChanged = false;
                S newThenStore = this.mergeStores(s2, thenStore, shouldWiden);
                if (!newThenStore.equals(thenStore)) {
                    this.thenStores.put(b, newThenStore);
                    storeChanged = true;
                }
                if (!(newElseStore = this.mergeStores(s2, elseStore, shouldWiden)).equals(elseStore)) {
                    this.elseStores.put(b, newElseStore);
                    storeChanged = true;
                }
                if (!storeChanged) break;
                this.inputs.put(b, new TransferInput(node, this, newThenStore, newElseStore));
                addBlockToWorklist = true;
            }
        }
        if (addBlockToWorklist) {
            this.addToWorklist(b);
        }
    }

    private S mergeStores(S newStore, S previousStore, boolean shouldWiden) {
        if (previousStore == null) {
            return newStore;
        }
        if (shouldWiden) {
            return newStore.widenedUpperBound(previousStore);
        }
        return newStore.leastUpperBound(previousStore);
    }

    public @Nullable TransferInput<A, S> getInput(Block b) {
        return this.getInputBefore(b);
    }

    protected @Nullable TransferInput<A, S> getInputBefore(Block b) {
        return this.inputs.get(b);
    }

    protected @Nullable S getStoreBefore(Block b, Store.Kind kind) {
        switch (kind) {
            case THEN: {
                return (S)((Store)Analysis.readFromStore(this.thenStores, b));
            }
            case ELSE: {
                return (S)((Store)Analysis.readFromStore(this.elseStores, b));
            }
        }
        assert (false);
        return null;
    }

    protected static <S> @Nullable S readFromStore(Map<Block, S> stores, Block b) {
        return stores.get(b);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public @Nullable A getValue(Node n) {
        if (this.isRunning) {
            if (this.currentNode == null || this.currentNode == n || this.currentTree != null && this.currentTree == n.getTree()) {
                return null;
            }
            assert (!n.isLValue()) : "Did not expect an lvalue, but got " + n;
            if (this.currentNode == n || !this.currentNode.getOperands().contains(n) && !this.currentNode.getTransitiveOperands().contains(n)) {
                return null;
            }
            return (A)((AbstractValue)this.nodeValues.get(n));
        }
        return (A)((AbstractValue)this.nodeValues.get(n));
    }

    public IdentityHashMap<Node, A> getNodeValues() {
        return this.nodeValues;
    }

    void setNodeValues(IdentityHashMap<Node, A> in) {
        assert (!this.isRunning);
        this.nodeValues.clear();
        this.nodeValues.putAll(in);
    }

    public @Nullable A getValue(Tree t) {
        if (t == this.currentTree) {
            return null;
        }
        Set<Node> nodesCorrespondingToTree = this.getNodesForTree(t);
        if (nodesCorrespondingToTree == null) {
            return null;
        }
        AbstractValue<Object> merged = null;
        for (Node aNode : nodesCorrespondingToTree) {
            if (aNode.isLValue()) {
                return null;
            }
            A a = this.getValue(aNode);
            if (merged == null) {
                merged = (AbstractValue<Object>)a;
                continue;
            }
            if (a == null) continue;
            merged = merged.leastUpperBound(a);
        }
        return (A)merged;
    }

    public Set<Node> getNodesForTree(Tree t) {
        if (this.cfg == null) {
            return null;
        }
        Set<Node> nodes = this.cfg.getNodesCorrespondingToTree(t);
        return nodes;
    }

    public @Nullable MethodTree getContainingMethod(Tree t) {
        MethodTree mt = this.cfg.getContainingMethod(t);
        return mt;
    }

    public @Nullable ClassTree getContainingClass(Tree t) {
        ClassTree ct = this.cfg.getContainingClass(t);
        return ct;
    }

    public List<Pair<ReturnNode, TransferResult<A, S>>> getReturnStatementStores() {
        ArrayList<Pair<ReturnNode, TransferResult<A, S>>> result = new ArrayList<Pair<ReturnNode, TransferResult<A, S>>>();
        for (ReturnNode returnNode : this.cfg.getReturnNodes()) {
            TransferResult<A, S> store = this.storesAtReturnStatements.get(returnNode);
            result.add(Pair.of(returnNode, store));
        }
        return result;
    }

    public AnalysisResult<A, S> getResult() {
        assert (!this.isRunning);
        return new AnalysisResult<A, S>(this.nodeValues, this.inputs, this.cfg.getTreeLookup(), this.cfg.getUnaryAssignNodeLookup(), this.finalLocalValues);
    }

    public @Nullable S getRegularExitStore() {
        SpecialBlock regularExitBlock = this.cfg.getRegularExitBlock();
        if (this.inputs.containsKey(regularExitBlock)) {
            S regularExitStore = this.inputs.get(regularExitBlock).getRegularStore();
            return regularExitStore;
        }
        return null;
    }

    public S getExceptionalExitStore() {
        S exceptionalExitStore = this.inputs.get(this.cfg.getExceptionalExitBlock()).getRegularStore();
        return exceptionalExitStore;
    }

    protected static class Worklist {
        protected final IdentityHashMap<Block, Integer> depthFirstOrder = new IdentityHashMap();
        protected final PriorityQueue<Block> queue = new PriorityQueue<Block>(11, new DFOComparator());

        public void process(ControlFlowGraph cfg) {
            this.depthFirstOrder.clear();
            int count = 1;
            for (Block b : cfg.getDepthFirstOrderedBlocks()) {
                this.depthFirstOrder.put(b, count++);
            }
            this.queue.clear();
        }

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public boolean contains(Block block) {
            return this.queue.contains(block);
        }

        public void add(Block block) {
            this.queue.add(block);
        }

        public Block poll() {
            return this.queue.poll();
        }

        public String toString() {
            return "Worklist(" + this.queue + ")";
        }

        public class DFOComparator
        implements Comparator<Block> {
            @Override
            public int compare(Block b1, Block b2) {
                return Worklist.this.depthFirstOrder.get(b1) - Worklist.this.depthFirstOrder.get(b2);
            }
        }
    }
}

