/*
 * Decompiled with CFR 0.152.
 */
package shadow.checkerframework.dataflow.analysis;

import java.util.Map;
import javax.lang.model.type.TypeMirror;
import shadow.checkerframework.checker.nullness.qual.Nullable;
import shadow.checkerframework.dataflow.analysis.AbstractValue;
import shadow.checkerframework.dataflow.analysis.Store;

public abstract class TransferResult<A extends AbstractValue<A>, S extends Store<S>> {
    protected final @Nullable Map<TypeMirror, S> exceptionalStores;
    protected @Nullable A resultValue;

    public TransferResult(@Nullable A resultValue, @Nullable Map<TypeMirror, S> exceptionalStores) {
        this.resultValue = resultValue;
        this.exceptionalStores = exceptionalStores;
    }

    public A getResultValue() {
        return this.resultValue;
    }

    public void setResultValue(A resultValue) {
        this.resultValue = resultValue;
    }

    public abstract S getRegularStore();

    public abstract S getThenStore();

    public abstract S getElseStore();

    public @Nullable S getExceptionalStore(TypeMirror exception) {
        if (this.exceptionalStores == null) {
            return null;
        }
        return (S)((Store)this.exceptionalStores.get(exception));
    }

    public Map<TypeMirror, S> getExceptionalStores() {
        return this.exceptionalStores;
    }

    public abstract boolean containsTwoStores();

    public abstract boolean storeChanged();
}

