/*
 * Decompiled with CFR 0.152.
 */
package shadow.checkerframework.dataflow.cfg.block;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import shadow.checkerframework.dataflow.cfg.block.Block;
import shadow.checkerframework.dataflow.cfg.block.BlockImpl;
import shadow.checkerframework.dataflow.cfg.block.RegularBlock;
import shadow.checkerframework.dataflow.cfg.block.SingleSuccessorBlockImpl;
import shadow.checkerframework.dataflow.cfg.node.Node;

public class RegularBlockImpl
extends SingleSuccessorBlockImpl
implements RegularBlock {
    protected final List<Node> contents = new ArrayList<Node>();

    public RegularBlockImpl() {
        super(Block.BlockType.REGULAR_BLOCK);
    }

    public void addNode(Node t) {
        this.contents.add(t);
        t.setBlock(this);
    }

    public void addNodes(List<? extends Node> ts) {
        for (Node node : ts) {
            this.addNode(node);
        }
    }

    @Override
    public List<Node> getContents() {
        return Collections.unmodifiableList(this.contents);
    }

    @Override
    public BlockImpl getRegularSuccessor() {
        return this.successor;
    }

    public String toString() {
        return "RegularBlock(" + this.contents + ")";
    }

    @Override
    public boolean isEmpty() {
        return this.contents.isEmpty();
    }
}

