/*
 * Decompiled with CFR 0.152.
 */
package shadow.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.lang.model.type.TypeMirror;
import shadow.checkerframework.dataflow.cfg.node.Node;
import shadow.checkerframework.dataflow.cfg.node.NodeVisitor;

public class AssertionErrorNode
extends Node {
    protected final Tree tree;
    protected final Node condition;
    protected final Node detail;

    public AssertionErrorNode(Tree tree, Node condition, Node detail, TypeMirror type) {
        super(type);
        assert (tree.getKind() == Tree.Kind.ASSERT);
        this.tree = tree;
        this.condition = condition;
        this.detail = detail;
    }

    public Node getCondition() {
        return this.condition;
    }

    public Node getDetail() {
        return this.detail;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitAssertionError(this, p);
    }

    public String toString() {
        return "AssertionError(" + this.getDetail() + ")";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AssertionErrorNode)) {
            return false;
        }
        AssertionErrorNode other = (AssertionErrorNode)obj;
        return Objects.equals(this.getCondition(), other.getCondition()) && Objects.equals(this.getDetail(), other.getDetail());
    }

    public int hashCode() {
        return Objects.hash(this.getCondition(), this.getDetail());
    }

    @Override
    public Collection<Node> getOperands() {
        ArrayList<Node> list = new ArrayList<Node>(2);
        list.add(this.getCondition());
        list.add(this.getDetail());
        return list;
    }
}

