/*
 * Decompiled with CFR 0.152.
 */
package shadow.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.NewClassTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import shadow.checkerframework.checker.nullness.qual.Nullable;
import shadow.checkerframework.dataflow.cfg.node.ClassDeclarationNode;
import shadow.checkerframework.dataflow.cfg.node.Node;
import shadow.checkerframework.dataflow.cfg.node.NodeVisitor;
import shadow.checkerframework.javacutil.TreeUtils;

public class ObjectCreationNode
extends Node {
    protected final NewClassTree tree;
    protected final Node constructor;
    protected final List<Node> arguments;
    protected final @Nullable ClassDeclarationNode classbody;

    public ObjectCreationNode(NewClassTree tree, Node constructor, List<Node> arguments, @Nullable ClassDeclarationNode classbody) {
        super(TreeUtils.typeOf(tree));
        this.tree = tree;
        this.constructor = constructor;
        this.arguments = arguments;
        this.classbody = classbody;
    }

    public Node getConstructor() {
        return this.constructor;
    }

    public List<Node> getArguments() {
        return this.arguments;
    }

    public Node getArgument(int i) {
        return this.arguments.get(i);
    }

    public @Nullable Node getClassBody() {
        return this.classbody;
    }

    @Override
    public NewClassTree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitObjectCreation(this, p);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("new " + this.constructor + "(");
        boolean needComma = false;
        for (Node arg : this.arguments) {
            if (needComma) {
                sb.append(", ");
            }
            sb.append(arg);
            needComma = true;
        }
        sb.append(")");
        if (this.classbody != null) {
            sb.append(" ");
            sb.append(this.classbody.toString());
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectCreationNode)) {
            return false;
        }
        ObjectCreationNode other = (ObjectCreationNode)obj;
        if (this.constructor == null && other.getConstructor() != null) {
            return false;
        }
        return this.getConstructor().equals(other.getConstructor()) && this.getArguments().equals(other.getArguments());
    }

    public int hashCode() {
        return Objects.hash(this.constructor, this.arguments);
    }

    @Override
    public Collection<Node> getOperands() {
        ArrayList<Node> list = new ArrayList<Node>(1 + this.arguments.size());
        list.add(this.constructor);
        list.addAll(this.arguments);
        return list;
    }
}

