/*
 * Decompiled with CFR 0.152.
 */
package shadow.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.Tree;
import java.util.Objects;
import shadow.checkerframework.dataflow.cfg.node.BinaryOperationNode;
import shadow.checkerframework.dataflow.cfg.node.Node;
import shadow.checkerframework.dataflow.cfg.node.NodeVisitor;

public class SignedRightShiftNode
extends BinaryOperationNode {
    public SignedRightShiftNode(BinaryTree tree, Node left, Node right) {
        super(tree, left, right);
        assert (tree.getKind() == Tree.Kind.RIGHT_SHIFT);
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitSignedRightShift(this, p);
    }

    public String toString() {
        return "(" + this.getLeftOperand() + " >> " + this.getRightOperand() + ")";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SignedRightShiftNode)) {
            return false;
        }
        SignedRightShiftNode other = (SignedRightShiftNode)obj;
        return this.getLeftOperand().equals(other.getLeftOperand()) && this.getRightOperand().equals(other.getRightOperand());
    }

    public int hashCode() {
        return Objects.hash(this.getLeftOperand(), this.getRightOperand());
    }
}

