/*
 * Decompiled with CFR 0.152.
 */
package shadow.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import shadow.checkerframework.dataflow.cfg.node.Node;
import shadow.checkerframework.dataflow.cfg.node.NodeVisitor;
import shadow.checkerframework.javacutil.TreeUtils;

public class StringConcatenateAssignmentNode
extends Node {
    protected final Tree tree;
    protected final Node left;
    protected final Node right;

    public StringConcatenateAssignmentNode(Tree tree, Node left, Node right) {
        super(TreeUtils.typeOf(tree));
        assert (tree.getKind() == Tree.Kind.PLUS_ASSIGNMENT);
        this.tree = tree;
        this.left = left;
        this.right = right;
    }

    public Node getLeftOperand() {
        return this.left;
    }

    public Node getRightOperand() {
        return this.right;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitStringConcatenateAssignment(this, p);
    }

    @Override
    public Collection<Node> getOperands() {
        ArrayList<Node> list = new ArrayList<Node>(2);
        list.add(this.getLeftOperand());
        list.add(this.getRightOperand());
        return list;
    }

    public String toString() {
        return "(" + this.getLeftOperand() + " += " + this.getRightOperand() + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof StringConcatenateAssignmentNode)) {
            return false;
        }
        StringConcatenateAssignmentNode other = (StringConcatenateAssignmentNode)obj;
        return this.getLeftOperand().equals(other.getLeftOperand()) && this.getRightOperand().equals(other.getRightOperand());
    }

    public int hashCode() {
        return Objects.hash(this.getLeftOperand(), this.getRightOperand());
    }
}

