/*
 * Decompiled with CFR 0.152.
 */
package shadow.checkerframework.dataflow.util;

import java.util.HashSet;
import java.util.Objects;
import shadow.checkerframework.dataflow.util.AbstractMostlySingleton;
import shadow.checkerframework.javacutil.BugInCF;

public final class MostlySingleton<T>
extends AbstractMostlySingleton<T> {
    public MostlySingleton() {
        this.state = AbstractMostlySingleton.State.EMPTY;
    }

    public MostlySingleton(T value) {
        this.state = AbstractMostlySingleton.State.SINGLETON;
        this.value = value;
    }

    @Override
    public boolean add(T e) {
        switch (this.state) {
            case EMPTY: {
                this.state = AbstractMostlySingleton.State.SINGLETON;
                this.value = e;
                return true;
            }
            case SINGLETON: {
                this.state = AbstractMostlySingleton.State.ANY;
                this.set = new HashSet();
                this.set.add(this.value);
                this.value = null;
            }
            case ANY: {
                return this.set.add(e);
            }
        }
        throw new BugInCF("Unhandled state " + (Object)((Object)this.state));
    }

    @Override
    public boolean contains(Object o) {
        switch (this.state) {
            case EMPTY: {
                return false;
            }
            case SINGLETON: {
                return Objects.equals(o, this.value);
            }
            case ANY: {
                return this.set.contains(o);
            }
        }
        throw new BugInCF("Unhandled state " + (Object)((Object)this.state));
    }
}

