/*
 * Decompiled with CFR 0.152.
 */
package shadow.checkerframework.dataflow.util;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import shadow.checkerframework.dataflow.cfg.node.ConditionalOrNode;
import shadow.checkerframework.dataflow.cfg.node.FieldAccessNode;
import shadow.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import shadow.checkerframework.dataflow.cfg.node.Node;
import shadow.checkerframework.javacutil.ElementUtils;
import shadow.checkerframework.javacutil.TypesUtils;

public class NodeUtils {
    public static boolean isBooleanTypeNode(Node node) {
        if (node instanceof ConditionalOrNode) {
            return true;
        }
        Tree tree = node.getTree();
        if (tree == null) {
            return false;
        }
        Type type = ((JCTree)tree).type;
        return TypesUtils.isBooleanType(type);
    }

    public static boolean isArrayLengthFieldAccess(Node node) {
        if (!(node instanceof FieldAccessNode)) {
            return false;
        }
        FieldAccessNode fieldAccess = (FieldAccessNode)node;
        return fieldAccess.getFieldName().equals("length") && fieldAccess.getReceiver().getType().getKind() == TypeKind.ARRAY;
    }

    public static boolean isMethodInvocation(Node node, ExecutableElement method, ProcessingEnvironment env) {
        if (!(node instanceof MethodInvocationNode)) {
            return false;
        }
        ExecutableElement invoked = ((MethodInvocationNode)node).getTarget().getMethod();
        return ElementUtils.isMethod(invoked, method, env);
    }
}

