/*
 * Decompiled with CFR 0.152.
 */
package shadow.checkerframework.dataflow.util;

import com.sun.source.tree.MethodTree;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import shadow.checkerframework.dataflow.qual.Deterministic;
import shadow.checkerframework.dataflow.qual.Pure;
import shadow.checkerframework.dataflow.qual.SideEffectFree;
import shadow.checkerframework.javacutil.AnnotationProvider;
import shadow.checkerframework.javacutil.TreeUtils;

public class PurityUtils {
    public static boolean hasPurityAnnotation(AnnotationProvider provider, MethodTree tree) {
        return !PurityUtils.getPurityKinds(provider, tree).isEmpty();
    }

    public static boolean hasPurityAnnotation(AnnotationProvider provider, Element methodElement) {
        return !PurityUtils.getPurityKinds(provider, methodElement).isEmpty();
    }

    public static boolean isDeterministic(AnnotationProvider provider, MethodTree tree) {
        Element methodElement = TreeUtils.elementFromTree(tree);
        return PurityUtils.isDeterministic(provider, methodElement);
    }

    public static boolean isDeterministic(AnnotationProvider provider, Element methodElement) {
        List<Pure.Kind> kinds = PurityUtils.getPurityKinds(provider, methodElement);
        return kinds.contains((Object)Pure.Kind.DETERMINISTIC);
    }

    public static boolean isSideEffectFree(AnnotationProvider provider, MethodTree tree) {
        Element methodElement = TreeUtils.elementFromTree(tree);
        return PurityUtils.isSideEffectFree(provider, methodElement);
    }

    public static boolean isSideEffectFree(AnnotationProvider provider, Element methodElement) {
        List<Pure.Kind> kinds = PurityUtils.getPurityKinds(provider, methodElement);
        return kinds.contains((Object)Pure.Kind.SIDE_EFFECT_FREE);
    }

    public static List<Pure.Kind> getPurityKinds(AnnotationProvider provider, MethodTree tree) {
        Element methodElement = TreeUtils.elementFromTree(tree);
        return PurityUtils.getPurityKinds(provider, methodElement);
    }

    public static List<Pure.Kind> getPurityKinds(AnnotationProvider provider, Element methodElement) {
        AnnotationMirror pureAnnotation = provider.getDeclAnnotation(methodElement, Pure.class);
        AnnotationMirror sefAnnotation = provider.getDeclAnnotation(methodElement, SideEffectFree.class);
        AnnotationMirror detAnnotation = provider.getDeclAnnotation(methodElement, Deterministic.class);
        ArrayList<Pure.Kind> kinds = new ArrayList<Pure.Kind>();
        if (pureAnnotation != null) {
            kinds.add(Pure.Kind.DETERMINISTIC);
            kinds.add(Pure.Kind.SIDE_EFFECT_FREE);
        }
        if (sefAnnotation != null) {
            kinds.add(Pure.Kind.SIDE_EFFECT_FREE);
        }
        if (detAnnotation != null) {
            kinds.add(Pure.Kind.DETERMINISTIC);
        }
        return kinds;
    }
}

