/*
 * Decompiled with CFR 0.152.
 */
package shadow.checkerframework.javacutil;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import shadow.checkerframework.checker.interning.qual.Interned;
import shadow.checkerframework.checker.nullness.qual.Nullable;
import shadow.checkerframework.dataflow.qual.SideEffectFree;
import shadow.checkerframework.javacutil.BugInCF;
import shadow.checkerframework.javacutil.TypesUtils;
import shadow.checkerframework.javacutil.UserError;

public class AnnotationBuilder {
    private final Elements elements;
    private final Types types;
    private final TypeElement annotationElt;
    private final DeclaredType annotationType;
    private final Map<ExecutableElement, AnnotationValue> elementValues;
    private static final Map<CharSequence, AnnotationMirror> annotationsFromNames = Collections.synchronizedMap(new HashMap());
    private boolean wasBuilt = false;

    public AnnotationBuilder(ProcessingEnvironment env, Class<? extends Annotation> anno) {
        this(env, anno.getCanonicalName());
    }

    public AnnotationBuilder(ProcessingEnvironment env, CharSequence name) {
        this.elements = env.getElementUtils();
        this.types = env.getTypeUtils();
        this.annotationElt = this.elements.getTypeElement(name);
        if (this.annotationElt == null) {
            throw new UserError("Could not find annotation: " + name + ". Is it on the classpath?");
        }
        assert (this.annotationElt.getKind() == ElementKind.ANNOTATION_TYPE);
        this.annotationType = (DeclaredType)this.annotationElt.asType();
        this.elementValues = new LinkedHashMap<ExecutableElement, AnnotationValue>();
    }

    public AnnotationBuilder(ProcessingEnvironment env, AnnotationMirror annotation) {
        this.elements = env.getElementUtils();
        this.types = env.getTypeUtils();
        this.annotationType = annotation.getAnnotationType();
        this.annotationElt = (TypeElement)this.annotationType.asElement();
        this.elementValues = new LinkedHashMap<ExecutableElement, AnnotationValue>();
        this.elementValues.putAll(annotation.getElementValues());
    }

    public static AnnotationMirror fromClass(Elements elements, Class<? extends Annotation> aClass) {
        AnnotationMirror res = AnnotationBuilder.fromName(elements, aClass.getCanonicalName());
        if (res == null) {
            throw new UserError("AnnotationBuilder: error: fromClass can't load Class %s%nensure the class is on the compilation classpath", aClass.getCanonicalName());
        }
        return res;
    }

    public static @Nullable AnnotationMirror fromName(Elements elements, CharSequence name) {
        AnnotationMirror res = annotationsFromNames.get(name);
        if (res != null) {
            return res;
        }
        TypeElement annoElt = elements.getTypeElement(name);
        if (annoElt == null) {
            return null;
        }
        if (annoElt.getKind() != ElementKind.ANNOTATION_TYPE) {
            throw new BugInCF(annoElt + " is not an annotation");
        }
        DeclaredType annoType = (DeclaredType)annoElt.asType();
        if (annoType == null) {
            return null;
        }
        CheckerFrameworkAnnotationMirror result = new CheckerFrameworkAnnotationMirror(annoType, Collections.emptyMap());
        annotationsFromNames.put(name, result);
        return result;
    }

    public static void clear() {
        annotationsFromNames.clear();
    }

    private void assertNotBuilt() {
        if (this.wasBuilt) {
            throw new BugInCF("AnnotationBuilder: error: type was already built");
        }
    }

    public AnnotationMirror build() {
        this.assertNotBuilt();
        this.wasBuilt = true;
        return new CheckerFrameworkAnnotationMirror(this.annotationType, this.elementValues);
    }

    public void copyElementValuesFromAnnotation(AnnotationMirror valueHolder, String ... ignorableElements) {
        HashSet<String> ignorableElementsSet = new HashSet<String>(Arrays.asList(ignorableElements));
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> eltValToCopy : valueHolder.getElementValues().entrySet()) {
            Name eltNameToCopy = eltValToCopy.getKey().getSimpleName();
            if (ignorableElementsSet.contains(eltNameToCopy.toString())) continue;
            this.elementValues.put(this.findElement(eltNameToCopy), eltValToCopy.getValue());
        }
    }

    public void copyRenameElementValuesFromAnnotation(AnnotationMirror valueHolder, Map<String, String> elementNameRenaming) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> eltValToCopy : valueHolder.getElementValues().entrySet()) {
            String sourceName = eltValToCopy.getKey().getSimpleName().toString();
            String targetName = elementNameRenaming.get(sourceName);
            if (targetName == null) continue;
            this.elementValues.put(this.findElement(targetName), eltValToCopy.getValue());
        }
    }

    public AnnotationBuilder setValue(CharSequence elementName, AnnotationMirror value) {
        this.setValue(elementName, (Object)value);
        return this;
    }

    public AnnotationBuilder setValue(CharSequence elementName, List<? extends Object> values) {
        this.assertNotBuilt();
        ArrayList<AnnotationValue> avalues = new ArrayList<AnnotationValue>(values.size());
        ExecutableElement var = this.findElement(elementName);
        TypeMirror expectedType = var.getReturnType();
        if (expectedType.getKind() != TypeKind.ARRAY) {
            throw new BugInCF("value is an array while expected type is not");
        }
        expectedType = ((ArrayType)expectedType).getComponentType();
        for (Object object : values) {
            this.checkSubtype(expectedType, object);
            avalues.add(this.createValue(object));
        }
        AnnotationValue aval = this.createValue(avalues);
        this.elementValues.put(var, aval);
        return this;
    }

    public AnnotationBuilder setValue(CharSequence elementName, Object[] values) {
        return this.setValue(elementName, Arrays.asList(values));
    }

    public AnnotationBuilder setValue(CharSequence elementName, Boolean value) {
        return this.setValue(elementName, (Object)value);
    }

    public AnnotationBuilder setValue(CharSequence elementName, Character value) {
        return this.setValue(elementName, (Object)value);
    }

    public AnnotationBuilder setValue(CharSequence elementName, Double value) {
        return this.setValue(elementName, (Object)value);
    }

    public AnnotationBuilder setValue(CharSequence elementName, Float value) {
        return this.setValue(elementName, (Object)value);
    }

    public AnnotationBuilder setValue(CharSequence elementName, Integer value) {
        return this.setValue(elementName, (Object)value);
    }

    public AnnotationBuilder setValue(CharSequence elementName, Long value) {
        return this.setValue(elementName, (Object)value);
    }

    public AnnotationBuilder setValue(CharSequence elementName, Short value) {
        return this.setValue(elementName, (Object)value);
    }

    public AnnotationBuilder setValue(CharSequence elementName, String value) {
        return this.setValue(elementName, (Object)value);
    }

    public AnnotationBuilder removeElement(CharSequence elementName) {
        this.assertNotBuilt();
        ExecutableElement var = this.findElement(elementName);
        this.elementValues.remove(var);
        return this;
    }

    private TypeMirror getErasedOrBoxedType(TypeMirror type) {
        return type.getKind().isPrimitive() ? this.types.boxedClass((PrimitiveType)type).asType() : this.types.erasure(type);
    }

    public AnnotationBuilder setValue(CharSequence elementName, TypeMirror value) {
        this.assertNotBuilt();
        value = this.getErasedOrBoxedType(value);
        AnnotationValue val = this.createValue(value);
        ExecutableElement var = this.findElement(elementName);
        if (!TypesUtils.isClass(var.getReturnType())) {
            throw new BugInCF("expected " + var.getReturnType());
        }
        this.elementValues.put(var, val);
        return this;
    }

    private TypeMirror typeFromClass(Class<?> clazz) {
        if (clazz == Void.TYPE) {
            return this.types.getNoType(TypeKind.VOID);
        }
        if (clazz.isPrimitive()) {
            String primitiveName = clazz.getName().toUpperCase();
            TypeKind primitiveKind = TypeKind.valueOf(primitiveName);
            return this.types.getPrimitiveType(primitiveKind);
        }
        if (clazz.isArray()) {
            TypeMirror componentType = this.typeFromClass(clazz.getComponentType());
            return this.types.getArrayType(componentType);
        }
        TypeElement element = this.elements.getTypeElement(clazz.getCanonicalName());
        if (element == null) {
            throw new BugInCF("Unrecognized class: " + clazz);
        }
        return element.asType();
    }

    public AnnotationBuilder setValue(CharSequence elementName, Class<?> value) {
        TypeMirror type = this.typeFromClass(value);
        return this.setValue(elementName, this.getErasedOrBoxedType(type));
    }

    public AnnotationBuilder setValue(CharSequence elementName, Enum<?> value) {
        this.assertNotBuilt();
        VariableElement enumElt = this.findEnumElement(value);
        return this.setValue(elementName, enumElt);
    }

    public AnnotationBuilder setValue(CharSequence elementName, VariableElement value) {
        ExecutableElement var = this.findElement(elementName);
        if (var.getReturnType().getKind() != TypeKind.DECLARED) {
            throw new BugInCF("expected a non enum: " + var.getReturnType());
        }
        if (!((DeclaredType)var.getReturnType()).asElement().equals(value.getEnclosingElement())) {
            throw new BugInCF("expected a different type of enum: " + value.getEnclosingElement());
        }
        this.elementValues.put(var, this.createValue(value));
        return this;
    }

    public AnnotationBuilder setValue(CharSequence elementName, Enum<?>[] values) {
        this.assertNotBuilt();
        if (values.length == 0) {
            this.setValue(elementName, Collections.emptyList());
            return this;
        }
        VariableElement enumElt = this.findEnumElement(values[0]);
        ExecutableElement var = this.findElement(elementName);
        TypeMirror expectedType = var.getReturnType();
        if (expectedType.getKind() != TypeKind.ARRAY) {
            throw new BugInCF("expected a non array: " + var.getReturnType());
        }
        if ((expectedType = ((ArrayType)expectedType).getComponentType()).getKind() != TypeKind.DECLARED) {
            throw new BugInCF("expected a non enum component type: " + var.getReturnType());
        }
        if (!((DeclaredType)expectedType).asElement().equals(enumElt.getEnclosingElement())) {
            throw new BugInCF("expected a different type of enum: " + enumElt.getEnclosingElement());
        }
        ArrayList<AnnotationValue> res = new ArrayList<AnnotationValue>(values.length);
        for (Enum<?> ev : values) {
            this.checkSubtype(expectedType, ev);
            enumElt = this.findEnumElement(ev);
            res.add(this.createValue(enumElt));
        }
        AnnotationValue val = this.createValue(res);
        this.elementValues.put(var, val);
        return this;
    }

    public AnnotationBuilder setValue(CharSequence elementName, VariableElement[] values) {
        this.assertNotBuilt();
        ExecutableElement var = this.findElement(elementName);
        TypeMirror expectedType = var.getReturnType();
        if (expectedType.getKind() != TypeKind.ARRAY) {
            throw new BugInCF("expected an array, but found: " + expectedType);
        }
        if ((expectedType = ((ArrayType)expectedType).getComponentType()).getKind() != TypeKind.DECLARED) {
            throw new BugInCF("expected a declared component type, but found: " + expectedType + " kind: " + (Object)((Object)expectedType.getKind()));
        }
        if (!this.types.isSameType((DeclaredType)expectedType, values[0].asType())) {
            throw new BugInCF("expected a different declared component type: " + expectedType + " vs. " + values[0]);
        }
        ArrayList<AnnotationValue> res = new ArrayList<AnnotationValue>(values.length);
        for (VariableElement ev : values) {
            this.checkSubtype(expectedType, ev);
            if (ev.getConstantValue() != null) {
                res.add(this.createValue(ev.getConstantValue()));
                continue;
            }
            res.add(this.createValue(ev));
        }
        AnnotationValue val = this.createValue(res);
        this.elementValues.put(var, val);
        return this;
    }

    private VariableElement findEnumElement(Enum<?> value) {
        String enumClass = value.getDeclaringClass().getCanonicalName();
        TypeElement enumClassElt = this.elements.getTypeElement(enumClass);
        assert (enumClassElt != null);
        for (Element element : enumClassElt.getEnclosedElements()) {
            if (!element.getSimpleName().contentEquals(value.name())) continue;
            return (VariableElement)element;
        }
        throw new BugInCF("cannot be here");
    }

    private AnnotationBuilder setValue(CharSequence key, Object value) {
        this.assertNotBuilt();
        AnnotationValue val = this.createValue(value);
        ExecutableElement var = this.findElement(key);
        this.checkSubtype(var.getReturnType(), value);
        this.elementValues.put(var, val);
        return this;
    }

    public ExecutableElement findElement(CharSequence key) {
        for (ExecutableElement elt : ElementFilter.methodsIn(this.annotationElt.getEnclosedElements())) {
            if (!elt.getSimpleName().contentEquals(key)) continue;
            return elt;
        }
        throw new BugInCF("Couldn't find " + key + " element in " + this.annotationElt);
    }

    private void checkSubtype(TypeMirror expected, Object givenValue) {
        boolean isSubtype;
        TypeMirror found;
        if (expected.getKind().isPrimitive()) {
            expected = this.types.boxedClass((PrimitiveType)expected).asType();
        }
        if (expected.getKind() == TypeKind.DECLARED && TypesUtils.isClass(expected) && givenValue instanceof TypeMirror) {
            return;
        }
        if (expected.getKind() == TypeKind.DECLARED && ((DeclaredType)expected).asElement().getKind() == ElementKind.ANNOTATION_TYPE && givenValue instanceof AnnotationMirror) {
            found = ((AnnotationMirror)givenValue).getAnnotationType();
            isSubtype = ((DeclaredType)expected).asElement().equals(((DeclaredType)found).asElement());
        } else if (givenValue instanceof AnnotationMirror) {
            found = ((AnnotationMirror)givenValue).getAnnotationType();
            isSubtype = false;
        } else if (givenValue instanceof VariableElement) {
            found = ((VariableElement)givenValue).asType();
            isSubtype = expected.getKind() == TypeKind.DECLARED ? this.types.isSubtype(this.types.erasure(found), this.types.erasure(expected)) : false;
        } else {
            found = this.elements.getTypeElement(givenValue.getClass().getCanonicalName()).asType();
            isSubtype = this.types.isSubtype(this.types.erasure(found), this.types.erasure(expected));
        }
        if (!isSubtype) {
            isSubtype = found.toString().equals(expected.toString());
        }
        if (!isSubtype) {
            throw new BugInCF("given value differs from expected; found: " + found + "; expected: " + expected);
        }
    }

    private AnnotationValue createValue(Object obj) {
        return new CheckerFrameworkAnnotationValue(obj);
    }

    private static class CheckerFrameworkAnnotationValue
    implements AnnotationValue {
        private final Object value;
        private @Interned String toStringVal;

        CheckerFrameworkAnnotationValue(Object obj) {
            this.value = obj;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        @SideEffectFree
        public String toString() {
            if (this.toStringVal != null) {
                return this.toStringVal;
            }
            if (this.value instanceof String) {
                this.toStringVal = "\"" + this.value + "\"";
            } else if (this.value instanceof Character) {
                this.toStringVal = "'" + this.value + "'";
            } else if (this.value instanceof List) {
                StringBuilder sb = new StringBuilder();
                List list = (List)this.value;
                sb.append('{');
                boolean isFirst = true;
                for (Object o : list) {
                    if (!isFirst) {
                        sb.append(", ");
                    }
                    isFirst = false;
                    sb.append(o.toString());
                }
                sb.append('}');
                this.toStringVal = sb.toString();
            } else if (this.value instanceof VariableElement) {
                VariableElement var = (VariableElement)this.value;
                String encl = var.getEnclosingElement().toString();
                if (!encl.isEmpty()) {
                    encl = encl + '.';
                }
                this.toStringVal = encl + var;
            } else {
                this.toStringVal = this.value instanceof TypeMirror && TypesUtils.isClassType((TypeMirror)this.value) ? this.value.toString() + ".class" : this.value.toString();
            }
            this.toStringVal = this.toStringVal.intern();
            return this.toStringVal;
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
            if (this.value instanceof AnnotationMirror) {
                return v.visitAnnotation((AnnotationMirror)this.value, p);
            }
            if (this.value instanceof List) {
                return v.visitArray((List)this.value, p);
            }
            if (this.value instanceof Boolean) {
                return v.visitBoolean((Boolean)this.value, p);
            }
            if (this.value instanceof Character) {
                return v.visitChar(((Character)this.value).charValue(), p);
            }
            if (this.value instanceof Double) {
                return v.visitDouble((Double)this.value, p);
            }
            if (this.value instanceof VariableElement) {
                return v.visitEnumConstant((VariableElement)this.value, p);
            }
            if (this.value instanceof Float) {
                return v.visitFloat(((Float)this.value).floatValue(), p);
            }
            if (this.value instanceof Integer) {
                return v.visitInt((Integer)this.value, p);
            }
            if (this.value instanceof Long) {
                return v.visitLong((Long)this.value, p);
            }
            if (this.value instanceof Short) {
                return v.visitShort((Short)this.value, p);
            }
            if (this.value instanceof String) {
                return v.visitString((String)this.value, p);
            }
            if (this.value instanceof TypeMirror) {
                return v.visitType((TypeMirror)this.value, p);
            }
            assert (false) : " unknown type : " + v.getClass();
            return v.visitUnknown(this, p);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AnnotationValue)) {
                return false;
            }
            AnnotationValue other = (AnnotationValue)obj;
            return Objects.equals(this.getValue(), other.getValue());
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }
    }

    static class CheckerFrameworkAnnotationMirror
    implements AnnotationMirror {
        private @Interned String toStringVal;
        private final DeclaredType annotationType;
        private final Map<ExecutableElement, AnnotationValue> elementValues;
        final @Interned String annotationName;

        CheckerFrameworkAnnotationMirror(DeclaredType at, Map<ExecutableElement, AnnotationValue> ev) {
            this.annotationType = at;
            TypeElement elm = (TypeElement)at.asElement();
            this.annotationName = elm.getQualifiedName().toString().intern();
            this.elementValues = ev;
        }

        @Override
        public DeclaredType getAnnotationType() {
            return this.annotationType;
        }

        @Override
        public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValues() {
            return Collections.unmodifiableMap(this.elementValues);
        }

        @SideEffectFree
        public String toString() {
            if (this.toStringVal != null) {
                return this.toStringVal;
            }
            StringBuilder buf = new StringBuilder();
            buf.append("@");
            buf.append(this.annotationName);
            int len = this.elementValues.size();
            if (len > 0) {
                buf.append('(');
                boolean first = true;
                for (Map.Entry<ExecutableElement, AnnotationValue> pair : this.elementValues.entrySet()) {
                    if (!first) {
                        buf.append(", ");
                    }
                    first = false;
                    String name = pair.getKey().getSimpleName().toString();
                    if (len > 1 || !name.equals("value")) {
                        buf.append(name);
                        buf.append('=');
                    }
                    buf.append(pair.getValue());
                }
                buf.append(')');
            }
            this.toStringVal = buf.toString().intern();
            return this.toStringVal;
        }
    }
}

