/*
 * Decompiled with CFR 0.152.
 */
package shadow.checkerframework.javacutil;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Pair;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class TypeAnnotationUtils {
    private TypeAnnotationUtils() {
        throw new AssertionError((Object)"Class TypeAnnotationUtils cannot be instantiated.");
    }

    public static boolean isTypeCompoundContained(List<Attribute.TypeCompound> list, Attribute.TypeCompound tc, Types types) {
        for (Attribute.TypeCompound rawat : list) {
            if (!TypeAnnotationUtils.contentEquals(rawat.type.tsym.name, tc.type.tsym.name) || !rawat.values.equals(tc.values) || !TypeAnnotationUtils.isSameTAPositionExceptTreePos(rawat.position, tc.position)) continue;
            return true;
        }
        return false;
    }

    private static boolean contentEquals(Name n1, Name n2) {
        ByteBuffer b1 = ByteBuffer.wrap(n1.getByteArray(), n1.getByteOffset(), n1.getByteLength());
        ByteBuffer b2 = ByteBuffer.wrap(n2.getByteArray(), n2.getByteOffset(), n2.getByteLength());
        return b1.equals(b2);
    }

    public static boolean isSameTAPosition(TypeAnnotationPosition p1, TypeAnnotationPosition p2) {
        return TypeAnnotationUtils.isSameTAPositionExceptTreePos(p1, p2) && p1.pos == p2.pos;
    }

    public static boolean isSameTAPositionExceptTreePos(TypeAnnotationPosition p1, TypeAnnotationPosition p2) {
        return p1.type == p2.type && p1.type_index == p2.type_index && p1.bound_index == p2.bound_index && p1.onLambda == p2.onLambda && p1.parameter_index == p2.parameter_index && p1.isValidOffset == p2.isValidOffset && p1.offset == p2.offset && p1.location.equals(p2.location) && Arrays.equals(p1.lvarIndex, p2.lvarIndex) && Arrays.equals(p1.lvarLength, p2.lvarLength) && Arrays.equals(p1.lvarOffset, p2.lvarOffset) && (!p1.hasExceptionIndex() || !p2.hasExceptionIndex() || p1.getExceptionIndex() == p2.getExceptionIndex());
    }

    public static Attribute.Compound createCompoundFromAnnotationMirror(AnnotationMirror am, ProcessingEnvironment env) {
        List<Pair<Symbol.MethodSymbol, Attribute>> values = List.nil();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : am.getElementValues().entrySet()) {
            Attribute attribute = TypeAnnotationUtils.attributeFromAnnotationValue(entry.getKey(), entry.getValue(), env);
            values = values.append(new Pair<Symbol.MethodSymbol, Attribute>((Symbol.MethodSymbol)entry.getKey(), attribute));
        }
        return new Attribute.Compound((Type.ClassType)am.getAnnotationType(), values);
    }

    public static Attribute.TypeCompound createTypeCompoundFromAnnotationMirror(AnnotationMirror am, TypeAnnotationPosition tapos, ProcessingEnvironment env) {
        List<Pair<Symbol.MethodSymbol, Attribute>> values = List.nil();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : am.getElementValues().entrySet()) {
            Attribute attribute = TypeAnnotationUtils.attributeFromAnnotationValue(entry.getKey(), entry.getValue(), env);
            values = values.append(new Pair<Symbol.MethodSymbol, Attribute>((Symbol.MethodSymbol)entry.getKey(), attribute));
        }
        return new Attribute.TypeCompound((Type.ClassType)am.getAnnotationType(), values, tapos);
    }

    public static Attribute attributeFromAnnotationValue(ExecutableElement meth, AnnotationValue av, ProcessingEnvironment env) {
        return av.accept(new AttributeCreator(env, meth), null);
    }

    public static TypeAnnotationPosition unknownTAPosition() {
        return TypeAnnotationPosition.unknown;
    }

    public static TypeAnnotationPosition methodReturnTAPosition(int pos) {
        return TypeAnnotationPosition.methodReturn(pos);
    }

    public static TypeAnnotationPosition methodReceiverTAPosition(int pos) {
        return TypeAnnotationPosition.methodReceiver(pos);
    }

    public static TypeAnnotationPosition methodParameterTAPosition(int pidx, int pos) {
        return TypeAnnotationPosition.methodParameter(pidx, pos);
    }

    public static TypeAnnotationPosition methodThrowsTAPosition(int tidx, int pos) {
        return TypeAnnotationPosition.methodThrows(TypeAnnotationPosition.emptyPath, null, tidx, pos);
    }

    public static TypeAnnotationPosition fieldTAPosition(int pos) {
        return TypeAnnotationPosition.field(pos);
    }

    public static TypeAnnotationPosition classExtendsTAPosition(int implidx, int pos) {
        return TypeAnnotationPosition.classExtends(implidx, pos);
    }

    public static TypeAnnotationPosition typeParameterTAPosition(int tpidx, int pos) {
        return TypeAnnotationPosition.typeParameter(TypeAnnotationPosition.emptyPath, null, tpidx, pos);
    }

    public static TypeAnnotationPosition methodTypeParameterTAPosition(int tpidx, int pos) {
        return TypeAnnotationPosition.methodTypeParameter(TypeAnnotationPosition.emptyPath, null, tpidx, pos);
    }

    public static TypeAnnotationPosition typeParameterBoundTAPosition(int tpidx, int bndidx, int pos) {
        return TypeAnnotationPosition.typeParameterBound(TypeAnnotationPosition.emptyPath, null, tpidx, bndidx, pos);
    }

    public static TypeAnnotationPosition methodTypeParameterBoundTAPosition(int tpidx, int bndidx, int pos) {
        return TypeAnnotationPosition.methodTypeParameterBound(TypeAnnotationPosition.emptyPath, null, tpidx, bndidx, pos);
    }

    public static TypeAnnotationPosition copyTAPosition(TypeAnnotationPosition tapos) {
        TypeAnnotationPosition res;
        switch (tapos.type) {
            case CAST: {
                res = TypeAnnotationPosition.typeCast(tapos.location, tapos.onLambda, tapos.type_index, tapos.pos);
                break;
            }
            case CLASS_EXTENDS: {
                res = TypeAnnotationPosition.classExtends(tapos.location, tapos.onLambda, tapos.type_index, tapos.pos);
                break;
            }
            case CLASS_TYPE_PARAMETER: {
                res = TypeAnnotationPosition.typeParameter(tapos.location, tapos.onLambda, tapos.parameter_index, tapos.pos);
                break;
            }
            case CLASS_TYPE_PARAMETER_BOUND: {
                res = TypeAnnotationPosition.typeParameterBound(tapos.location, tapos.onLambda, tapos.parameter_index, tapos.bound_index, tapos.pos);
                break;
            }
            case CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: {
                res = TypeAnnotationPosition.constructorInvocationTypeArg(tapos.location, tapos.onLambda, tapos.type_index, tapos.pos);
                break;
            }
            case CONSTRUCTOR_REFERENCE: {
                res = TypeAnnotationPosition.constructorRef(tapos.location, tapos.onLambda, tapos.pos);
                break;
            }
            case CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: {
                res = TypeAnnotationPosition.constructorRefTypeArg(tapos.location, tapos.onLambda, tapos.type_index, tapos.pos);
                break;
            }
            case EXCEPTION_PARAMETER: {
                res = TypeAnnotationPosition.exceptionParameter(tapos.location, tapos.onLambda, tapos.pos);
                break;
            }
            case FIELD: {
                res = TypeAnnotationPosition.field(tapos.location, tapos.onLambda, tapos.pos);
                break;
            }
            case INSTANCEOF: {
                res = TypeAnnotationPosition.instanceOf(tapos.location, tapos.onLambda, tapos.pos);
                break;
            }
            case LOCAL_VARIABLE: {
                res = TypeAnnotationPosition.localVariable(tapos.location, tapos.onLambda, tapos.pos);
                break;
            }
            case METHOD_FORMAL_PARAMETER: {
                res = TypeAnnotationPosition.methodParameter(tapos.location, tapos.onLambda, tapos.parameter_index, tapos.pos);
                break;
            }
            case METHOD_INVOCATION_TYPE_ARGUMENT: {
                res = TypeAnnotationPosition.methodInvocationTypeArg(tapos.location, tapos.onLambda, tapos.type_index, tapos.pos);
                break;
            }
            case METHOD_RECEIVER: {
                res = TypeAnnotationPosition.methodReceiver(tapos.location, tapos.onLambda, tapos.pos);
                break;
            }
            case METHOD_REFERENCE: {
                res = TypeAnnotationPosition.methodRef(tapos.location, tapos.onLambda, tapos.pos);
                break;
            }
            case METHOD_REFERENCE_TYPE_ARGUMENT: {
                res = TypeAnnotationPosition.methodRefTypeArg(tapos.location, tapos.onLambda, tapos.type_index, tapos.pos);
                break;
            }
            case METHOD_RETURN: {
                res = TypeAnnotationPosition.methodReturn(tapos.location, tapos.onLambda, tapos.pos);
                break;
            }
            case METHOD_TYPE_PARAMETER: {
                res = TypeAnnotationPosition.methodTypeParameter(tapos.location, tapos.onLambda, tapos.parameter_index, tapos.pos);
                break;
            }
            case METHOD_TYPE_PARAMETER_BOUND: {
                res = TypeAnnotationPosition.methodTypeParameterBound(tapos.location, tapos.onLambda, tapos.parameter_index, tapos.bound_index, tapos.pos);
                break;
            }
            case NEW: {
                res = TypeAnnotationPosition.newObj(tapos.location, tapos.onLambda, tapos.pos);
                break;
            }
            case RESOURCE_VARIABLE: {
                res = TypeAnnotationPosition.resourceVariable(tapos.location, tapos.onLambda, tapos.pos);
                break;
            }
            case THROWS: {
                res = TypeAnnotationPosition.methodThrows(tapos.location, tapos.onLambda, tapos.type_index, tapos.pos);
                break;
            }
            default: {
                assert (false) : "Unexpected target type: " + tapos + " at " + (Object)((Object)tapos.type);
                res = null;
            }
        }
        return res;
    }

    public static Type unannotatedType(TypeMirror in) {
        Type impl = (Type)in;
        if (impl.isPrimitive()) {
            return impl.baseType();
        }
        return impl.stripMetadata();
    }

    private static class AttributeCreator
    implements AnnotationValueVisitor<Attribute, Void> {
        private final ProcessingEnvironment processingEnv;
        private final Types modelTypes;
        private final Elements elements;
        private final com.sun.tools.javac.code.Types javacTypes;
        private final ExecutableElement meth;

        public AttributeCreator(ProcessingEnvironment env, ExecutableElement meth) {
            this.processingEnv = env;
            Context context = ((JavacProcessingEnvironment)env).getContext();
            this.elements = env.getElementUtils();
            this.modelTypes = env.getTypeUtils();
            this.javacTypes = com.sun.tools.javac.code.Types.instance(context);
            this.meth = meth;
        }

        @Override
        public Attribute visit(AnnotationValue av, Void p) {
            return av.accept(this, p);
        }

        @Override
        public Attribute visit(AnnotationValue av) {
            return this.visit(av, null);
        }

        @Override
        public Attribute visitBoolean(boolean b, Void p) {
            PrimitiveType booleanType = this.modelTypes.getPrimitiveType(TypeKind.BOOLEAN);
            return new Attribute.Constant((Type)((Object)booleanType), b ? 1 : 0);
        }

        @Override
        public Attribute visitByte(byte b, Void p) {
            PrimitiveType byteType = this.modelTypes.getPrimitiveType(TypeKind.BYTE);
            return new Attribute.Constant((Type)((Object)byteType), b);
        }

        @Override
        public Attribute visitChar(char c, Void p) {
            PrimitiveType charType = this.modelTypes.getPrimitiveType(TypeKind.CHAR);
            return new Attribute.Constant((Type)((Object)charType), Character.valueOf(c));
        }

        @Override
        public Attribute visitDouble(double d, Void p) {
            PrimitiveType doubleType = this.modelTypes.getPrimitiveType(TypeKind.DOUBLE);
            return new Attribute.Constant((Type)((Object)doubleType), d);
        }

        @Override
        public Attribute visitFloat(float f, Void p) {
            PrimitiveType floatType = this.modelTypes.getPrimitiveType(TypeKind.FLOAT);
            return new Attribute.Constant((Type)((Object)floatType), Float.valueOf(f));
        }

        @Override
        public Attribute visitInt(int i, Void p) {
            PrimitiveType intType = this.modelTypes.getPrimitiveType(TypeKind.INT);
            return new Attribute.Constant((Type)((Object)intType), i);
        }

        @Override
        public Attribute visitLong(long i, Void p) {
            PrimitiveType longType = this.modelTypes.getPrimitiveType(TypeKind.LONG);
            return new Attribute.Constant((Type)((Object)longType), i);
        }

        @Override
        public Attribute visitShort(short s2, Void p) {
            PrimitiveType shortType = this.modelTypes.getPrimitiveType(TypeKind.SHORT);
            return new Attribute.Constant((Type)((Object)shortType), s2);
        }

        @Override
        public Attribute visitString(String s2, Void p) {
            TypeMirror stringType = this.elements.getTypeElement("java.lang.String").asType();
            return new Attribute.Constant((Type)stringType, s2);
        }

        @Override
        public Attribute visitType(TypeMirror t, Void p) {
            if (t instanceof Type) {
                return new Attribute.Class(this.javacTypes, (Type)t);
            }
            assert (false) : "Unexpected type of TypeMirror: " + t.getClass();
            return null;
        }

        @Override
        public Attribute visitEnumConstant(VariableElement c, Void p) {
            Symbol.VarSymbol sym;
            if (c instanceof Symbol.VarSymbol && (sym = (Symbol.VarSymbol)c).getKind() == ElementKind.ENUM_CONSTANT) {
                return new Attribute.Enum(sym.type, sym);
            }
            assert (false) : "Unexpected type of VariableElement: " + c.getClass();
            return null;
        }

        @Override
        public Attribute visitAnnotation(AnnotationMirror a, Void p) {
            return TypeAnnotationUtils.createCompoundFromAnnotationMirror(a, this.processingEnv);
        }

        @Override
        public Attribute visitArray(java.util.List<? extends AnnotationValue> vals, Void p) {
            if (!vals.isEmpty()) {
                List<Attribute> valAttrs = List.nil();
                for (AnnotationValue annotationValue : vals) {
                    valAttrs = valAttrs.append(annotationValue.accept(this, p));
                }
                ArrayType arrayType = this.modelTypes.getArrayType(((Attribute)valAttrs.get((int)0)).type);
                return new Attribute.Array((Type)((Object)arrayType), valAttrs);
            }
            return new Attribute.Array((Type)this.meth.getReturnType(), List.nil());
        }

        @Override
        public Attribute visitUnknown(AnnotationValue av, Void p) {
            assert (false) : "Unexpected type of AnnotationValue: " + av.getClass();
            return null;
        }
    }
}

