/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.basic.internal;

import java.math.BigInteger;
import java.time.LocalDate;
import java.time.Period;
import java.time.YearMonth;
import java.util.Objects;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;

public class YearMonthEpochTypeDescriptor
extends AbstractTypeDescriptor<YearMonth> {
    public static final YearMonth YEAR_MONTH_EPOCH = YearMonth.of(1970, 1);
    public static final LocalDate LOCAL_DATE_EPOCH = YEAR_MONTH_EPOCH.atDay(1);
    public static final YearMonthEpochTypeDescriptor INSTANCE = new YearMonthEpochTypeDescriptor();

    public YearMonthEpochTypeDescriptor() {
        super(YearMonth.class);
    }

    public boolean areEqual(YearMonth one, YearMonth another) {
        return Objects.equals(one, another);
    }

    public String toString(YearMonth value) {
        return value.toString();
    }

    public YearMonth fromString(String string) {
        return YearMonth.parse(string);
    }

    public <X> X unwrap(YearMonth value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        Long monthsSinceEpoch = Period.between(LOCAL_DATE_EPOCH, value.atDay(1)).toTotalMonths();
        if (Short.class.isAssignableFrom(type)) {
            return (X)Short.valueOf(((Number)monthsSinceEpoch).shortValue());
        }
        if (Integer.class.isAssignableFrom(type)) {
            return (X)Integer.valueOf(((Number)monthsSinceEpoch).intValue());
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)monthsSinceEpoch;
        }
        if (BigInteger.class.isAssignableFrom(type)) {
            return (X)BigInteger.valueOf(monthsSinceEpoch);
        }
        throw this.unknownUnwrap(type);
    }

    public <X> YearMonth wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return YEAR_MONTH_EPOCH.plusMonths(((Number)value).intValue());
        }
        throw this.unknownWrap(value.getClass());
    }
}

