/*
 * Decompiled with CFR 0.152.
 */
package com.zenjava.javafx.maven.plugin;

import com.oracle.tools.packager.Log;
import com.sun.javafx.tools.packager.PackagerLib;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public abstract class AbstractJfxToolsMojo
extends AbstractMojo {
    protected MavenProject project;
    protected Boolean verbose;
    protected String mainClass;
    protected File jfxAppOutputDir;
    protected String jfxMainAppJarName;
    protected String deployDir;
    protected boolean useEnvironmentRelativeExecutables;
    protected boolean skip;
    protected String libFolderName;
    private PackagerLib packagerLib;

    public PackagerLib getPackagerLib() throws MojoExecutionException {
        if (this.packagerLib == null) {
            if (this.deployDir != null) {
                this.getLog().info((CharSequence)("Adding 'deploy' directory to Mojo classpath: " + this.deployDir));
                URLClassLoader sysloader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
                Class<URLClassLoader> sysclass = URLClassLoader.class;
                try {
                    Method method = sysclass.getDeclaredMethod("addURL", URL.class);
                    method.setAccessible(true);
                    method.invoke((Object)sysloader, new File(this.deployDir).toURI().toURL());
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | MalformedURLException ex) {
                    throw new MojoExecutionException("Error, could not add URL to system classloader", ex);
                }
            }
            Log.setLogger((Log.Logger)new Log.Logger(this.verbose.booleanValue()));
            this.packagerLib = new PackagerLib();
        }
        return this.packagerLib;
    }

    protected String getEnvironmentRelativeExecutablePath() {
        if (this.useEnvironmentRelativeExecutables) {
            return "";
        }
        String jrePath = System.getProperty("java.home");
        String jdkPath = jrePath + File.separator + ".." + File.separator + "bin" + File.separator;
        return jdkPath;
    }

    protected void copyRecursive(final Path sourceFolder, final Path targetFolder) throws IOException {
        Files.walkFileTree(sourceFolder, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path subfolder, BasicFileAttributes attrs) throws IOException {
                Files.createDirectories(targetFolder.resolve(sourceFolder.relativize(subfolder)), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path sourceFile, BasicFileAttributes attrs) throws IOException {
                Files.copy(sourceFile, targetFolder.resolve(sourceFolder.relativize(sourceFile)), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path source, IOException ioe) throws IOException {
                AbstractJfxToolsMojo.this.getLog().warn((CharSequence)String.format("Couldn't copy resource %s with reason %s", source.toString(), ioe.getLocalizedMessage()));
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path source, IOException ioe) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

