/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.Expression;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.RuntimeConfiguration;
import io.burt.jmespath.function.ArgumentTypeException;
import io.burt.jmespath.function.Function;
import io.burt.jmespath.function.FunctionRegistry;
import io.burt.jmespath.node.NodeFactory;
import io.burt.jmespath.node.StandardNodeFactory;
import io.burt.jmespath.parser.ExpressionParser;
import java.util.Collection;
import java.util.List;

public abstract class BaseRuntime<T>
implements Adapter<T> {
    private final FunctionRegistry functionRegistry;
    private final NodeFactory<T> nodeFactory;
    private final boolean silentTypeErrors;

    public BaseRuntime() {
        this(RuntimeConfiguration.defaultConfiguration());
    }

    public BaseRuntime(RuntimeConfiguration configuration) {
        this.silentTypeErrors = configuration.silentTypeErrors();
        this.functionRegistry = configuration.functionRegistry();
        this.nodeFactory = new StandardNodeFactory(this);
    }

    @Override
    public Expression<T> compile(String expression) {
        return ExpressionParser.fromString(this, expression);
    }

    @Override
    public int compare(T value1, T value2) {
        JmesPathType type2;
        JmesPathType type1 = this.typeOf(value1);
        if (type1 == (type2 = this.typeOf(value2))) {
            switch (type1) {
                case NULL: {
                    return 0;
                }
                case BOOLEAN: {
                    return this.isTruthy(value1) == this.isTruthy(value2) ? 0 : -1;
                }
                case NUMBER: {
                    double d1 = this.toNumber(value1).doubleValue();
                    double d2 = this.toNumber(value2).doubleValue();
                    return Double.compare(d1, d2);
                }
                case STRING: {
                    String s1 = this.toString(value1);
                    String s2 = this.toString(value2);
                    return s1.compareTo(s2);
                }
                case ARRAY: {
                    return this.deepEqualsArray(value1, value2) ? 0 : -1;
                }
                case OBJECT: {
                    return this.deepEqualsObject(value1, value2) ? 0 : -1;
                }
            }
            throw new IllegalStateException(String.format("Unknown node type encountered: %s", value1.getClass().getName()));
        }
        return -1;
    }

    private boolean deepEqualsArray(T value1, T value2) {
        List<T> values1 = this.toList(value1);
        List<T> values2 = this.toList(value2);
        int size = values1.size();
        if (size != values2.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (this.compare(values1.get(i), values2.get(i)) == 0) continue;
            return false;
        }
        return true;
    }

    private boolean deepEqualsObject(T value1, T value2) {
        Collection<T> keys1 = this.getPropertyNames(value1);
        Collection<T> keys2 = this.getPropertyNames(value2);
        if (keys1.size() != keys2.size()) {
            return false;
        }
        if (!keys1.containsAll(keys2)) {
            return false;
        }
        for (T key : keys1) {
            if (this.compare(this.getProperty(value1, key), this.getProperty(value2, key)) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public T handleArgumentTypeError(Function function, String expectedType, String actualType) {
        if (this.silentTypeErrors) {
            return this.createNull();
        }
        throw new ArgumentTypeException(function, expectedType, actualType);
    }

    @Override
    public FunctionRegistry functionRegistry() {
        return this.functionRegistry;
    }

    @Override
    public NodeFactory<T> nodeFactory() {
        return this.nodeFactory;
    }

    @Override
    public boolean equals(Object o) {
        return this.getClass().isInstance(o);
    }

    public int hashCode() {
        return 31;
    }

    @Override
    @Deprecated
    public T getProperty(T value, String name) {
        return this.getProperty(value, this.createString(name));
    }
}

