/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.component;

import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.internal.component.PropertiesTableComponent;
import io.github.swagger2markup.internal.resolver.DocumentResolver;
import io.github.swagger2markup.internal.type.ObjectType;
import io.github.swagger2markup.internal.type.ObjectTypePolymorphism;
import io.github.swagger2markup.internal.type.Type;
import io.github.swagger2markup.internal.utils.InlineSchemaUtils;
import io.github.swagger2markup.internal.utils.MarkupDocBuilderUtils;
import io.github.swagger2markup.internal.utils.ModelUtils;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.spi.DefinitionsDocumentExtension;
import io.github.swagger2markup.spi.MarkupComponent;
import io.swagger.models.Model;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class DefinitionComponent
extends MarkupComponent<Parameters> {
    private static final boolean ALWAYS_DISPLAY_DISCRIMINATOR = false;
    private final Map<String, Model> definitions;
    private final Map<ObjectTypePolymorphism.Nature, String> POLYMORPHISM_NATURE;
    private final DocumentResolver definitionsDocumentResolver;
    private PropertiesTableComponent propertiesTableComponent;

    public DefinitionComponent(Swagger2MarkupConverter.Context context, DocumentResolver definitionsDocumentResolver) {
        super(context);
        this.definitions = context.getSwagger().getDefinitions();
        this.definitionsDocumentResolver = definitionsDocumentResolver;
        this.POLYMORPHISM_NATURE = new HashMap<ObjectTypePolymorphism.Nature, String>(){
            {
                this.put(ObjectTypePolymorphism.Nature.COMPOSITION, DefinitionComponent.this.labels.getLabel("polymorphism.nature.COMPOSITION"));
                this.put(ObjectTypePolymorphism.Nature.INHERITANCE, DefinitionComponent.this.labels.getLabel("polymorphism.nature.INHERITANCE"));
            }
        };
        this.propertiesTableComponent = new PropertiesTableComponent(context, definitionsDocumentResolver);
    }

    public static Parameters parameters(String definitionName, Model model, int titleLevel) {
        return new Parameters(definitionName, model, titleLevel);
    }

    public MarkupDocBuilder apply(MarkupDocBuilder markupDocBuilder, Parameters params) {
        String definitionName = params.definitionName;
        Model model = params.model;
        this.applyDefinitionsDocumentExtension(new DefinitionsDocumentExtension.Context(DefinitionsDocumentExtension.Position.DEFINITION_BEFORE, markupDocBuilder, definitionName, model));
        markupDocBuilder.sectionTitleWithAnchorLevel(params.titleLevel, definitionName, definitionName);
        this.applyDefinitionsDocumentExtension(new DefinitionsDocumentExtension.Context(DefinitionsDocumentExtension.Position.DEFINITION_BEGIN, markupDocBuilder, definitionName, model));
        String description = model.getDescription();
        if (StringUtils.isNotBlank((CharSequence)description)) {
            markupDocBuilder.paragraph(MarkupDocBuilderUtils.markupDescription(this.config.getSwaggerMarkupLanguage(), markupDocBuilder, description));
        }
        this.inlineDefinitions(markupDocBuilder, this.typeSection(markupDocBuilder, definitionName, model), definitionName);
        this.applyDefinitionsDocumentExtension(new DefinitionsDocumentExtension.Context(DefinitionsDocumentExtension.Position.DEFINITION_END, markupDocBuilder, definitionName, model));
        this.applyDefinitionsDocumentExtension(new DefinitionsDocumentExtension.Context(DefinitionsDocumentExtension.Position.DEFINITION_AFTER, markupDocBuilder, definitionName, model));
        return markupDocBuilder;
    }

    private void addInlineDefinitionTitle(String title, String anchor, MarkupDocBuilder docBuilder) {
        docBuilder.anchor(anchor, null);
        docBuilder.newLine();
        docBuilder.boldTextLine(title);
    }

    private void inlineDefinitions(MarkupDocBuilder markupDocBuilder, List<ObjectType> definitions, String uniquePrefix) {
        if (CollectionUtils.isNotEmpty(definitions)) {
            for (ObjectType definition : definitions) {
                this.addInlineDefinitionTitle(definition.getName(), definition.getUniqueName(), markupDocBuilder);
                ArrayList<ObjectType> localDefinitions = new ArrayList<ObjectType>();
                this.propertiesTableComponent.apply(markupDocBuilder, new PropertiesTableComponent.Parameters(definition.getProperties(), uniquePrefix, localDefinitions));
                for (ObjectType localDefinition : localDefinitions) {
                    this.inlineDefinitions(markupDocBuilder, Collections.singletonList(localDefinition), localDefinition.getUniqueName());
                }
            }
        }
    }

    private List<ObjectType> typeSection(MarkupDocBuilder markupDocBuilder, String definitionName, Model model) {
        ArrayList<ObjectType> inlineDefinitions = new ArrayList<ObjectType>();
        Type modelType = ModelUtils.resolveRefType(ModelUtils.getType(model, this.definitions, this.definitionsDocumentResolver));
        if (!(modelType instanceof ObjectType) && this.config.isInlineSchemaEnabled()) {
            modelType = InlineSchemaUtils.createInlineType(modelType, definitionName, definitionName + " inline", inlineDefinitions);
        }
        if (modelType instanceof ObjectType) {
            ObjectType objectType = (ObjectType)modelType;
            MarkupDocBuilder typeInfos = MarkupDocBuilderUtils.copyMarkupDocBuilder(markupDocBuilder);
            switch (objectType.getPolymorphism().getNature()) {
                case COMPOSITION: {
                    typeInfos.italicText(this.labels.getLabel("polymorphism.column")).textLine(" : " + this.POLYMORPHISM_NATURE.get((Object)objectType.getPolymorphism().getNature()));
                    break;
                }
                case INHERITANCE: {
                    typeInfos.italicText(this.labels.getLabel("polymorphism.column")).textLine(" : " + this.POLYMORPHISM_NATURE.get((Object)objectType.getPolymorphism().getNature()));
                    typeInfos.italicText(this.labels.getLabel("polymorphism.discriminator")).textLine(" : " + objectType.getPolymorphism().getDiscriminator());
                    break;
                }
                case NONE: {
                    break;
                }
            }
            String typeInfosString = typeInfos.toString();
            if (StringUtils.isNotBlank((CharSequence)typeInfosString)) {
                markupDocBuilder.paragraph(typeInfosString, true);
            }
            this.propertiesTableComponent.apply(markupDocBuilder, PropertiesTableComponent.parameters(((ObjectType)modelType).getProperties(), definitionName, inlineDefinitions));
        } else if (modelType != null) {
            MarkupDocBuilder typeInfos = MarkupDocBuilderUtils.copyMarkupDocBuilder(markupDocBuilder);
            typeInfos.italicText(this.labels.getLabel("type_column")).textLine(" : " + modelType.displaySchema(markupDocBuilder));
            markupDocBuilder.paragraph(typeInfos.toString());
        }
        return inlineDefinitions;
    }

    private void applyDefinitionsDocumentExtension(DefinitionsDocumentExtension.Context context) {
        this.extensionRegistry.getDefinitionsDocumentExtensions().forEach(extension -> extension.apply(context));
    }

    public static class Parameters {
        private final String definitionName;
        private final Model model;
        private final int titleLevel;

        public Parameters(String definitionName, Model model, int titleLevel) {
            this.definitionName = (String)Validate.notBlank((CharSequence)definitionName, (String)"DefinitionName must not be empty", (Object[])new Object[0]);
            this.model = (Model)Validate.notNull((Object)model, (String)"Model must not be null", (Object[])new Object[0]);
            this.titleLevel = titleLevel;
        }
    }
}

