/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.component;

import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.internal.utils.MarkupDocBuilderUtils;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.spi.MarkupComponent;
import io.swagger.models.Info;
import io.swagger.models.License;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class LicenseInfoComponent
extends MarkupComponent<Parameters> {
    public LicenseInfoComponent(Swagger2MarkupConverter.Context context) {
        super(context);
    }

    public static Parameters parameters(Info info, int titleLevel) {
        return new Parameters(info, titleLevel);
    }

    public MarkupDocBuilder apply(MarkupDocBuilder markupDocBuilder, Parameters params) {
        Info info = params.info;
        License license = info.getLicense();
        String termOfService = info.getTermsOfService();
        if (license != null && (StringUtils.isNotBlank((CharSequence)license.getName()) || StringUtils.isNotBlank((CharSequence)license.getUrl())) || StringUtils.isNotBlank((CharSequence)termOfService)) {
            markupDocBuilder.sectionTitleLevel(params.titleLevel, this.labels.getLabel("license_information"));
            MarkupDocBuilder paragraph = MarkupDocBuilderUtils.copyMarkupDocBuilder(markupDocBuilder);
            if (license != null) {
                if (StringUtils.isNotBlank((CharSequence)license.getName())) {
                    paragraph.italicText(this.labels.getLabel("license")).textLine(" : " + license.getName());
                }
                if (StringUtils.isNotBlank((CharSequence)license.getUrl())) {
                    paragraph.italicText(this.labels.getLabel("license_url")).textLine(" : " + license.getUrl());
                }
            }
            paragraph.italicText(this.labels.getLabel("terms_of_service")).textLine(" : " + termOfService);
            markupDocBuilder.paragraph(paragraph.toString(), true);
        }
        return markupDocBuilder;
    }

    public static class Parameters {
        private final int titleLevel;
        private final Info info;

        public Parameters(Info info, int titleLevel) {
            this.info = (Info)Validate.notNull((Object)info, (String)"Info must not be null", (Object[])new Object[0]);
            this.titleLevel = titleLevel;
        }
    }
}

