/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.component;

import ch.netzwerg.paleo.ColumnIds;
import ch.netzwerg.paleo.StringColumn;
import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.internal.component.TableComponent;
import io.github.swagger2markup.internal.utils.MarkupDocBuilderUtils;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.spi.MarkupComponent;
import io.github.swagger2markup.spi.SecurityDocumentExtension;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class SecuritySchemeDefinitionComponent
extends MarkupComponent<Parameters> {
    private final TableComponent tableComponent;

    public SecuritySchemeDefinitionComponent(Swagger2MarkupConverter.Context context) {
        super(context);
        this.tableComponent = new TableComponent(context);
    }

    public static Parameters parameters(String securitySchemeDefinitionName, SecuritySchemeDefinition securitySchemeDefinition, int titleLevel) {
        return new Parameters(securitySchemeDefinitionName, securitySchemeDefinition, titleLevel);
    }

    public MarkupDocBuilder apply(MarkupDocBuilder markupDocBuilder, Parameters params) {
        String securitySchemeDefinitionName = params.securitySchemeDefinitionName;
        SecuritySchemeDefinition securitySchemeDefinition = params.securitySchemeDefinition;
        this.applySecurityDocumentExtension(new SecurityDocumentExtension.Context(SecurityDocumentExtension.Position.SECURITY_SCHEME_BEFORE, markupDocBuilder, securitySchemeDefinitionName, securitySchemeDefinition));
        markupDocBuilder.sectionTitleWithAnchorLevel(params.titleLevel, securitySchemeDefinitionName);
        this.applySecurityDocumentExtension(new SecurityDocumentExtension.Context(SecurityDocumentExtension.Position.SECURITY_SCHEME_BEGIN, markupDocBuilder, securitySchemeDefinitionName, securitySchemeDefinition));
        String description = securitySchemeDefinition.getDescription();
        if (StringUtils.isNotBlank((CharSequence)description)) {
            markupDocBuilder.paragraph(MarkupDocBuilderUtils.markupDescription(this.config.getSwaggerMarkupLanguage(), markupDocBuilder, description));
        }
        this.buildSecurityScheme(markupDocBuilder, securitySchemeDefinition);
        this.applySecurityDocumentExtension(new SecurityDocumentExtension.Context(SecurityDocumentExtension.Position.SECURITY_SCHEME_END, markupDocBuilder, securitySchemeDefinitionName, securitySchemeDefinition));
        this.applySecurityDocumentExtension(new SecurityDocumentExtension.Context(SecurityDocumentExtension.Position.SECURITY_SCHEME_AFTER, markupDocBuilder, securitySchemeDefinitionName, securitySchemeDefinition));
        return markupDocBuilder;
    }

    private MarkupDocBuilder buildSecurityScheme(MarkupDocBuilder markupDocBuilder, SecuritySchemeDefinition securityScheme) {
        String type = securityScheme.getType();
        MarkupDocBuilder paragraphBuilder = MarkupDocBuilderUtils.copyMarkupDocBuilder(markupDocBuilder);
        paragraphBuilder.italicText(this.labels.getLabel("security_type")).textLine(" : " + type);
        if (securityScheme instanceof ApiKeyAuthDefinition) {
            paragraphBuilder.italicText(this.labels.getLabel("security_name")).textLine(" : " + ((ApiKeyAuthDefinition)securityScheme).getName());
            paragraphBuilder.italicText(this.labels.getLabel("security_in")).textLine(" : " + ((ApiKeyAuthDefinition)securityScheme).getIn());
            return markupDocBuilder.paragraph(paragraphBuilder.toString(), true);
        }
        if (securityScheme instanceof OAuth2Definition) {
            OAuth2Definition oauth2Scheme = (OAuth2Definition)securityScheme;
            String flow = oauth2Scheme.getFlow();
            paragraphBuilder.italicText(this.labels.getLabel("security_flow")).textLine(" : " + flow);
            if (StringUtils.isNotBlank((CharSequence)oauth2Scheme.getAuthorizationUrl())) {
                paragraphBuilder.italicText(this.labels.getLabel("security_authorizationUrl")).textLine(" : " + oauth2Scheme.getAuthorizationUrl());
            }
            if (StringUtils.isNotBlank((CharSequence)oauth2Scheme.getTokenUrl())) {
                paragraphBuilder.italicText(this.labels.getLabel("security_tokenUrl")).textLine(" : " + oauth2Scheme.getTokenUrl());
            }
            StringColumn.Builder nameColumnBuilder = StringColumn.builder((ColumnIds.StringColumnId)ColumnIds.StringColumnId.of((String)this.labels.getLabel("name_column"))).putMetaData("widthRatio", "3").putMetaData("headerColumn", "true");
            StringColumn.Builder descriptionColumnBuilder = StringColumn.builder((ColumnIds.StringColumnId)ColumnIds.StringColumnId.of((String)this.labels.getLabel("description_column"))).putMetaData("widthRatio", "17").putMetaData("headerColumn", "true");
            if (oauth2Scheme.getScopes() != null) {
                for (Map.Entry scope : oauth2Scheme.getScopes().entrySet()) {
                    nameColumnBuilder.add((String)scope.getKey());
                    descriptionColumnBuilder.add((String)scope.getValue());
                }
            }
            markupDocBuilder.paragraph(paragraphBuilder.toString(), true);
            return this.tableComponent.apply(markupDocBuilder, TableComponent.parameters(nameColumnBuilder.build(), descriptionColumnBuilder.build()));
        }
        return markupDocBuilder.paragraph(paragraphBuilder.toString(), true);
    }

    private void applySecurityDocumentExtension(SecurityDocumentExtension.Context context) {
        this.extensionRegistry.getSecurityDocumentExtensions().forEach(extension -> extension.apply(context));
    }

    public static class Parameters {
        private final String securitySchemeDefinitionName;
        private final SecuritySchemeDefinition securitySchemeDefinition;
        private final int titleLevel;

        public Parameters(String securitySchemeDefinitionName, SecuritySchemeDefinition securitySchemeDefinition, int titleLevel) {
            this.securitySchemeDefinitionName = (String)Validate.notBlank((CharSequence)securitySchemeDefinitionName, (String)"SecuritySchemeDefinitionName must not be empty", (Object[])new Object[0]);
            this.securitySchemeDefinition = (SecuritySchemeDefinition)Validate.notNull((Object)securitySchemeDefinition, (String)"SecuritySchemeDefinition must not be null", (Object[])new Object[0]);
            this.titleLevel = titleLevel;
        }
    }
}

