/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.component;

import ch.netzwerg.paleo.DataFrame;
import ch.netzwerg.paleo.StringColumn;
import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.markup.builder.MarkupLanguage;
import io.github.swagger2markup.markup.builder.MarkupTableColumn;
import io.github.swagger2markup.spi.MarkupComponent;
import javaslang.collection.Array;
import javaslang.collection.IndexedSeq;
import javaslang.collection.List;
import org.apache.commons.lang3.StringUtils;

public class TableComponent
extends MarkupComponent<Parameters> {
    public static final String WIDTH_RATIO = "widthRatio";
    public static final String HEADER_COLUMN = "headerColumn";

    public TableComponent(Swagger2MarkupConverter.Context context) {
        super(context);
    }

    public static Parameters parameters(StringColumn ... columns) {
        return new Parameters(columns);
    }

    public static boolean isNotBlank(StringColumn column) {
        return !column.getValues().filter(StringUtils::isNotBlank).isEmpty();
    }

    public MarkupDocBuilder apply(MarkupDocBuilder markupDocBuilder, Parameters params) {
        DataFrame dataFrame = params.dataFrame;
        java.util.List columnSpecs = dataFrame.getColumns().map(column -> {
            Integer widthRatio = Integer.valueOf((String)column.getMetaData().get((Object)WIDTH_RATIO).getOrElse((Object)"0"));
            return new MarkupTableColumn(column.getId().getName()).withWidthRatio(widthRatio).withHeaderColumn(Boolean.parseBoolean((String)column.getMetaData().get((Object)HEADER_COLUMN).getOrElse((Object)"false"))).withMarkupSpecifiers(MarkupLanguage.ASCIIDOC, ".^" + widthRatio);
        }).toJavaList();
        IndexedSeq columnValues = dataFrame.getColumns().map(column -> ((StringColumn)column).getValues());
        java.util.List cells = Array.range((int)0, (int)dataFrame.getRowCount()).map(rowNumber -> columnValues.map(values -> (String)values.get(rowNumber.intValue())).toJavaList()).toJavaList();
        return markupDocBuilder.tableWithColumnSpecs(columnSpecs, cells);
    }

    public static class Parameters {
        private final DataFrame dataFrame;

        public Parameters(StringColumn ... columns) {
            this.dataFrame = DataFrame.ofAll((Iterable)List.of((Object[])columns).filter(TableComponent::isNotBlank));
        }
    }
}

