/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.document;

import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.internal.component.DefinitionComponent;
import io.github.swagger2markup.internal.resolver.DefinitionDocumentNameResolver;
import io.github.swagger2markup.internal.resolver.DefinitionDocumentResolverDefault;
import io.github.swagger2markup.internal.resolver.DefinitionDocumentResolverFromDefinition;
import io.github.swagger2markup.internal.utils.MarkupDocBuilderUtils;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.spi.DefinitionsDocumentExtension;
import io.github.swagger2markup.spi.MarkupComponent;
import io.swagger.models.Model;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class DefinitionsDocument
extends MarkupComponent<Parameters> {
    private static final String DEFINITIONS_ANCHOR = "definitions";
    private static final List<String> IGNORED_DEFINITIONS = Collections.singletonList("Void");
    private final DefinitionComponent definitionComponent;
    private final DefinitionDocumentResolverDefault definitionDocumentResolverDefault;
    private final DefinitionDocumentNameResolver definitionDocumentNameResolver;

    public DefinitionsDocument(Swagger2MarkupConverter.Context context) {
        super(context);
        if (this.config.isSeparatedDefinitionsEnabled()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Create separated definition files is enabled.");
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Create separated definition files is disabled.");
        }
        this.definitionDocumentNameResolver = new DefinitionDocumentNameResolver(context);
        this.definitionComponent = new DefinitionComponent(context, new DefinitionDocumentResolverFromDefinition(context));
        this.definitionDocumentResolverDefault = new DefinitionDocumentResolverDefault(context);
    }

    public static Parameters parameters(Map<String, Model> definitions) {
        return new Parameters(definitions);
    }

    public MarkupDocBuilder apply(MarkupDocBuilder markupDocBuilder, Parameters params) {
        Map definitions = params.definitions;
        if (MapUtils.isNotEmpty((Map)definitions)) {
            this.applyDefinitionsDocumentExtension(new DefinitionsDocumentExtension.Context(DefinitionsDocumentExtension.Position.DOCUMENT_BEFORE, markupDocBuilder));
            this.buildDefinitionsTitle(markupDocBuilder, this.labels.getLabel(DEFINITIONS_ANCHOR));
            this.applyDefinitionsDocumentExtension(new DefinitionsDocumentExtension.Context(DefinitionsDocumentExtension.Position.DOCUMENT_BEGIN, markupDocBuilder));
            this.buildDefinitionsSection(markupDocBuilder, definitions);
            this.applyDefinitionsDocumentExtension(new DefinitionsDocumentExtension.Context(DefinitionsDocumentExtension.Position.DOCUMENT_END, markupDocBuilder));
            this.applyDefinitionsDocumentExtension(new DefinitionsDocumentExtension.Context(DefinitionsDocumentExtension.Position.DOCUMENT_AFTER, markupDocBuilder));
        }
        return markupDocBuilder;
    }

    private void buildDefinitionsTitle(MarkupDocBuilder markupDocBuilder, String title) {
        markupDocBuilder.sectionTitleWithAnchorLevel1(title, DEFINITIONS_ANCHOR);
    }

    private void buildDefinitionsSection(MarkupDocBuilder markupDocBuilder, Map<String, Model> definitions) {
        Map<String, Model> sortedMap = io.github.swagger2markup.internal.utils.MapUtils.toSortedMap(definitions, this.config.getDefinitionOrdering());
        sortedMap.forEach((definitionName, model) -> {
            if (StringUtils.isNotBlank((CharSequence)definitionName) && this.checkThatDefinitionIsNotInIgnoreList((String)definitionName)) {
                this.buildDefinition(markupDocBuilder, (String)definitionName, (Model)model);
            }
        });
    }

    private void applyDefinitionsDocumentExtension(DefinitionsDocumentExtension.Context context) {
        this.extensionRegistry.getDefinitionsDocumentExtensions().forEach(extension -> extension.apply(context));
    }

    private void buildDefinition(MarkupDocBuilder markupDocBuilder, String definitionName, Model model) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Definition processed : '{}'", (Object)definitionName);
        }
        if (this.config.isSeparatedDefinitionsEnabled()) {
            MarkupDocBuilder defDocBuilder = MarkupDocBuilderUtils.copyMarkupDocBuilder(markupDocBuilder);
            this.applyDefinitionComponent(defDocBuilder, definitionName, model);
            Path definitionFile = this.context.getOutputPath().resolve(this.definitionDocumentNameResolver.apply(definitionName));
            defDocBuilder.writeToFileWithoutExtension(definitionFile, StandardCharsets.UTF_8, new OpenOption[0]);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Separate definition file produced : '{}'", (Object)definitionFile);
            }
            this.definitionRef(markupDocBuilder, definitionName);
        } else {
            this.applyDefinitionComponent(markupDocBuilder, definitionName, model);
        }
    }

    private boolean checkThatDefinitionIsNotInIgnoreList(String definitionName) {
        return !IGNORED_DEFINITIONS.contains(definitionName);
    }

    private void applyDefinitionComponent(MarkupDocBuilder markupDocBuilder, String definitionName, Model model) {
        this.definitionComponent.apply(markupDocBuilder, DefinitionComponent.parameters(definitionName, model, 2));
    }

    private void definitionRef(MarkupDocBuilder markupDocBuilder, String definitionName) {
        this.buildDefinitionTitle(markupDocBuilder, MarkupDocBuilderUtils.crossReference(markupDocBuilder, this.definitionDocumentResolverDefault.apply(definitionName), definitionName, definitionName), "ref-" + definitionName);
    }

    private void buildDefinitionTitle(MarkupDocBuilder markupDocBuilder, String title, String anchor) {
        markupDocBuilder.sectionTitleWithAnchorLevel2(title, anchor);
    }

    public static class Parameters {
        private final Map<String, Model> definitions;

        public Parameters(Map<String, Model> definitions) {
            this.definitions = definitions;
        }
    }
}

