/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.spi;

import com.google.common.base.Optional;
import io.github.swagger2markup.GroupBy;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.model.PathOperation;
import io.github.swagger2markup.spi.AbstractExtension;
import io.github.swagger2markup.spi.ContentContext;
import org.apache.commons.lang3.Validate;

public abstract class PathsDocumentExtension
extends AbstractExtension {
    public abstract void apply(Context var1);

    protected int levelOffset(Context context) {
        int levelOffset;
        switch (context.position) {
            case DOCUMENT_BEFORE: 
            case DOCUMENT_AFTER: {
                levelOffset = 0;
                break;
            }
            case DOCUMENT_BEGIN: 
            case DOCUMENT_END: 
            case OPERATION_BEFORE: 
            case OPERATION_AFTER: {
                levelOffset = 1;
                break;
            }
            case OPERATION_BEGIN: 
            case OPERATION_END: {
                levelOffset = this.increaseLevelOffset(2);
                break;
            }
            case OPERATION_DESCRIPTION_BEFORE: 
            case OPERATION_DESCRIPTION_AFTER: 
            case OPERATION_PARAMETERS_BEFORE: 
            case OPERATION_PARAMETERS_AFTER: 
            case OPERATION_RESPONSES_BEFORE: 
            case OPERATION_RESPONSES_AFTER: 
            case OPERATION_SECURITY_BEFORE: 
            case OPERATION_SECURITY_AFTER: {
                levelOffset = this.increaseLevelOffset(2);
                break;
            }
            case OPERATION_DESCRIPTION_BEGIN: 
            case OPERATION_DESCRIPTION_END: 
            case OPERATION_PARAMETERS_BEGIN: 
            case OPERATION_PARAMETERS_END: 
            case OPERATION_RESPONSES_BEGIN: 
            case OPERATION_RESPONSES_END: 
            case OPERATION_SECURITY_BEGIN: 
            case OPERATION_SECURITY_END: {
                levelOffset = 3;
                break;
            }
            default: {
                throw new RuntimeException(String.format("Unknown position '%s'", new Object[]{context.position}));
            }
        }
        return levelOffset;
    }

    private int increaseLevelOffset(int levelOffset) {
        if (this.globalContext.getConfig().getPathsGroupedBy() == GroupBy.TAGS) {
            return ++levelOffset;
        }
        return levelOffset;
    }

    public static class Context
    extends ContentContext {
        private Position position;
        private PathOperation operation;

        public Context(Position position, MarkupDocBuilder docBuilder) {
            super(docBuilder);
            Validate.inclusiveBetween((Object)((Object)Position.DOCUMENT_BEFORE), (Object)((Object)Position.DOCUMENT_AFTER), (Comparable)((Object)position));
            this.position = position;
        }

        public Context(Position position, MarkupDocBuilder docBuilder, PathOperation operation) {
            super(docBuilder);
            Validate.inclusiveBetween((Object)((Object)Position.OPERATION_BEFORE), (Object)((Object)Position.OPERATION_SECURITY_AFTER), (Comparable)((Object)position));
            Validate.notNull((Object)operation);
            this.position = position;
            this.operation = operation;
        }

        public Position getPosition() {
            return this.position;
        }

        public Optional<PathOperation> getOperation() {
            return Optional.fromNullable((Object)this.operation);
        }
    }

    public static enum Position {
        DOCUMENT_BEFORE,
        DOCUMENT_BEGIN,
        DOCUMENT_END,
        DOCUMENT_AFTER,
        OPERATION_BEFORE,
        OPERATION_BEGIN,
        OPERATION_END,
        OPERATION_AFTER,
        OPERATION_DESCRIPTION_BEFORE,
        OPERATION_DESCRIPTION_BEGIN,
        OPERATION_DESCRIPTION_END,
        OPERATION_DESCRIPTION_AFTER,
        OPERATION_PARAMETERS_BEFORE,
        OPERATION_PARAMETERS_BEGIN,
        OPERATION_PARAMETERS_END,
        OPERATION_PARAMETERS_AFTER,
        OPERATION_RESPONSES_BEFORE,
        OPERATION_RESPONSES_BEGIN,
        OPERATION_RESPONSES_END,
        OPERATION_RESPONSES_AFTER,
        OPERATION_SECURITY_BEFORE,
        OPERATION_SECURITY_BEGIN,
        OPERATION_SECURITY_END,
        OPERATION_SECURITY_AFTER;

    }
}

