/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup;

import io.github.swagger2markup.GroupBy;
import io.github.swagger2markup.Language;
import io.github.swagger2markup.OrderBy;
import io.github.swagger2markup.PageBreakLocations;
import io.github.swagger2markup.markup.builder.MarkupLanguage;
import io.github.swagger2markup.utils.URIUtils;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationConverter;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.commons.configuration2.ex.ConversionException;

public class Swagger2MarkupProperties {
    public static final String PROPERTIES_PREFIX = "swagger2markup";
    public static final String MARKUP_LANGUAGE = "swagger2markup.markupLanguage";
    public static final String SWAGGER_MARKUP_LANGUAGE = "swagger2markup.swaggerMarkupLanguage";
    public static final String GENERATED_EXAMPLES_ENABLED = "swagger2markup.generatedExamplesEnabled";
    public static final String BASE_PATH_PREFIX_ENABLED = "swagger2markup.basePathPrefixEnabled";
    public static final String SEPARATED_DEFINITIONS_ENABLED = "swagger2markup.separatedDefinitionsEnabled";
    public static final String SEPARATED_OPERATIONS_ENABLED = "swagger2markup.separatedOperationsEnabled";
    public static final String PATHS_GROUPED_BY = "swagger2markup.pathsGroupedBy";
    public static final String HEADER_REGEX = "swagger2markup.headerRegex";
    public static final String OUTPUT_LANGUAGE = "swagger2markup.outputLanguage";
    public static final String INLINE_SCHEMA_ENABLED = "swagger2markup.inlineSchemaEnabled";
    public static final String INTER_DOCUMENT_CROSS_REFERENCES_ENABLED = "swagger2markup.interDocumentCrossReferencesEnabled";
    public static final String INTER_DOCUMENT_CROSS_REFERENCES_PREFIX = "swagger2markup.interDocumentCrossReferencesPrefix";
    public static final String FLAT_BODY_ENABLED = "swagger2markup.flatBodyEnabled";
    public static final String PATH_SECURITY_SECTION_ENABLED = "swagger2markup.pathSecuritySectionEnabled";
    public static final String ANCHOR_PREFIX = "swagger2markup.anchorPrefix";
    public static final String LIST_DELIMITER = "swagger2markup.listDelimiter";
    public static final String LIST_DELIMITER_ENABLED = "swagger2markup.listDelimiterEnabled";
    public static final String OVERVIEW_DOCUMENT = "swagger2markup.overviewDocument";
    public static final String PATHS_DOCUMENT = "swagger2markup.pathsDocument";
    public static final String DEFINITIONS_DOCUMENT = "swagger2markup.definitionsDocument";
    public static final String SECURITY_DOCUMENT = "swagger2markup.securityDocument";
    public static final String SEPARATED_OPERATIONS_FOLDER = "swagger2markup.separatedOperationsFolder";
    public static final String SEPARATED_DEFINITIONS_FOLDER = "swagger2markup.separatedDefinitionsFolder";
    public static final String TAG_ORDER_BY = "swagger2markup.tagOrderBy";
    public static final String OPERATION_ORDER_BY = "swagger2markup.operationOrderBy";
    public static final String DEFINITION_ORDER_BY = "swagger2markup.definitionOrderBy";
    public static final String PARAMETER_ORDER_BY = "swagger2markup.parameterOrderBy";
    public static final String PROPERTY_ORDER_BY = "swagger2markup.propertyOrderBy";
    public static final String RESPONSE_ORDER_BY = "swagger2markup.responseOrderBy";
    public static final String LINE_SEPARATOR = "swagger2markup.lineSeparator";
    public static final String PAGE_BREAK_LOCATIONS = "swagger2markup.pageBreakLocations";
    public static final String EXTENSION_PREFIX = "extensions";
    private final Configuration configuration;

    public Swagger2MarkupProperties(Properties properties) {
        this(ConfigurationConverter.getConfiguration((Properties)properties));
    }

    public Swagger2MarkupProperties(Map<String, String> map) {
        this((Configuration)new MapConfiguration(map));
    }

    public Swagger2MarkupProperties(Configuration configuration) {
        this.configuration = configuration;
    }

    public Optional<String> getString(String key) {
        return Optional.ofNullable(this.configuration.getString(key));
    }

    public String getString(String key, String defaultValue) {
        return this.configuration.getString(key, defaultValue);
    }

    public int getInt(String key, int defaultValue) {
        return this.configuration.getInt(key, defaultValue);
    }

    public Optional<Integer> getInteger(String key) {
        return Optional.ofNullable(this.configuration.getInteger(key, null));
    }

    public int getRequiredInt(String key) {
        Optional<Integer> value = this.getInteger(key);
        if (value.isPresent()) {
            return value.get();
        }
        throw new IllegalStateException(String.format("required key [%s] not found", key));
    }

    public boolean getRequiredBoolean(String key) {
        Boolean value = this.configuration.getBoolean(key, null);
        if (value != null) {
            return value;
        }
        throw new IllegalStateException(String.format("required key [%s] not found", key));
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.configuration.getBoolean(key, defaultValue);
    }

    public Optional<URI> getURI(String key) {
        Optional<String> property = this.getString(key);
        if (property.isPresent()) {
            return Optional.of(URIUtils.create(property.get()));
        }
        return Optional.empty();
    }

    public URI getRequiredURI(String key) {
        Optional<String> property = this.getString(key);
        if (property.isPresent()) {
            return URIUtils.create(property.get());
        }
        throw new IllegalStateException(String.format("required key [%s] not found", key));
    }

    public Optional<Path> getPath(String key) {
        Optional<String> property = this.getString(key);
        if (property.isPresent()) {
            return Optional.of(Paths.get(property.get(), new String[0]));
        }
        return Optional.empty();
    }

    public List<Path> getPathList(String key) {
        ArrayList<Path> pathList = new ArrayList<Path>();
        try {
            String[] stringList;
            for (String pathStr : stringList = this.configuration.getStringArray(key)) {
                pathList.add(Paths.get(pathStr, new String[0]));
            }
        }
        catch (ConversionException ce) {
            throw new IllegalStateException(String.format("requested key [%s] is not convertable to an array", key));
        }
        return pathList;
    }

    public Path getRequiredPath(String key) {
        Optional<String> property = this.getString(key);
        if (property.isPresent()) {
            return Paths.get(property.get(), new String[0]);
        }
        throw new IllegalStateException(String.format("required key [%s] not found", key));
    }

    public Optional<MarkupLanguage> getMarkupLanguage(String key) {
        Optional<String> property = this.getString(key);
        if (property.isPresent()) {
            return Optional.of(MarkupLanguage.valueOf((String)property.get()));
        }
        return Optional.empty();
    }

    public MarkupLanguage getRequiredMarkupLanguage(String key) {
        return MarkupLanguage.valueOf((String)this.configuration.getString(key));
    }

    public Language getLanguage(String key) {
        return Language.valueOf(this.configuration.getString(key));
    }

    public GroupBy getGroupBy(String key) {
        return GroupBy.valueOf(this.configuration.getString(key));
    }

    public OrderBy getOrderBy(String key) {
        return OrderBy.valueOf(this.configuration.getString(key));
    }

    public String getRequiredString(String key) throws IllegalStateException {
        Optional<String> property = this.getString(key);
        if (property.isPresent()) {
            return property.get();
        }
        throw new IllegalStateException(String.format("required key [%s] not found", key));
    }

    public List<String> getKeys() {
        return IteratorUtils.toList((Iterator)this.configuration.getKeys());
    }

    public List<String> getKeys(String prefix) {
        return IteratorUtils.toList((Iterator)this.configuration.getKeys(prefix));
    }

    public List<PageBreakLocations> getPageBreakLocations(String key) {
        ArrayList result = this.configuration.getList(PageBreakLocations.class, key);
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }

    public Optional<Pattern> getHeaderPattern(String key) {
        Optional<String> property = this.getString(key);
        if (property.isPresent()) {
            return Optional.of(Pattern.compile(property.get()));
        }
        return Optional.empty();
    }
}

