/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.utils;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import io.github.swagger2markup.model.PathOperation;
import io.swagger.models.Tag;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagUtils {
    private static Logger logger = LoggerFactory.getLogger(TagUtils.class);

    public static Map<String, Tag> toSortedMap(List<Tag> tags, Comparator<String> comparator) {
        AbstractMap sortedMap = comparator == null ? new LinkedHashMap() : new TreeMap(comparator);
        tags.forEach(tag -> sortedMap.put(tag.getName(), tag));
        return sortedMap;
    }

    public static Multimap<String, PathOperation> groupOperationsByTag(List<PathOperation> allOperations, Comparator<PathOperation> operationOrdering) {
        Object operationsGroupedByTag = operationOrdering == null ? LinkedHashMultimap.create() : MultimapBuilder.linkedHashKeys().treeSetValues(operationOrdering).build();
        for (PathOperation operation : allOperations) {
            List tags = operation.getOperation().getTags();
            Validate.notEmpty((Collection)tags, (String)"Can't GroupBy.TAGS. Operation '%s' has no tags", (Object[])new Object[]{operation});
            for (String tag : tags) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Added path operation '{}' to tag '{}'", (Object)operation, (Object)tag);
                }
                operationsGroupedByTag.put((Object)tag, (Object)operation);
            }
        }
        return operationsGroupedByTag;
    }
}

