/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.common.runtime;

import io.netty.handler.ssl.SslProvider;
import io.quarkus.amazon.common.runtime.TlsKeyManagersProviderConfig;
import io.quarkus.amazon.common.runtime.TlsTrustManagersProviderConfig;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.configuration.DurationConverter;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import software.amazon.awssdk.http.Protocol;

@ConfigGroup
public interface AsyncHttpClientConfig {
    @WithDefault(value="50")
    public int maxConcurrency();

    @WithDefault(value="10000")
    public int maxPendingConnectionAcquires();

    @WithDefault(value="30S")
    @WithConverter(value=DurationConverter.class)
    public Duration readTimeout();

    @WithDefault(value="30S")
    @WithConverter(value=DurationConverter.class)
    public Duration writeTimeout();

    @WithDefault(value="10S")
    @WithConverter(value=DurationConverter.class)
    public Duration connectionTimeout();

    @WithDefault(value="2S")
    @WithConverter(value=DurationConverter.class)
    public Duration connectionAcquisitionTimeout();

    @WithConverter(value=DurationConverter.class)
    public Optional<Duration> connectionTimeToLive();

    @WithDefault(value="5S")
    @WithConverter(value=DurationConverter.class)
    public Duration connectionMaxIdleTime();

    @WithDefault(value="true")
    public boolean useIdleConnectionReaper();

    @WithDefault(value="false")
    public Boolean tcpKeepAlive();

    @WithDefault(value="http1-1")
    public Protocol protocol();

    public Optional<SslProviderType> sslProvider();

    public Http2Config http2();

    public NettyProxyConfiguration proxy();

    public TlsKeyManagersProviderConfig tlsKeyManagersProvider();

    public TlsTrustManagersProviderConfig tlsTrustManagersProvider();

    public SdkEventLoopGroupConfig eventLoop();

    public Advanced advanced();

    public static enum SslProviderType {
        JDK{

            @Override
            SslProvider create() {
                return SslProvider.JDK;
            }
        }
        ,
        OPENSSL{

            @Override
            SslProvider create() {
                return SslProvider.OPENSSL;
            }
        }
        ,
        OPENSSL_REFCNT{

            @Override
            SslProvider create() {
                return SslProvider.OPENSSL_REFCNT;
            }
        };


        abstract SslProvider create();
    }

    @ConfigGroup
    public static interface Advanced {
        @WithDefault(value="true")
        public boolean useFutureCompletionThreadPool();
    }

    @ConfigGroup
    public static interface NettyProxyConfiguration {
        @WithDefault(value="false")
        public boolean enabled();

        public Optional<URI> endpoint();

        public Optional<List<String>> nonProxyHosts();
    }

    @ConfigGroup
    public static interface SdkEventLoopGroupConfig {
        @WithDefault(value="false")
        public boolean override();

        public OptionalInt numberOfThreads();

        public Optional<String> threadNamePrefix();
    }

    @ConfigGroup
    public static interface Http2Config {
        public Optional<Long> maxStreams();

        public OptionalInt initialWindowSize();

        @WithConverter(value=DurationConverter.class)
        public Optional<Duration> healthCheckPingPeriod();
    }
}

