/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.freemarker.runtime;

import freemarker.template.Configuration;
import freemarker.template.Template;
import io.quarkiverse.freemarker.TemplatePath;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.lang.annotation.Annotation;

@Singleton
public class FreemarkerTemplateProducer {
    @Inject
    Configuration configuration;

    @Produces
    @TemplatePath(value="ignored")
    Template getTemplate(InjectionPoint injectionPoint) throws IOException {
        TemplatePath path = null;
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(TemplatePath.class)) continue;
            path = (TemplatePath)qualifier;
            break;
        }
        if (path == null || path.value().isEmpty()) {
            throw new IllegalStateException("No template resource path specified");
        }
        return this.configuration.getTemplate(path.value());
    }
}

