/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.impl.TypeCachePollutionUtils;
import io.quarkus.arc.impl.TypeResolver;
import io.quarkus.arc.impl.Types;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class HierarchyDiscovery {
    private final Map<Class<?>, Type> types = new HashMap();
    private final Map<TypeVariable<?>, Type> resolvedTypeVariables;
    private final TypeResolver resolver;
    private final Set<Type> typeClosure;

    public HierarchyDiscovery(Type type) {
        this(type, new TypeResolver(new HashMap()));
    }

    public HierarchyDiscovery(Type type, TypeResolver resolver) {
        this.resolver = resolver;
        this.resolvedTypeVariables = resolver.getResolvedTypeVariables();
        this.discoverTypes(type, false);
        this.typeClosure = new HashSet<Type>(this.types.values());
    }

    public Set<Type> getTypeClosure() {
        return this.typeClosure;
    }

    public Map<Class<?>, Type> getTypeMap() {
        return this.types;
    }

    protected void discoverTypes(Type type, boolean rawGeneric) {
        ParameterizedType parameterizedType;
        Type rawType;
        if (!rawGeneric) {
            rawGeneric = Types.isRawGenericType(type);
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            this.types.put(clazz, clazz);
            this.discoverFromClass(clazz, rawGeneric);
        } else if (rawGeneric) {
            this.discoverTypes(Types.getRawType(type), rawGeneric);
        } else if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            Type genericComponentType = arrayType.getGenericComponentType();
            Class rawComponentType = Types.getRawType(genericComponentType);
            if (rawComponentType != null) {
                Class<?> arrayClass = Array.newInstance(rawComponentType, 0).getClass();
                this.types.put(arrayClass, type);
                this.discoverFromClass(arrayClass, rawGeneric);
            }
        } else if (TypeCachePollutionUtils.isParameterizedType(type) && (rawType = (parameterizedType = TypeCachePollutionUtils.asParameterizedType(type)).getRawType()) instanceof Class) {
            Class clazz = (Class)rawType;
            this.processTypeVariables(clazz.getTypeParameters(), parameterizedType.getActualTypeArguments());
            this.types.put(clazz, type);
            this.discoverFromClass(clazz, rawGeneric);
        }
    }

    protected void discoverFromClass(Class<?> clazz, boolean rawGeneric) {
        if (clazz.getSuperclass() != null) {
            this.discoverTypes(this.processAndResolveType(clazz.getGenericSuperclass(), clazz.getSuperclass()), rawGeneric);
        }
        this.discoverInterfaces(clazz, rawGeneric);
    }

    protected void discoverInterfaces(Class<?> clazz, boolean rawGeneric) {
        Class<?>[] interfaces;
        Type[] genericInterfaces = clazz.getGenericInterfaces();
        if (genericInterfaces.length == (interfaces = clazz.getInterfaces()).length) {
            for (int i = 0; i < interfaces.length; ++i) {
                this.discoverTypes(this.processAndResolveType(genericInterfaces[i], interfaces[i]), rawGeneric);
            }
        }
    }

    protected Type processAndResolveType(Type superclass, Class<?> rawSuperclass) {
        if (TypeCachePollutionUtils.isParameterizedType(superclass)) {
            ParameterizedType parameterizedSuperclass = TypeCachePollutionUtils.asParameterizedType(superclass);
            this.processTypeVariables(rawSuperclass.getTypeParameters(), parameterizedSuperclass.getActualTypeArguments());
            return this.resolveType(parameterizedSuperclass);
        }
        if (superclass instanceof Class) {
            return superclass;
        }
        throw new RuntimeException("Unexpected type: " + superclass);
    }

    private void processTypeVariables(TypeVariable<?>[] variables, Type[] values) {
        for (int i = 0; i < variables.length; ++i) {
            this.processTypeVariable(variables[i], values[i]);
        }
    }

    private void processTypeVariable(TypeVariable<?> variable, Type value) {
        if (value instanceof TypeVariable) {
            value = this.resolveType(value);
        }
        this.resolvedTypeVariables.put(variable, value);
    }

    public Type resolveType(Type type) {
        Type resolvedType;
        if (type instanceof Class && (resolvedType = this.types.get(type)) != null) {
            return resolvedType;
        }
        return this.resolver.resolveType(type);
    }

    public TypeResolver getResolver() {
        return this.resolver;
    }
}

