/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import java.util.Objects;
import java.util.function.Predicate;

public final class Parameter {
    public static final String EMPTY = "$empty$";
    public final String name;
    public final String defaultValue;
    public final boolean optional;
    public final Predicate<String> valuePredicate;
    private static final Predicate<String> ALWAYS_TRUE = v -> true;

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public Parameter(String name, String defaultValue, boolean optional) {
        this(name, defaultValue, optional, ALWAYS_TRUE);
    }

    private Parameter(String name, String defaultValue, boolean optional, Predicate<String> valuePredicate) {
        this.name = Objects.requireNonNull(name);
        this.defaultValue = defaultValue;
        this.optional = optional;
        this.valuePredicate = valuePredicate != null ? valuePredicate : ALWAYS_TRUE;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean accepts(String value) {
        return this.valuePredicate.test(value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Parameter [name=").append(this.name).append(", defaultValue=").append(this.defaultValue).append(", optional=").append(this.optional).append("]");
        return builder.toString();
    }

    public static class Builder {
        private final String name;
        private String defaultValue;
        private boolean optional;
        private Predicate<String> valuePredicate;

        public Builder(String name) {
            this.name = name;
            this.optional = false;
        }

        public Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder optional() {
            this.optional = true;
            return this;
        }

        public Builder valuePredicate(Predicate<String> valuePredicate) {
            this.valuePredicate = valuePredicate;
            return this;
        }

        public Parameter build() {
            return new Parameter(this.name, this.defaultValue, this.optional, this.valuePredicate);
        }
    }
}

