/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Engine;
import io.quarkus.qute.EngineImpl;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.Expression;
import io.quarkus.qute.FragmentSectionHelper;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.LazyValue;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.ParameterDeclaration;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.ResolutionContextImpl;
import io.quarkus.qute.Results;
import io.quarkus.qute.SectionNode;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.TemplateInstanceBase;
import io.quarkus.qute.TemplateNode;
import io.quarkus.qute.Variant;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.MultiEmitter;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

class TemplateImpl
implements Template {
    private static final Logger LOG = Logger.getLogger(TemplateImpl.class);
    private final String templateId;
    private final String generatedId;
    private final EngineImpl engine;
    private final Optional<Variant> variant;
    final SectionNode root;
    private final List<ParameterDeclaration> parameterDeclarations;
    private final LazyValue<Map<String, Template.Fragment>> fragments;

    TemplateImpl(EngineImpl engine, SectionNode root, String templateId, String generatedId, Optional<Variant> variant) {
        this.engine = engine;
        this.root = root;
        this.templateId = templateId;
        this.generatedId = generatedId;
        this.variant = variant;
        this.parameterDeclarations = ImmutableList.copyOf(root.getParameterDeclarations());
        this.fragments = this.initFragments(root);
    }

    @Override
    public TemplateInstance instance() {
        TemplateInstanceImpl instance = new TemplateInstanceImpl();
        if (!this.engine.initializers.isEmpty()) {
            for (TemplateInstance.Initializer initializer : this.engine.initializers) {
                initializer.accept(instance);
            }
        }
        return instance;
    }

    @Override
    public List<Expression> getExpressions() {
        return this.root.getExpressions();
    }

    @Override
    public Expression findExpression(Predicate<Expression> predicate) {
        return this.root.findExpression(predicate);
    }

    @Override
    public List<ParameterDeclaration> getParameterDeclarations() {
        return this.parameterDeclarations;
    }

    @Override
    public String getGeneratedId() {
        return this.generatedId;
    }

    @Override
    public String getId() {
        return this.templateId;
    }

    @Override
    public Optional<Variant> getVariant() {
        return this.variant;
    }

    public String toString() {
        return "Template " + this.templateId + " [generatedId=" + this.generatedId + "]";
    }

    @Override
    public Template.Fragment getFragment(String identifier) {
        return this.fragments != null ? this.fragments.get().get(Objects.requireNonNull(identifier)) : null;
    }

    private LazyValue<Map<String, Template.Fragment>> initFragments(final SectionNode section) {
        if (section.name.equals("$root")) {
            return new LazyValue<Map<String, Template.Fragment>>(new Supplier<Map<String, Template.Fragment>>(){

                @Override
                public Map<String, Template.Fragment> get() {
                    Predicate<TemplateNode> isFragmentNode = new Predicate<TemplateNode>(){

                        @Override
                        public boolean test(TemplateNode node) {
                            if (!node.isSection()) {
                                return false;
                            }
                            SectionNode sectionNode = (SectionNode)node;
                            return sectionNode.helper instanceof FragmentSectionHelper;
                        }
                    };
                    List<TemplateNode> fragmentNodes = section.findNodes(isFragmentNode);
                    if (fragmentNodes.isEmpty()) {
                        return Collections.emptyMap();
                    }
                    HashMap<String, Template.Fragment> fragments = new HashMap<String, Template.Fragment>();
                    for (TemplateNode fragmentNode : fragmentNodes) {
                        FragmentSectionHelper helper = (FragmentSectionHelper)((SectionNode)fragmentNode).helper;
                        FragmentImpl fragment = new FragmentImpl(TemplateImpl.this.engine, (SectionNode)fragmentNode, helper.getIdentifier(), TemplateImpl.this.engine.generateId(), TemplateImpl.this.variant);
                        fragments.put(helper.getIdentifier(), fragment);
                    }
                    return fragments;
                }
            });
        }
        return null;
    }

    static class DataNamespaceResolver
    implements NamespaceResolver {
        static final String ROOT_CONTEXT = "qute$rootContext";

        DataNamespaceResolver() {
        }

        @Override
        public CompletionStage<Object> resolve(EvalContext context) {
            Object rootContext = context.getAttribute(ROOT_CONTEXT);
            if (rootContext != null && rootContext instanceof ResolutionContext) {
                return ((ResolutionContext)rootContext).evaluate(context.getName());
            }
            return Results.notFound(context);
        }

        @Override
        public String getNamespace() {
            return "data";
        }
    }

    class FragmentImpl
    extends TemplateImpl
    implements Template.Fragment {
        public FragmentImpl(EngineImpl engine, SectionNode root, String fragmentId, String generatedId, Optional<Variant> variant) {
            super(engine, root, fragmentId, generatedId, variant);
        }

        @Override
        public Template.Fragment getFragment(String id) {
            return TemplateImpl.this.getFragment(id);
        }

        @Override
        public Template getOriginalTemplate() {
            return TemplateImpl.this;
        }

        @Override
        public TemplateInstance instance() {
            TemplateInstance instance = super.instance();
            instance.setAttribute("qute$fragment", true);
            return instance;
        }
    }

    private class TemplateInstanceImpl
    extends TemplateInstanceBase {
        private TemplateInstanceImpl() {
        }

        @Override
        public String render() {
            long timeout = this.getTimeout();
            try {
                return this.renderAsyncNoTimeout().toCompletableFuture().get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
            catch (TimeoutException e) {
                throw this.newTimeoutException(timeout);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new IllegalStateException(e.getCause());
            }
        }

        @Override
        public Multi<String> createMulti() {
            Multi multi = Multi.createFrom().emitter(emitter -> this.renderData(this.data(), arg_0 -> ((MultiEmitter)emitter).emit(arg_0)).whenComplete((r, f) -> {
                if (f == null) {
                    emitter.complete();
                } else {
                    emitter.fail(f);
                }
            }));
            if (TemplateImpl.this.engine.useAsyncTimeout()) {
                long timeout = this.getTimeout();
                multi = multi.ifNoItem().after(Duration.ofMillis(timeout)).failWith(() -> this.newTimeoutException(timeout));
            }
            return multi;
        }

        @Override
        public Uni<String> createUni() {
            Uni uni = Uni.createFrom().completionStage(this::renderAsyncNoTimeout);
            if (TemplateImpl.this.engine.useAsyncTimeout()) {
                long timeout = this.getTimeout();
                uni = uni.ifNoItem().after(Duration.ofMillis(timeout)).failWith(() -> this.newTimeoutException(timeout));
            }
            return uni;
        }

        @Override
        public CompletionStage<String> renderAsync() {
            CompletionStage<String> cs = this.renderAsyncNoTimeout();
            if (TemplateImpl.this.engine.useAsyncTimeout()) {
                cs = cs.toCompletableFuture().orTimeout(this.getTimeout(), TimeUnit.MILLISECONDS);
            }
            return cs;
        }

        @Override
        public CompletionStage<Void> consume(Consumer<String> resultConsumer) {
            CompletionStage<Void> cs = this.renderData(this.data(), resultConsumer);
            if (TemplateImpl.this.engine.useAsyncTimeout()) {
                cs = cs.toCompletableFuture().orTimeout(this.getTimeout(), TimeUnit.MILLISECONDS);
            }
            return cs;
        }

        private TemplateException newTimeoutException(long timeout) {
            return new TemplateException(TemplateImpl.this.toString() + " rendering timeout [" + timeout + "ms] occured");
        }

        @Override
        protected Engine engine() {
            return TemplateImpl.this.engine;
        }

        private CompletionStage<String> renderAsyncNoTimeout() {
            StringBuilder builder = new StringBuilder(1028);
            return this.renderData(this.data(), builder::append).thenApply(v -> builder.toString());
        }

        private CompletionStage<Void> renderData(Object data, Consumer<String> consumer) {
            CompletableFuture<Void> result = new CompletableFuture<Void>();
            ResolutionContextImpl rootContext = new ResolutionContextImpl(data, TemplateImpl.this.engine.getEvaluator(), null, this::getAttribute);
            this.setAttribute("qute$rootContext", rootContext);
            TemplateImpl.this.root.resolve(rootContext).whenComplete((r, t) -> {
                if (t != null) {
                    result.completeExceptionally((Throwable)t);
                } else {
                    try {
                        r.process(consumer);
                        result.complete(null);
                    }
                    catch (Throwable e) {
                        result.completeExceptionally(e);
                    }
                    finally {
                        if (this.renderedActions != null) {
                            for (Runnable action : this.renderedActions) {
                                try {
                                    action.run();
                                }
                                catch (Throwable e) {
                                    LOG.error((Object)"Unable to perform an action when rendering finished", e);
                                }
                            }
                        }
                    }
                }
            });
            return result;
        }

        @Override
        public Template getTemplate() {
            return TemplateImpl.this;
        }

        public String toString() {
            return "Instance of " + TemplateImpl.this.toString();
        }
    }
}

