/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive;

import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.subscription.ContextSupport;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.jboss.resteasy.reactive.common.util.CaseInsensitiveMap;
import org.jboss.resteasy.reactive.common.util.MultivaluedTreeMap;

public abstract class RestMulti<T>
extends AbstractMulti<T> {
    public abstract Integer getStatus();

    public abstract Map<String, List<String>> getHeaders();

    public static <T> SyncRestMulti.Builder<T> fromMultiData(Multi<T> multi) {
        return new SyncRestMulti.Builder<T>(multi);
    }

    public static <T, R> RestMulti<R> fromUniResponse(Uni<T> uni, Function<T, Multi<R>> dataExtractor) {
        return RestMulti.fromUniResponse(uni, dataExtractor, null, null);
    }

    public static <T, R> RestMulti<R> fromUniResponse(Uni<T> uni, Function<T, Multi<R>> dataExtractor, Function<T, Map<String, List<String>>> headersExtractor) {
        return RestMulti.fromUniResponse(uni, dataExtractor, headersExtractor, null);
    }

    public static <T, R> RestMulti<R> fromUniResponse(Uni<T> uni, Function<T, Multi<R>> dataExtractor, Function<T, Map<String, List<String>>> headersExtractor, Function<T, Integer> statusExtractor) {
        Function actualDataExtractor = Infrastructure.decorate((Function)((Function)ParameterValidation.nonNull(dataExtractor, (String)"dataExtractor")));
        return (RestMulti)Infrastructure.onMultiCreation(new AsyncRestMulti(uni, actualDataExtractor, headersExtractor, statusExtractor));
    }

    public static class AsyncRestMulti<I, O>
    extends RestMulti<O> {
        private final Function<? super I, ? extends Multi<? extends O>> dataExtractor;
        private final Function<I, Integer> statusExtractor;
        private final Function<I, Map<String, List<String>>> headersExtractor;
        private final AtomicReference<Integer> status;
        private final AtomicReference<Map<String, List<String>>> headers;
        private final Uni<I> upstream;

        public <T> AsyncRestMulti(Uni<I> upstream, Function<? super I, ? extends Multi<? extends O>> dataExtractor, Function<I, Map<String, List<String>>> headersExtractor, Function<I, Integer> statusExtractor) {
            this.upstream = upstream;
            this.dataExtractor = dataExtractor;
            this.statusExtractor = statusExtractor;
            this.headersExtractor = headersExtractor;
            this.status = new AtomicReference<Object>(null);
            this.headers = new AtomicReference(Collections.emptyMap());
        }

        public void subscribe(MultiSubscriber<? super O> subscriber) {
            if (subscriber == null) {
                throw new NullPointerException("The subscriber must not be `null`");
            }
            AbstractUni.subscribe(this.upstream, new FlatMapPublisherSubscriber<I, O>(subscriber, this.dataExtractor, this.statusExtractor, this.status, this.headersExtractor, this.headers));
        }

        @Override
        public Integer getStatus() {
            return this.status.get();
        }

        @Override
        public Map<String, List<String>> getHeaders() {
            return this.headers.get();
        }

        static final class FlatMapPublisherSubscriber<I, O>
        implements Flow.Subscriber<O>,
        UniSubscriber<I>,
        Flow.Subscription,
        ContextSupport {
            private final AtomicReference<Flow.Subscription> secondUpstream;
            private final AtomicReference<UniSubscription> firstUpstream;
            private final Flow.Subscriber<? super O> downstream;
            private final Function<? super I, ? extends Multi<? extends O>> dataExtractor;
            private final Function<I, Integer> statusExtractor;
            private final AtomicReference<Integer> status;
            private final Function<I, Map<String, List<String>>> headersExtractor;
            private final AtomicReference<Map<String, List<String>>> headers;
            private final AtomicLong requested = new AtomicLong();

            public FlatMapPublisherSubscriber(Flow.Subscriber<? super O> downstream, Function<? super I, ? extends Multi<? extends O>> dataExtractor, Function<I, Integer> statusExtractor, AtomicReference<Integer> status, Function<I, Map<String, List<String>>> headersExtractor, AtomicReference<Map<String, List<String>>> headers) {
                this.downstream = downstream;
                this.dataExtractor = dataExtractor;
                this.statusExtractor = statusExtractor;
                this.status = status;
                this.headersExtractor = headersExtractor;
                this.headers = headers;
                this.firstUpstream = new AtomicReference();
                this.secondUpstream = new AtomicReference();
            }

            @Override
            public void onNext(O item) {
                this.downstream.onNext(item);
            }

            @Override
            public void onError(Throwable failure) {
                this.downstream.onError(failure);
            }

            @Override
            public void onComplete() {
                this.downstream.onComplete();
            }

            @Override
            public void request(long n) {
                Subscriptions.requestIfNotNullOrAccumulate(this.secondUpstream, (AtomicLong)this.requested, (long)n);
            }

            @Override
            public void cancel() {
                UniSubscription subscription = this.firstUpstream.getAndSet(EmptyUniSubscription.CANCELLED);
                if (subscription != null && subscription != EmptyUniSubscription.CANCELLED) {
                    subscription.cancel();
                }
                Subscriptions.cancel(this.secondUpstream);
            }

            public Context context() {
                if (this.downstream instanceof ContextSupport) {
                    return ((ContextSupport)this.downstream).context();
                }
                return Context.empty();
            }

            public void onSubscribe(UniSubscription subscription) {
                if (this.firstUpstream.compareAndSet(null, subscription)) {
                    this.downstream.onSubscribe(this);
                }
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                long r;
                if (this.secondUpstream.compareAndSet(null, subscription) && (r = this.requested.getAndSet(0L)) != 0L) {
                    subscription.request(r);
                }
            }

            public void onItem(I item) {
                Multi<? extends O> publisher;
                try {
                    publisher = this.dataExtractor.apply(item);
                    if (publisher == null) {
                        throw new NullPointerException("The mapper returned `null`");
                    }
                    if (this.headersExtractor != null) {
                        this.headers.set(this.headersExtractor.apply(item));
                    }
                    if (this.statusExtractor != null) {
                        this.status.set(this.statusExtractor.apply(item));
                    }
                }
                catch (Throwable ex) {
                    this.downstream.onError(ex);
                    return;
                }
                publisher.subscribe((Flow.Subscriber)this);
            }

            public void onFailure(Throwable failure) {
                this.downstream.onError(failure);
            }
        }
    }

    public static class SyncRestMulti<T>
    extends RestMulti<T> {
        private final Multi<T> multi;
        private final Integer status;
        private final MultivaluedTreeMap<String, String> headers;

        public void subscribe(MultiSubscriber<? super T> subscriber) {
            this.multi.subscribe(Infrastructure.onMultiSubscription(this.multi, subscriber));
        }

        private SyncRestMulti(Builder<T> builder) {
            this.multi = builder.multi;
            this.status = builder.status;
            this.headers = builder.headers;
        }

        @Override
        public Integer getStatus() {
            return this.status;
        }

        @Override
        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        public static class Builder<T> {
            private final Multi<T> multi;
            private Integer status;
            private final MultivaluedTreeMap<String, String> headers = new CaseInsensitiveMap<String>();

            private Builder(Multi<T> multi) {
                this.multi = Objects.requireNonNull(multi, "multi cannot be null");
            }

            public Builder<T> status(int status) {
                this.status = status;
                return this;
            }

            public Builder<T> header(String name, String value) {
                if (value == null) {
                    this.headers.remove(name);
                    return this;
                }
                this.headers.add(name, value);
                return this;
            }

            public RestMulti<T> build() {
                return new SyncRestMulti(this);
            }
        }
    }
}

