/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContextConfig;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenLocalRepositoryManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;

public class MavenArtifactResolver {
    protected final RepositorySystem repoSystem;
    protected final RepositorySystemSession repoSession;
    protected final List<RemoteRepository> remoteRepos;
    protected final MavenLocalRepositoryManager localRepoManager;
    protected final RemoteRepositoryManager remoteRepoManager;

    public static Builder builder() {
        return new Builder();
    }

    private MavenArtifactResolver(Builder builder) throws BootstrapMavenException {
        BootstrapMavenContext mvnSettings = new BootstrapMavenContext(builder);
        this.repoSystem = mvnSettings.getRepositorySystem();
        RepositorySystemSession session = mvnSettings.getRepositorySystemSession();
        if (builder.localRepo != null && builder.reTryFailedResolutionsAgainstDefaultLocalRepo) {
            this.localRepoManager = new MavenLocalRepositoryManager(this.repoSystem.newLocalRepositoryManager(session, new LocalRepository(builder.localRepo)), Paths.get(mvnSettings.getLocalRepo(), new String[0]));
            this.repoSession = new DefaultRepositorySystemSession(session).setLocalRepositoryManager((LocalRepositoryManager)this.localRepoManager);
        } else {
            this.repoSession = session;
            this.localRepoManager = null;
        }
        this.remoteRepos = mvnSettings.getRemoteRepositories();
        this.remoteRepoManager = mvnSettings.getRemoteRepositoryManager();
    }

    public MavenArtifactResolver(BootstrapMavenContext mvnSettings) throws BootstrapMavenException {
        this.repoSystem = mvnSettings.getRepositorySystem();
        this.repoSession = mvnSettings.getRepositorySystemSession();
        this.localRepoManager = null;
        this.remoteRepos = mvnSettings.getRemoteRepositories();
        this.remoteRepoManager = mvnSettings.getRemoteRepositoryManager();
    }

    public RemoteRepositoryManager getRemoteRepositoryManager() {
        return this.remoteRepoManager;
    }

    public MavenLocalRepositoryManager getLocalRepositoryManager() {
        return this.localRepoManager;
    }

    public RepositorySystem getSystem() {
        return this.repoSystem;
    }

    public RepositorySystemSession getSession() {
        return this.repoSession;
    }

    public List<RemoteRepository> getRepositories() {
        return this.remoteRepos;
    }

    public void addRemoteRepositories(List<RemoteRepository> repos) {
        this.remoteRepos.addAll(repos);
    }

    public ArtifactResult resolve(Artifact artifact) throws BootstrapMavenException {
        return this.resolveInternal(artifact, this.remoteRepos);
    }

    public ArtifactResult resolve(Artifact artifact, List<RemoteRepository> mainRepos) throws BootstrapMavenException {
        return this.resolveInternal(artifact, this.aggregateRepositories(mainRepos, this.remoteRepos));
    }

    private ArtifactResult resolveInternal(Artifact artifact, List<RemoteRepository> aggregatedRepos) throws BootstrapMavenException {
        try {
            return this.repoSystem.resolveArtifact(this.repoSession, new ArtifactRequest().setArtifact(artifact).setRepositories(aggregatedRepos));
        }
        catch (ArtifactResolutionException e) {
            throw new BootstrapMavenException("Failed to resolve artifact " + artifact, e);
        }
    }

    public List<ArtifactResult> resolve(List<ArtifactRequest> artifacts) throws BootstrapMavenException {
        try {
            return this.repoSystem.resolveArtifacts(this.repoSession, artifacts);
        }
        catch (ArtifactResolutionException e) {
            throw new BootstrapMavenException("Failed to resolve artifacts", e);
        }
    }

    public ArtifactDescriptorResult resolveDescriptor(Artifact artifact) throws BootstrapMavenException {
        return this.resolveDescriptorInternal(artifact, this.remoteRepos);
    }

    public ArtifactDescriptorResult resolveDescriptor(Artifact artifact, List<RemoteRepository> mainRepos) throws BootstrapMavenException {
        return this.resolveDescriptorInternal(artifact, this.aggregateRepositories(mainRepos, this.remoteRepos));
    }

    private ArtifactDescriptorResult resolveDescriptorInternal(Artifact artifact, List<RemoteRepository> aggregatedRepos) throws BootstrapMavenException {
        try {
            return this.repoSystem.readArtifactDescriptor(this.repoSession, new ArtifactDescriptorRequest().setArtifact(artifact).setRepositories(aggregatedRepos));
        }
        catch (ArtifactDescriptorException e) {
            throw new BootstrapMavenException("Failed to read descriptor of " + artifact, e);
        }
    }

    public VersionRangeResult resolveVersionRange(Artifact artifact) throws BootstrapMavenException {
        try {
            return this.repoSystem.resolveVersionRange(this.repoSession, new VersionRangeRequest().setArtifact(artifact).setRepositories(this.remoteRepos));
        }
        catch (VersionRangeResolutionException ex) {
            throw new BootstrapMavenException("Failed to resolve version range for " + artifact, ex);
        }
    }

    public CollectResult collectDependencies(Artifact artifact, List<Dependency> deps) throws BootstrapMavenException {
        return this.collectDependencies(artifact, deps, Collections.emptyList());
    }

    public CollectResult collectDependencies(Artifact artifact, List<Dependency> deps, List<RemoteRepository> mainRepos) throws BootstrapMavenException {
        CollectRequest request = this.newCollectRequest(artifact, mainRepos);
        request.setDependencies(deps);
        try {
            return this.repoSystem.collectDependencies(this.repoSession, request);
        }
        catch (DependencyCollectionException e) {
            throw new BootstrapMavenException("Failed to collect dependencies for " + artifact, e);
        }
    }

    public DependencyResult resolveDependencies(Artifact artifact, List<Dependency> deps) throws BootstrapMavenException {
        return this.resolveDependencies(artifact, deps, Collections.emptyList());
    }

    public DependencyResult resolveDependencies(Artifact artifact, List<Dependency> deps, List<RemoteRepository> mainRepos) throws BootstrapMavenException {
        CollectRequest request = this.newCollectRequest(artifact, mainRepos);
        request.setDependencies(deps);
        try {
            return this.repoSystem.resolveDependencies(this.repoSession, new DependencyRequest().setCollectRequest(request));
        }
        catch (DependencyResolutionException e) {
            throw new BootstrapMavenException("Failed to resolve dependencies for " + artifact, e);
        }
    }

    public DependencyResult resolveManagedDependencies(Artifact artifact, List<Dependency> deps, List<Dependency> managedDeps, List<RemoteRepository> mainRepos, String ... excludedScopes) throws BootstrapMavenException {
        try {
            return this.repoSystem.resolveDependencies(this.repoSession, new DependencyRequest().setCollectRequest(this.newCollectManagedRequest(artifact, deps, managedDeps, mainRepos, excludedScopes)));
        }
        catch (DependencyResolutionException e) {
            throw new BootstrapMavenException("Failed to resolve dependencies for " + artifact, e);
        }
    }

    public DependencyResult toDependencyTree(List<Dependency> deps, List<RemoteRepository> mainRepos) throws BootstrapMavenException {
        DependencyResult result = new DependencyResult(new DependencyRequest().setCollectRequest(new CollectRequest(deps, Collections.emptyList(), mainRepos)));
        DefaultDependencyNode root = new DefaultDependencyNode((Dependency)null);
        result.setRoot((DependencyNode)root);
        GenericVersionScheme vs = new GenericVersionScheme();
        for (Dependency i : deps) {
            DefaultDependencyNode node = new DefaultDependencyNode(i);
            try {
                node.setVersionConstraint(vs.parseVersionConstraint(i.getArtifact().getVersion()));
                node.setVersion(vs.parseVersion(i.getArtifact().getVersion()));
            }
            catch (InvalidVersionSpecificationException e) {
                throw new RuntimeException(e);
            }
            root.getChildren().add(node);
        }
        return result;
    }

    public CollectResult collectManagedDependencies(Artifact artifact, List<Dependency> deps, List<Dependency> managedDeps, List<RemoteRepository> mainRepos, String ... excludedScopes) throws BootstrapMavenException {
        try {
            return this.repoSystem.collectDependencies(this.repoSession, this.newCollectManagedRequest(artifact, deps, managedDeps, mainRepos, excludedScopes));
        }
        catch (DependencyCollectionException e) {
            throw new BootstrapMavenException("Failed to collect dependencies for " + artifact, e);
        }
    }

    private CollectRequest newCollectManagedRequest(Artifact artifact, List<Dependency> deps, List<Dependency> managedDeps, List<RemoteRepository> mainRepos, String ... excludedScopes) throws BootstrapMavenException {
        Collection<Object> excluded;
        List<RemoteRepository> aggregatedRepos = this.aggregateRepositories(mainRepos, this.remoteRepos);
        ArtifactDescriptorResult descr = this.resolveDescriptorInternal(artifact, aggregatedRepos);
        if (excludedScopes.length == 0) {
            excluded = Collections.emptyList();
        } else if (excludedScopes.length == 1) {
            excluded = Collections.singleton(excludedScopes[0]);
        } else {
            excluded = Arrays.asList(excludedScopes);
            if (excludedScopes.length > 3) {
                excluded = new HashSet<String>(Arrays.asList(excludedScopes));
            }
        }
        ArrayList<Dependency> originalDeps = new ArrayList<Dependency>(descr.getDependencies().size());
        for (Dependency dep : descr.getDependencies()) {
            if (excluded.contains(dep.getScope())) continue;
            originalDeps.add(dep);
        }
        ArrayList<Dependency> mergedManagedDeps = new ArrayList<Dependency>(managedDeps.size() + descr.getManagedDependencies().size());
        Map<AppArtifactKey, String> managedVersions = Collections.emptyMap();
        if (!managedDeps.isEmpty()) {
            managedVersions = new HashMap(managedDeps.size());
            for (Dependency dep : managedDeps) {
                managedVersions.put(MavenArtifactResolver.getId(dep.getArtifact()), dep.getArtifact().getVersion());
                mergedManagedDeps.add(dep);
            }
        }
        if (!descr.getManagedDependencies().isEmpty()) {
            for (Dependency dep : descr.getManagedDependencies()) {
                AppArtifactKey key = MavenArtifactResolver.getId(dep.getArtifact());
                if (managedVersions.containsKey(key)) continue;
                mergedManagedDeps.add(dep);
            }
        }
        return new CollectRequest().setRootArtifact(artifact).setDependencies(this.mergeDeps(deps, originalDeps, managedVersions)).setManagedDependencies(mergedManagedDeps).setRepositories(this.aggregateRepositories(aggregatedRepos, this.newResolutionRepositories(descr.getRepositories())));
    }

    public List<RemoteRepository> newResolutionRepositories(List<RemoteRepository> repos) {
        return repos.isEmpty() ? Collections.emptyList() : this.repoSystem.newResolutionRepositories(this.repoSession, repos);
    }

    public List<RemoteRepository> aggregateRepositories(List<RemoteRepository> dominant, List<RemoteRepository> recessive) {
        return dominant.isEmpty() ? recessive : this.remoteRepoManager.aggregateRepositories(this.repoSession, dominant, recessive, false);
    }

    public void install(Artifact artifact) throws BootstrapMavenException {
        try {
            this.repoSystem.install(this.repoSession, new InstallRequest().addArtifact(artifact));
        }
        catch (InstallationException ex) {
            throw new BootstrapMavenException("Failed to install " + artifact, ex);
        }
    }

    private CollectRequest newCollectRequest(Artifact artifact, List<RemoteRepository> mainRepos) throws BootstrapMavenException {
        return new CollectRequest().setRoot(new Dependency(artifact, "runtime")).setRepositories(this.aggregateRepositories(mainRepos, this.remoteRepos));
    }

    private List<Dependency> mergeDeps(List<Dependency> dominant, List<Dependency> recessive, Map<AppArtifactKey, String> managedVersions) {
        String managedVersion;
        AppArtifactKey id;
        int initialCapacity = dominant.size() + recessive.size();
        if (initialCapacity == 0) {
            return Collections.emptyList();
        }
        ArrayList<Dependency> result = new ArrayList<Dependency>(initialCapacity);
        HashSet<AppArtifactKey> ids = new HashSet<AppArtifactKey>(initialCapacity, 1.0f);
        for (Dependency dependency : dominant) {
            id = MavenArtifactResolver.getId(dependency.getArtifact());
            ids.add(id);
            managedVersion = managedVersions.get(id);
            if (managedVersion != null) {
                dependency = dependency.setArtifact(dependency.getArtifact().setVersion(managedVersion));
            }
            result.add(dependency);
        }
        for (Dependency dependency : recessive) {
            id = MavenArtifactResolver.getId(dependency.getArtifact());
            if (ids.contains(id)) continue;
            managedVersion = managedVersions.get(id);
            if (managedVersion != null) {
                dependency = dependency.setArtifact(dependency.getArtifact().setVersion(managedVersion));
            }
            result.add(dependency);
        }
        return result;
    }

    private static AppArtifactKey getId(Artifact a) {
        return new AppArtifactKey(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getExtension());
    }

    public static class Builder
    extends BootstrapMavenContextConfig<Builder> {
        private boolean reTryFailedResolutionsAgainstDefaultLocalRepo;

        private Builder() {
        }

        public Builder setReTryFailedResolutionsAgainstDefaultLocalRepo(boolean value) {
            this.reTryFailedResolutionsAgainstDefaultLocalRepo = value;
            return this;
        }

        public Builder setRepoHome(Path home) {
            if (home != null) {
                this.setLocalRepository(home.toString());
            }
            return this;
        }

        public MavenArtifactResolver build() throws BootstrapMavenException {
            return new MavenArtifactResolver(this);
        }
    }
}

