/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

import io.quarkus.deployment.AccessorFinder;
import io.quarkus.deployment.configuration.BuildTimeConfigurationReader;
import io.quarkus.deployment.configuration.definition.ClassDefinition;
import io.quarkus.deployment.configuration.definition.GroupDefinition;
import io.quarkus.deployment.configuration.definition.RootDefinition;
import io.quarkus.deployment.configuration.matching.ConfigPatternMap;
import io.quarkus.deployment.configuration.matching.Container;
import io.quarkus.deployment.configuration.matching.FieldContainer;
import io.quarkus.deployment.configuration.matching.MapContainer;
import io.quarkus.deployment.configuration.type.ArrayOf;
import io.quarkus.deployment.configuration.type.CollectionOf;
import io.quarkus.deployment.configuration.type.ConverterType;
import io.quarkus.deployment.configuration.type.Leaf;
import io.quarkus.deployment.configuration.type.LowerBoundCheckOf;
import io.quarkus.deployment.configuration.type.MinMaxValidated;
import io.quarkus.deployment.configuration.type.OptionalOf;
import io.quarkus.deployment.configuration.type.PatternValidated;
import io.quarkus.deployment.configuration.type.UpperBoundCheckOf;
import io.quarkus.deployment.util.ReflectUtil;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.configuration.AbstractRawDefaultConfigSource;
import io.quarkus.runtime.configuration.ConfigDiagnostic;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.runtime.configuration.HyphenateEnumConverter;
import io.quarkus.runtime.configuration.NameIterator;
import io.quarkus.runtime.configuration.ProfileManager;
import io.quarkus.runtime.configuration.QuarkusConfigFactory;
import io.smallrye.config.Converters;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.eclipse.microprofile.config.spi.Converter;
import org.wildfly.common.Assert;

public final class RunTimeConfigurationGenerator {
    public static final String CONFIG_CLASS_NAME = "io.quarkus.runtime.generated.Config";
    static final String BSDVCS_CLASS_NAME = "io.quarkus.runtime.generated.BootstrapDefaultValuesConfigSource";
    static final String RTDVCS_CLASS_NAME = "io.quarkus.runtime.generated.RunTimeDefaultValuesConfigSource";
    static final String BTRTDVCS_CLASS_NAME = "io.quarkus.runtime.generated.BuildTimeRunTimeDefaultValuesConfigSource";
    static final MethodDescriptor BTRTDVCS_NEW = MethodDescriptor.ofConstructor((String)"io.quarkus.runtime.generated.BuildTimeRunTimeDefaultValuesConfigSource", (String[])new String[0]);
    public static final FieldDescriptor C_INSTANCE = FieldDescriptor.of((String)"io.quarkus.runtime.generated.Config", (String)"INSTANCE", (String)"io.quarkus.runtime.generated.Config");
    static final FieldDescriptor C_BUILD_TIME_CONFIG_SOURCE = FieldDescriptor.of((String)"io.quarkus.runtime.generated.Config", (String)"buildTimeConfigSource", ConfigSource.class);
    static final FieldDescriptor C_BUILD_TIME_RUN_TIME_DEFAULTS_CONFIG_SOURCE = FieldDescriptor.of((String)"io.quarkus.runtime.generated.Config", (String)"buildTimeRunTimeDefaultsConfigSource", ConfigSource.class);
    public static final MethodDescriptor C_CREATE_BOOTSTRAP_CONFIG = MethodDescriptor.ofMethod((String)"io.quarkus.runtime.generated.Config", (String)"createBootstrapConfig", (String)"io.quarkus.runtime.generated.Config", (String[])new String[0]);
    public static final MethodDescriptor C_ENSURE_INITIALIZED = MethodDescriptor.ofMethod((Object)"io.quarkus.runtime.generated.Config", (String)"ensureInitialized", Void.TYPE, (Object[])new Object[0]);
    static final FieldDescriptor C_BOOTSTRAP_DEFAULTS_CONFIG_SOURCE = FieldDescriptor.of((String)"io.quarkus.runtime.generated.Config", (String)"bootstrapDefaultsConfigSource", ConfigSource.class);
    static final FieldDescriptor C_RUN_TIME_DEFAULTS_CONFIG_SOURCE = FieldDescriptor.of((String)"io.quarkus.runtime.generated.Config", (String)"runTimeDefaultsConfigSource", ConfigSource.class);
    static final MethodDescriptor C_BOOTSTRAP_CONFIG = MethodDescriptor.ofMethod((Object)"io.quarkus.runtime.generated.Config", (String)"readBootstrapConfig", Void.TYPE, (Object[])new Object[0]);
    public static final MethodDescriptor REINIT = MethodDescriptor.ofMethod((Object)"io.quarkus.runtime.generated.Config", (String)"reinit", Void.TYPE, (Object[])new Object[0]);
    public static final MethodDescriptor C_READ_CONFIG = MethodDescriptor.ofMethod((Object)"io.quarkus.runtime.generated.Config", (String)"readConfig", Void.TYPE, (Object[])new Object[]{List.class});
    static final FieldDescriptor C_SPECIFIED_RUN_TIME_CONFIG_SOURCE = FieldDescriptor.of((String)"io.quarkus.runtime.generated.Config", (String)"specifiedRunTimeConfigSource", ConfigSource.class);
    static final MethodDescriptor CD_INVALID_VALUE = MethodDescriptor.ofMethod(ConfigDiagnostic.class, (String)"invalidValue", Void.TYPE, (Class[])new Class[]{String.class, IllegalArgumentException.class});
    static final MethodDescriptor CD_IS_ERROR = MethodDescriptor.ofMethod(ConfigDiagnostic.class, (String)"isError", Boolean.TYPE, (Class[])new Class[0]);
    static final MethodDescriptor CD_MISSING_VALUE = MethodDescriptor.ofMethod(ConfigDiagnostic.class, (String)"missingValue", Void.TYPE, (Class[])new Class[]{String.class, NoSuchElementException.class});
    static final MethodDescriptor CD_RESET_ERROR = MethodDescriptor.ofMethod(ConfigDiagnostic.class, (String)"resetError", Void.TYPE, (Class[])new Class[0]);
    static final MethodDescriptor CD_UNKNOWN = MethodDescriptor.ofMethod(ConfigDiagnostic.class, (String)"unknown", Void.TYPE, (Class[])new Class[]{NameIterator.class});
    static final MethodDescriptor CD_UNKNOWN_RT = MethodDescriptor.ofMethod(ConfigDiagnostic.class, (String)"unknownRunTime", Void.TYPE, (Class[])new Class[]{NameIterator.class});
    static final MethodDescriptor CONVS_NEW_ARRAY_CONVERTER = MethodDescriptor.ofMethod(Converters.class, (String)"newArrayConverter", Converter.class, (Class[])new Class[]{Converter.class, Class.class});
    static final MethodDescriptor CONVS_NEW_COLLECTION_CONVERTER = MethodDescriptor.ofMethod(Converters.class, (String)"newCollectionConverter", Converter.class, (Class[])new Class[]{Converter.class, IntFunction.class});
    static final MethodDescriptor CONVS_NEW_OPTIONAL_CONVERTER = MethodDescriptor.ofMethod(Converters.class, (String)"newOptionalConverter", Converter.class, (Class[])new Class[]{Converter.class});
    static final MethodDescriptor CONVS_RANGE_VALUE_STRING_CONVERTER = MethodDescriptor.ofMethod(Converters.class, (String)"rangeValueStringConverter", Converter.class, (Class[])new Class[]{Converter.class, String.class, Boolean.TYPE, String.class, Boolean.TYPE});
    static final MethodDescriptor CONVS_MINIMUM_VALUE_STRING_CONVERTER = MethodDescriptor.ofMethod(Converters.class, (String)"minimumValueStringConverter", Converter.class, (Class[])new Class[]{Converter.class, String.class, Boolean.TYPE});
    static final MethodDescriptor CONVS_MAXIMUM_VALUE_STRING_CONVERTER = MethodDescriptor.ofMethod(Converters.class, (String)"maximumValueStringConverter", Converter.class, (Class[])new Class[]{Converter.class, String.class, Boolean.TYPE});
    static final MethodDescriptor CONVS_PATTERN_CONVERTER = MethodDescriptor.ofMethod(Converters.class, (String)"patternConverter", Converter.class, (Class[])new Class[]{Converter.class, Pattern.class});
    static final MethodDescriptor CPR_GET_CONFIG = MethodDescriptor.ofMethod(ConfigProviderResolver.class, (String)"getConfig", Config.class, (Class[])new Class[0]);
    static final MethodDescriptor CPR_INSTANCE = MethodDescriptor.ofMethod(ConfigProviderResolver.class, (String)"instance", ConfigProviderResolver.class, (Class[])new Class[0]);
    static final MethodDescriptor CPR_RELEASE_CONFIG = MethodDescriptor.ofMethod(ConfigProviderResolver.class, (String)"releaseConfig", Void.TYPE, (Class[])new Class[]{Config.class});
    static final MethodDescriptor CU_LIST_FACTORY = MethodDescriptor.ofMethod(ConfigUtils.class, (String)"listFactory", IntFunction.class, (Class[])new Class[0]);
    static final MethodDescriptor CU_SET_FACTORY = MethodDescriptor.ofMethod(ConfigUtils.class, (String)"setFactory", IntFunction.class, (Class[])new Class[0]);
    static final MethodDescriptor CU_SORTED_SET_FACTORY = MethodDescriptor.ofMethod(ConfigUtils.class, (String)"sortedSetFactory", IntFunction.class, (Class[])new Class[0]);
    static final MethodDescriptor CU_CONFIG_BUILDER = MethodDescriptor.ofMethod(ConfigUtils.class, (String)"configBuilder", SmallRyeConfigBuilder.class, (Class[])new Class[]{Boolean.TYPE});
    static final MethodDescriptor CU_CONFIG_BUILDER_WITH_ADD_DISCOVERED = MethodDescriptor.ofMethod(ConfigUtils.class, (String)"configBuilder", SmallRyeConfigBuilder.class, (Class[])new Class[]{Boolean.TYPE, Boolean.TYPE});
    static final MethodDescriptor CU_ADD_SOURCE_PROVIDER = MethodDescriptor.ofMethod(ConfigUtils.class, (String)"addSourceProvider", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, ConfigSourceProvider.class});
    static final MethodDescriptor CU_ADD_SOURCE_PROVIDERS = MethodDescriptor.ofMethod(ConfigUtils.class, (String)"addSourceProviders", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, Collection.class});
    static final MethodDescriptor HM_NEW = MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]);
    static final MethodDescriptor HM_PUT = MethodDescriptor.ofMethod(HashMap.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class});
    static final MethodDescriptor ITRA_ITERATOR = MethodDescriptor.ofMethod(Iterable.class, (String)"iterator", Iterator.class, (Class[])new Class[0]);
    static final MethodDescriptor ITR_HAS_NEXT = MethodDescriptor.ofMethod(Iterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]);
    static final MethodDescriptor ITR_NEXT = MethodDescriptor.ofMethod(Iterator.class, (String)"next", Object.class, (Class[])new Class[0]);
    static final MethodDescriptor MAP_GET = MethodDescriptor.ofMethod(Map.class, (String)"get", Object.class, (Class[])new Class[]{Object.class});
    static final MethodDescriptor MAP_PUT = MethodDescriptor.ofMethod(Map.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class});
    static final MethodDescriptor NI_GET_ALL_PREVIOUS_SEGMENTS = MethodDescriptor.ofMethod(NameIterator.class, (String)"getAllPreviousSegments", String.class, (Class[])new Class[0]);
    static final MethodDescriptor NI_GET_NAME = MethodDescriptor.ofMethod(NameIterator.class, (String)"getName", String.class, (Class[])new Class[0]);
    static final MethodDescriptor NI_GET_PREVIOUS_SEGMENT = MethodDescriptor.ofMethod(NameIterator.class, (String)"getPreviousSegment", String.class, (Class[])new Class[0]);
    static final MethodDescriptor NI_HAS_NEXT = MethodDescriptor.ofMethod(NameIterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]);
    static final MethodDescriptor NI_NEW_STRING = MethodDescriptor.ofConstructor(NameIterator.class, (Class[])new Class[]{String.class});
    static final MethodDescriptor NI_NEXT_EQUALS = MethodDescriptor.ofMethod(NameIterator.class, (String)"nextSegmentEquals", Boolean.TYPE, (Class[])new Class[]{String.class});
    static final MethodDescriptor NI_NEXT = MethodDescriptor.ofMethod(NameIterator.class, (String)"next", Void.TYPE, (Class[])new Class[0]);
    static final MethodDescriptor NI_PREVIOUS = MethodDescriptor.ofMethod(NameIterator.class, (String)"previous", Void.TYPE, (Class[])new Class[0]);
    static final MethodDescriptor NI_PREVIOUS_EQUALS = MethodDescriptor.ofMethod(NameIterator.class, (String)"previousSegmentEquals", Boolean.TYPE, (Class[])new Class[]{String.class});
    static final MethodDescriptor OBJ_TO_STRING = MethodDescriptor.ofMethod(Object.class, (String)"toString", String.class, (Class[])new Class[0]);
    static final MethodDescriptor OPT_EMPTY = MethodDescriptor.ofMethod(Optional.class, (String)"empty", Optional.class, (Class[])new Class[0]);
    static final MethodDescriptor OPT_GET = MethodDescriptor.ofMethod(Optional.class, (String)"get", Object.class, (Class[])new Class[0]);
    static final MethodDescriptor OPT_IS_PRESENT = MethodDescriptor.ofMethod(Optional.class, (String)"isPresent", Boolean.TYPE, (Class[])new Class[0]);
    static final MethodDescriptor OPT_OF = MethodDescriptor.ofMethod(Optional.class, (String)"of", Optional.class, (Class[])new Class[]{Object.class});
    static final MethodDescriptor PCS_NEW = MethodDescriptor.ofConstructor(PropertiesConfigSource.class, (Class[])new Class[]{Map.class, String.class, Integer.TYPE});
    static final MethodDescriptor PM_SET_RUNTIME_DEFAULT_PROFILE = MethodDescriptor.ofMethod(ProfileManager.class, (String)"setRuntimeDefaultProfile", Void.TYPE, (Class[])new Class[]{String.class});
    static final MethodDescriptor SB_NEW = MethodDescriptor.ofConstructor(StringBuilder.class, (Class[])new Class[0]);
    static final MethodDescriptor SB_NEW_STR = MethodDescriptor.ofConstructor(StringBuilder.class, (Class[])new Class[]{String.class});
    static final MethodDescriptor SB_APPEND_STRING = MethodDescriptor.ofMethod(StringBuilder.class, (String)"append", StringBuilder.class, (Class[])new Class[]{String.class});
    static final MethodDescriptor SB_APPEND_CHAR = MethodDescriptor.ofMethod(StringBuilder.class, (String)"append", StringBuilder.class, (Class[])new Class[]{Character.TYPE});
    static final MethodDescriptor SB_LENGTH = MethodDescriptor.ofMethod(StringBuilder.class, (String)"length", Integer.TYPE, (Class[])new Class[0]);
    static final MethodDescriptor SB_SET_LENGTH = MethodDescriptor.ofMethod(StringBuilder.class, (String)"setLength", Void.TYPE, (Class[])new Class[]{Integer.TYPE});
    static final MethodDescriptor QCF_SET_CONFIG = MethodDescriptor.ofMethod(QuarkusConfigFactory.class, (String)"setConfig", Void.TYPE, (Class[])new Class[]{SmallRyeConfig.class});
    static final MethodDescriptor BSDVCS_NEW = MethodDescriptor.ofConstructor((String)"io.quarkus.runtime.generated.BootstrapDefaultValuesConfigSource", (String[])new String[0]);
    static final MethodDescriptor RTDVCS_NEW = MethodDescriptor.ofConstructor((String)"io.quarkus.runtime.generated.RunTimeDefaultValuesConfigSource", (String[])new String[0]);
    static final MethodDescriptor SRC_GET_CONVERTER = MethodDescriptor.ofMethod(SmallRyeConfig.class, (String)"getConverter", Converter.class, (Class[])new Class[]{Class.class});
    static final MethodDescriptor SRC_GET_PROPERTY_NAMES = MethodDescriptor.ofMethod(SmallRyeConfig.class, (String)"getPropertyNames", Iterable.class, (Class[])new Class[0]);
    static final MethodDescriptor SRC_GET_VALUE = MethodDescriptor.ofMethod(SmallRyeConfig.class, (String)"getValue", Object.class, (Class[])new Class[]{String.class, Converter.class});
    static final MethodDescriptor SRCB_WITH_CONVERTER = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"withConverter", ConfigBuilder.class, (Class[])new Class[]{Class.class, Integer.TYPE, Converter.class});
    static final MethodDescriptor SRCB_WITH_SOURCES = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"withSources", ConfigBuilder.class, (Class[])new Class[]{ConfigSource[].class});
    static final MethodDescriptor SRCB_BUILD = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"build", SmallRyeConfig.class, (Class[])new Class[0]);
    static final MethodDescriptor TM_NEW = MethodDescriptor.ofConstructor(TreeMap.class, (Class[])new Class[0]);
    static final MethodDescriptor EMPTY_PARSER = MethodDescriptor.ofMethod((Object)"io.quarkus.runtime.generated.Config", (String)"emptyParseKey", Void.TYPE, (Object[])new Object[]{SmallRyeConfig.class, NameIterator.class});
    static final MethodDescriptor RT_EMPTY_PARSER = MethodDescriptor.ofMethod((Object)"io.quarkus.runtime.generated.Config", (String)"rtEmptyParseKey", Void.TYPE, (Object[])new Object[]{SmallRyeConfig.class, NameIterator.class});

    private RunTimeConfigurationGenerator() {
    }

    public static void generate(BuildTimeConfigurationReader.ReadResult readResult, ClassOutput classOutput, boolean devMode, Map<String, String> runTimeDefaults, List<Class<?>> additionalTypes, List<String> additionalBootstrapConfigSourceProviders) {
        new GenerateOperation.Builder().setBuildTimeReadResult(readResult).setClassOutput(classOutput).setDevMode(devMode).setRunTimeDefaults(runTimeDefaults).setAdditionalTypes(additionalTypes).setAdditionalBootstrapConfigSourceProviders(additionalBootstrapConfigSourceProviders).build().run();
    }

    private static boolean isFieldEligibleForDirectAccess(ClassDefinition.ClassMember classMember) {
        return Modifier.isPublic(classMember.getField().getModifiers()) && Modifier.isPublic(classMember.getEnclosingDefinition().getConfigurationClass().getModifiers()) && Modifier.isPublic(classMember.getField().getType().getModifiers());
    }

    private static enum Type {
        BUILD_TIME("si"),
        BOOTSTRAP("bs"),
        RUNTIME("rt");

        final String methodPrefix;

        private Type(String methodPrefix) {
            this.methodPrefix = methodPrefix;
        }
    }

    static final class GenerateOperation
    implements AutoCloseable {
        final boolean devMode;
        final AccessorFinder accessorFinder;
        final ClassOutput classOutput;
        final ClassCreator cc;
        final MethodCreator clinit;
        final MethodCreator reinit;
        final BytecodeCreator converterSetup;
        final MethodCreator readBootstrapConfig;
        final ResultHandle readBootstrapConfigNameBuilder;
        final MethodCreator readConfig;
        final ResultHandle readConfigNameBuilder;
        final ResultHandle clinitNameBuilder;
        final BuildTimeConfigurationReader.ReadResult buildTimeConfigResult;
        final List<RootDefinition> roots;
        final Map<String, String> specifiedRunTimeDefaultValues;
        final Map<String, String> buildTimeRunTimeVisibleValues;
        final Map<String, String> runTimeDefaults;
        final Map<Container, MethodDescriptor> enclosingMemberMethods = new HashMap<Container, MethodDescriptor>();
        final Map<Class<?>, MethodDescriptor> groupInitMethods = new HashMap();
        final Map<Class<?>, FieldDescriptor> configRootsByType = new HashMap();
        final ResultHandle clinitConfig;
        final Map<FieldDescriptor, Class<?>> convertersToRegister = new HashMap();
        final List<Class<?>> additionalTypes;
        final List<String> additionalBootstrapConfigSourceProviders;
        final Map<ConverterType, FieldDescriptor> convertersByType = new HashMap<ConverterType, FieldDescriptor>();
        final Map<FieldDescriptor, ResultHandle> instanceCache = new HashMap<FieldDescriptor, ResultHandle>();
        int converterIndex = 0;

        GenerateOperation(Builder builder) {
            this.devMode = builder.devMode;
            BuildTimeConfigurationReader.ReadResult buildTimeReadResult = builder.buildTimeReadResult;
            this.buildTimeConfigResult = (BuildTimeConfigurationReader.ReadResult)Assert.checkNotNullParam((String)"buildTimeReadResult", (Object)buildTimeReadResult);
            this.specifiedRunTimeDefaultValues = (Map)Assert.checkNotNullParam((String)"specifiedRunTimeDefaultValues", buildTimeReadResult.getSpecifiedRunTimeDefaultValues());
            this.buildTimeRunTimeVisibleValues = (Map)Assert.checkNotNullParam((String)"buildTimeRunTimeVisibleValues", buildTimeReadResult.getBuildTimeRunTimeVisibleValues());
            this.classOutput = (ClassOutput)Assert.checkNotNullParam((String)"classOutput", (Object)builder.getClassOutput());
            this.roots = (List)Assert.checkNotNullParam((String)"builder.roots", builder.getBuildTimeReadResult().getAllRoots());
            this.runTimeDefaults = (Map)Assert.checkNotNullParam((String)"runTimeDefaults", builder.getRunTimeDefaults());
            this.additionalTypes = (List)Assert.checkNotNullParam((String)"additionalTypes", builder.getAdditionalTypes());
            this.additionalBootstrapConfigSourceProviders = builder.additionalBootstrapConfigSourceProviders;
            this.cc = ClassCreator.builder().classOutput(this.classOutput).className(RunTimeConfigurationGenerator.CONFIG_CLASS_NAME).setFinal(true).build();
            this.generateEmptyParsers(this.cc);
            MethodCreator mc = this.cc.getMethodCreator(MethodDescriptor.ofConstructor((String)RunTimeConfigurationGenerator.CONFIG_CLASS_NAME, (String[])new String[0]));
            Object object = null;
            try {
                mc.setModifiers(2);
                mc.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), mc.getThis(), new ResultHandle[0]);
                mc.returnValue(null);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (mc != null) {
                    if (object != null) {
                        try {
                            mc.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        mc.close();
                    }
                }
            }
            if (this.devMode) {
                this.reinit = this.cc.getMethodCreator(REINIT);
                this.reinit.setModifiers(9);
            } else {
                this.reinit = null;
            }
            this.clinit = this.cc.getMethodCreator(MethodDescriptor.ofMethod((Object)RunTimeConfigurationGenerator.CONFIG_CLASS_NAME, (String)"<clinit>", Void.TYPE, (Object[])new Object[0]));
            this.clinit.setModifiers(8);
            this.clinit.invokeStaticMethod(PM_SET_RUNTIME_DEFAULT_PROFILE, new ResultHandle[]{this.clinit.load(ProfileManager.getActiveProfile())});
            this.clinitNameBuilder = this.clinit.newInstance(SB_NEW, new ResultHandle[0]);
            this.clinit.invokeVirtualMethod(SB_APPEND_STRING, this.clinitNameBuilder, new ResultHandle[]{this.clinit.load("quarkus")});
            ResultHandle buildTimeValues = this.clinit.newInstance(HM_NEW, new ResultHandle[0]);
            for (Map.Entry entry : this.buildTimeRunTimeVisibleValues.entrySet()) {
                this.clinit.invokeVirtualMethod(HM_PUT, buildTimeValues, new ResultHandle[]{this.clinit.load((String)entry.getKey()), this.clinit.load((String)entry.getValue())});
            }
            this.cc.getFieldCreator(C_INSTANCE).setModifiers(73);
            this.cc.getFieldCreator(C_BUILD_TIME_CONFIG_SOURCE).setModifiers(25);
            ResultHandle buildTimeConfigSource = this.clinit.newInstance(PCS_NEW, new ResultHandle[]{buildTimeValues, this.clinit.load("Build time config"), this.clinit.load(100)});
            this.clinit.writeStaticField(C_BUILD_TIME_CONFIG_SOURCE, buildTimeConfigSource);
            this.cc.getFieldCreator(C_BUILD_TIME_RUN_TIME_DEFAULTS_CONFIG_SOURCE).setModifiers(25);
            ResultHandle resultHandle = this.clinit.newInstance(BTRTDVCS_NEW, new ResultHandle[0]);
            this.clinit.writeStaticField(C_BUILD_TIME_RUN_TIME_DEFAULTS_CONFIG_SOURCE, resultHandle);
            if (!buildTimeReadResult.isBootstrapRootsEmpty()) {
                this.cc.getFieldCreator(C_BOOTSTRAP_DEFAULTS_CONFIG_SOURCE).setModifiers(25);
                this.clinit.writeStaticField(C_BOOTSTRAP_DEFAULTS_CONFIG_SOURCE, this.clinit.newInstance(BSDVCS_NEW, new ResultHandle[0]));
            }
            this.cc.getFieldCreator(C_RUN_TIME_DEFAULTS_CONFIG_SOURCE).setModifiers(25);
            this.clinit.writeStaticField(C_RUN_TIME_DEFAULTS_CONFIG_SOURCE, this.clinit.newInstance(RTDVCS_NEW, new ResultHandle[0]));
            ResultHandle buildTimeBuilder = this.clinit.invokeStaticMethod(CU_CONFIG_BUILDER, new ResultHandle[]{this.clinit.load(true)});
            ResultHandle array = this.clinit.newArray(ConfigSource[].class, 2);
            this.clinit.writeArrayValue(array, 0, buildTimeConfigSource);
            this.clinit.writeArrayValue(array, 1, resultHandle);
            this.clinit.invokeVirtualMethod(SRCB_WITH_SOURCES, buildTimeBuilder, new ResultHandle[]{array});
            this.clinitConfig = this.clinit.checkCast(this.clinit.invokeVirtualMethod(SRCB_BUILD, buildTimeBuilder, new ResultHandle[0]), SmallRyeConfig.class);
            this.converterSetup = this.clinit.createScope();
            this.readBootstrapConfig = this.cc.getMethodCreator(C_BOOTSTRAP_CONFIG);
            if (buildTimeReadResult.isBootstrapRootsEmpty()) {
                this.readBootstrapConfigNameBuilder = null;
            } else {
                this.readBootstrapConfigNameBuilder = this.readBootstrapConfig.newInstance(SB_NEW, new ResultHandle[0]);
                this.readBootstrapConfig.invokeVirtualMethod(SB_APPEND_STRING, this.readBootstrapConfigNameBuilder, new ResultHandle[]{this.readBootstrapConfig.load("quarkus")});
            }
            this.readConfig = this.cc.getMethodCreator(C_READ_CONFIG);
            this.readConfigNameBuilder = this.readConfig.newInstance(SB_NEW, new ResultHandle[0]);
            this.readConfig.invokeVirtualMethod(SB_APPEND_STRING, this.readConfigNameBuilder, new ResultHandle[]{this.readConfig.load("quarkus")});
            this.accessorFinder = new AccessorFinder();
        }

        private boolean bootstrapConfigSetupNeeded() {
            return this.readBootstrapConfigNameBuilder != null;
        }

        public void run() {
            this.installConfiguration(this.clinitConfig, this.clinit);
            if (this.devMode) {
                ResultHandle buildTimeRunTimeDefaultValuesConfigSource = this.reinit.readStaticField(C_BUILD_TIME_RUN_TIME_DEFAULTS_CONFIG_SOURCE);
                ResultHandle buildTimeValues = this.reinit.newInstance(HM_NEW, new ResultHandle[0]);
                for (Map.Entry<String, String> entry : this.buildTimeRunTimeVisibleValues.entrySet()) {
                    this.reinit.invokeVirtualMethod(HM_PUT, buildTimeValues, new ResultHandle[]{this.reinit.load(entry.getKey()), this.reinit.load(entry.getValue())});
                }
                ResultHandle buildTimeConfigSource = this.reinit.newInstance(PCS_NEW, new ResultHandle[]{buildTimeValues, this.reinit.load("Build time config = Reloaded"), this.reinit.load(100)});
                ResultHandle buildTimeBuilder = this.reinit.invokeStaticMethod(CU_CONFIG_BUILDER, new ResultHandle[]{this.reinit.load(true)});
                ResultHandle array = this.reinit.newArray(ConfigSource[].class, 2);
                this.reinit.writeArrayValue(array, 0, buildTimeConfigSource);
                this.reinit.writeArrayValue(array, 1, buildTimeRunTimeDefaultValuesConfigSource);
                this.reinit.invokeVirtualMethod(SRCB_WITH_SOURCES, buildTimeBuilder, new ResultHandle[]{array});
                ResultHandle clinitConfig = this.reinit.checkCast(this.reinit.invokeVirtualMethod(SRCB_BUILD, buildTimeBuilder, new ResultHandle[0]), SmallRyeConfig.class);
                this.installConfiguration(clinitConfig, this.reinit);
                this.reinit.returnValue(null);
            }
            for (RootDefinition root2 : this.roots) {
                this.configRootsByType.put(root2.getConfigurationClass(), root2.getDescriptor());
            }
            ConfigPatternMap<Container> buildTimePatternMap = this.buildTimeConfigResult.getBuildTimePatternMap();
            ConfigPatternMap<Container> buildTimeRunTimePatternMap = this.buildTimeConfigResult.getBuildTimeRunTimePatternMap();
            ConfigPatternMap<Container> bootstrapPatternMap = this.buildTimeConfigResult.getBootstrapPatternMap();
            ConfigPatternMap<Container> runTimePatternMap = this.buildTimeConfigResult.getRunTimePatternMap();
            BiFunction<Container, Container, Container> combinator = (a, b) -> a == null ? b : a;
            ConfigPatternMap<Container> buildTimeRunTimeIgnored = ConfigPatternMap.merge(ConfigPatternMap.merge(buildTimePatternMap, runTimePatternMap, combinator), bootstrapPatternMap, combinator);
            ConfigPatternMap<Container> runTimeIgnored = ConfigPatternMap.merge(ConfigPatternMap.merge(buildTimePatternMap, buildTimeRunTimePatternMap, combinator), bootstrapPatternMap, combinator);
            MethodDescriptor siParserBody = this.generateParserBody(buildTimeRunTimePatternMap, buildTimeRunTimeIgnored, new StringBuilder("siParseKey"), false, Type.BUILD_TIME);
            MethodDescriptor rtParserBody = this.generateParserBody(runTimePatternMap, runTimeIgnored, new StringBuilder("rtParseKey"), false, Type.RUNTIME);
            MethodDescriptor bsParserBody = null;
            if (this.bootstrapConfigSetupNeeded()) {
                bsParserBody = this.generateParserBody(bootstrapPatternMap, null, new StringBuilder("bsParseKey"), false, Type.BOOTSTRAP);
            }
            ResultHandle bootstrapBuilder = null;
            if (this.bootstrapConfigSetupNeeded()) {
                bootstrapBuilder = this.readBootstrapConfig.invokeStaticMethod(CU_CONFIG_BUILDER_WITH_ADD_DISCOVERED, new ResultHandle[]{this.readBootstrapConfig.load(false), this.readBootstrapConfig.load(false)});
            }
            ResultHandle runTimeBuilder = this.readConfig.invokeStaticMethod(CU_CONFIG_BUILDER, new ResultHandle[]{this.readConfig.load(true)});
            this.readConfig.invokeStaticMethod(CU_ADD_SOURCE_PROVIDER, new ResultHandle[]{runTimeBuilder, this.readConfig.newInstance(MethodDescriptor.ofConstructor((String)"io.quarkus.runtime.generated.ConfigSourceProviderImpl", (String[])new String[0]), new ResultHandle[0])});
            ResultHandle specifiedRunTimeValues = this.clinit.newInstance(HM_NEW, new ResultHandle[0]);
            if (!this.devMode) {
                for (Map.Entry<String, String> entry : this.specifiedRunTimeDefaultValues.entrySet()) {
                    this.clinit.invokeVirtualMethod(HM_PUT, specifiedRunTimeValues, new ResultHandle[]{this.clinit.load(entry.getKey()), this.clinit.load(entry.getValue())});
                }
            }
            for (Map.Entry<String, String> entry : this.runTimeDefaults.entrySet()) {
                if (this.specifiedRunTimeDefaultValues.containsKey(entry.getKey())) continue;
                this.clinit.invokeVirtualMethod(HM_PUT, specifiedRunTimeValues, new ResultHandle[]{this.clinit.load(entry.getKey()), this.clinit.load(entry.getValue())});
            }
            ResultHandle specifiedRunTimeSource = this.clinit.newInstance(PCS_NEW, new ResultHandle[]{specifiedRunTimeValues, this.clinit.load("Specified default values"), this.clinit.load(-2147483548)});
            this.cc.getFieldCreator(C_SPECIFIED_RUN_TIME_CONFIG_SOURCE).setModifiers(8 | (this.devMode ? 64 : 16));
            this.clinit.writeStaticField(C_SPECIFIED_RUN_TIME_CONFIG_SOURCE, specifiedRunTimeSource);
            ResultHandle bootstrapConfigSourcesArray = null;
            if (this.bootstrapConfigSetupNeeded()) {
                bootstrapConfigSourcesArray = this.readBootstrapConfig.newArray(ConfigSource[].class, 4);
                this.readBootstrapConfig.writeArrayValue(bootstrapConfigSourcesArray, 0, this.readBootstrapConfig.readStaticField(C_BUILD_TIME_CONFIG_SOURCE));
                this.readBootstrapConfig.writeArrayValue(bootstrapConfigSourcesArray, 1, this.readBootstrapConfig.readStaticField(C_SPECIFIED_RUN_TIME_CONFIG_SOURCE));
                this.readBootstrapConfig.writeArrayValue(bootstrapConfigSourcesArray, 2, this.readBootstrapConfig.readStaticField(C_BUILD_TIME_RUN_TIME_DEFAULTS_CONFIG_SOURCE));
                this.readBootstrapConfig.writeArrayValue(bootstrapConfigSourcesArray, 3, this.readBootstrapConfig.readStaticField(C_BOOTSTRAP_DEFAULTS_CONFIG_SOURCE));
            }
            ResultHandle runtimeConfigSourcesArray = this.readConfig.newArray(ConfigSource[].class, this.bootstrapConfigSetupNeeded() ? 5 : 4);
            this.readConfig.writeArrayValue(runtimeConfigSourcesArray, 0, this.readConfig.readStaticField(C_BUILD_TIME_CONFIG_SOURCE));
            this.readConfig.writeArrayValue(runtimeConfigSourcesArray, 1, this.readConfig.readStaticField(C_SPECIFIED_RUN_TIME_CONFIG_SOURCE));
            this.readConfig.writeArrayValue(runtimeConfigSourcesArray, 2, this.readConfig.readStaticField(C_RUN_TIME_DEFAULTS_CONFIG_SOURCE));
            this.readConfig.writeArrayValue(runtimeConfigSourcesArray, 3, this.readConfig.readStaticField(C_BUILD_TIME_RUN_TIME_DEFAULTS_CONFIG_SOURCE));
            if (this.bootstrapConfigSetupNeeded()) {
                this.readConfig.writeArrayValue(runtimeConfigSourcesArray, 4, this.readConfig.readStaticField(C_BOOTSTRAP_DEFAULTS_CONFIG_SOURCE));
            }
            for (Class<?> clazz : this.additionalTypes) {
                Leaf type = new Leaf(clazz, null);
                FieldDescriptor fd = this.convertersByType.get(type);
                if (fd != null) continue;
                ResultHandle clazzHandle = this.converterSetup.loadClass(clazz);
                fd = FieldDescriptor.of((String)this.cc.getClassName(), (String)("conv$" + this.converterIndex++), Converter.class);
                ResultHandle converter = this.converterSetup.invokeVirtualMethod(SRC_GET_CONVERTER, this.clinitConfig, new ResultHandle[]{clazzHandle});
                this.cc.getFieldCreator(fd).setModifiers(24);
                this.converterSetup.writeStaticField(fd, converter);
                this.convertersByType.put(type, fd);
                this.instanceCache.put(fd, converter);
                this.convertersToRegister.put(fd, clazz);
            }
            if (!this.convertersToRegister.isEmpty()) {
                for (Map.Entry entry : this.convertersToRegister.entrySet()) {
                    FieldDescriptor descriptor = (FieldDescriptor)entry.getKey();
                    Class type = (Class)entry.getValue();
                    if (this.bootstrapConfigSetupNeeded()) {
                        this.readBootstrapConfig.invokeVirtualMethod(SRCB_WITH_CONVERTER, bootstrapBuilder, new ResultHandle[]{this.readBootstrapConfig.loadClass(type), this.readBootstrapConfig.load(100), this.readBootstrapConfig.readStaticField(descriptor)});
                    }
                    this.readConfig.invokeVirtualMethod(SRCB_WITH_CONVERTER, runTimeBuilder, new ResultHandle[]{this.readConfig.loadClass(type), this.readConfig.load(100), this.readConfig.readStaticField(descriptor)});
                }
            }
            if (this.bootstrapConfigSetupNeeded()) {
                this.readBootstrapConfig.invokeVirtualMethod(SRCB_WITH_SOURCES, bootstrapBuilder, new ResultHandle[]{bootstrapConfigSourcesArray});
                for (String string : this.additionalBootstrapConfigSourceProviders) {
                    ResultHandle providerInstance = this.readBootstrapConfig.newInstance(MethodDescriptor.ofConstructor((String)string, (String[])new String[0]), new ResultHandle[0]);
                    this.readBootstrapConfig.invokeStaticMethod(CU_ADD_SOURCE_PROVIDER, new ResultHandle[]{bootstrapBuilder, providerInstance});
                }
            }
            this.readConfig.invokeVirtualMethod(SRCB_WITH_SOURCES, runTimeBuilder, new ResultHandle[]{runtimeConfigSourcesArray});
            this.readConfig.invokeStaticMethod(CU_ADD_SOURCE_PROVIDERS, new ResultHandle[]{runTimeBuilder, this.readConfig.getMethodParam(0)});
            ResultHandle bootstrapConfig = null;
            if (this.bootstrapConfigSetupNeeded()) {
                bootstrapConfig = this.readBootstrapConfig.invokeVirtualMethod(SRCB_BUILD, bootstrapBuilder, new ResultHandle[0]);
                this.installConfiguration(bootstrapConfig, this.readBootstrapConfig);
            }
            ResultHandle resultHandle = this.readConfig.invokeVirtualMethod(SRCB_BUILD, runTimeBuilder, new ResultHandle[0]);
            this.installConfiguration(resultHandle, this.readConfig);
            ResultHandle clInitOldLen = this.clinit.invokeVirtualMethod(SB_LENGTH, this.clinitNameBuilder, new ResultHandle[0]);
            ResultHandle bcOldLen = null;
            if (this.bootstrapConfigSetupNeeded()) {
                bcOldLen = this.readBootstrapConfig.invokeVirtualMethod(SB_LENGTH, this.readBootstrapConfigNameBuilder, new ResultHandle[0]);
            }
            ResultHandle rcOldLen = this.readConfig.invokeVirtualMethod(SB_LENGTH, this.readConfigNameBuilder, new ResultHandle[0]);
            for (RootDefinition rootDefinition : this.roots) {
                ResultHandle instance;
                Class<?> configurationClass = rootDefinition.getConfigurationClass();
                FieldDescriptor rootFieldDescriptor = rootDefinition.getDescriptor();
                MethodDescriptor initGroup = null;
                if (rootDefinition.getConfigPhase() != ConfigPhase.BUILD_TIME) {
                    initGroup = this.generateInitGroup(rootDefinition);
                }
                MethodDescriptor accessorCtor = null;
                if (!Modifier.isPublic(configurationClass.getModifiers())) {
                    accessorCtor = this.accessorFinder.getConstructorFor(MethodDescriptor.ofConstructor(configurationClass, (Class[])new Class[0]));
                }
                String rootName = rootDefinition.getRootName();
                if (rootDefinition.getConfigPhase() == ConfigPhase.BUILD_AND_RUN_TIME_FIXED) {
                    this.cc.getFieldCreator(rootFieldDescriptor).setModifiers(9 | (this.devMode ? 64 : 16));
                    instance = accessorCtor == null ? this.clinit.newInstance(MethodDescriptor.ofConstructor(configurationClass, (Class[])new Class[0]), new ResultHandle[0]) : this.clinit.invokeStaticMethod(accessorCtor, new ResultHandle[0]);
                    this.clinit.writeStaticField(rootFieldDescriptor, instance);
                    this.instanceCache.put(rootFieldDescriptor, instance);
                    if (!rootName.isEmpty()) {
                        this.clinit.invokeVirtualMethod(SB_APPEND_CHAR, this.clinitNameBuilder, new ResultHandle[]{this.clinit.load('.')});
                        this.clinit.invokeVirtualMethod(SB_APPEND_STRING, this.clinitNameBuilder, new ResultHandle[]{this.clinit.load(rootName)});
                    }
                    this.clinit.invokeStaticMethod(initGroup, new ResultHandle[]{this.clinitConfig, this.clinitNameBuilder, instance});
                    this.clinit.invokeVirtualMethod(SB_SET_LENGTH, this.clinitNameBuilder, new ResultHandle[]{clInitOldLen});
                    if (!this.devMode) continue;
                    instance = this.readConfig.readStaticField(rootFieldDescriptor);
                    if (!rootName.isEmpty()) {
                        this.readConfig.invokeVirtualMethod(SB_APPEND_CHAR, this.readConfigNameBuilder, new ResultHandle[]{this.readConfig.load('.')});
                        this.readConfig.invokeVirtualMethod(SB_APPEND_STRING, this.readConfigNameBuilder, new ResultHandle[]{this.readConfig.load(rootName)});
                    }
                    this.readConfig.invokeStaticMethod(initGroup, new ResultHandle[]{resultHandle, this.readConfigNameBuilder, instance});
                    this.readConfig.invokeVirtualMethod(SB_SET_LENGTH, this.readConfigNameBuilder, new ResultHandle[]{rcOldLen});
                    continue;
                }
                if (rootDefinition.getConfigPhase() == ConfigPhase.BOOTSTRAP) {
                    if (!this.bootstrapConfigSetupNeeded()) continue;
                    this.cc.getFieldCreator(rootFieldDescriptor).setModifiers(73);
                    instance = accessorCtor == null ? this.readBootstrapConfig.newInstance(MethodDescriptor.ofConstructor(configurationClass, (Class[])new Class[0]), new ResultHandle[0]) : this.readBootstrapConfig.invokeStaticMethod(accessorCtor, new ResultHandle[0]);
                    this.readBootstrapConfig.writeStaticField(rootFieldDescriptor, instance);
                    if (!rootName.isEmpty()) {
                        this.readBootstrapConfig.invokeVirtualMethod(SB_APPEND_CHAR, this.readBootstrapConfigNameBuilder, new ResultHandle[]{this.readBootstrapConfig.load('.')});
                        this.readBootstrapConfig.invokeVirtualMethod(SB_APPEND_STRING, this.readBootstrapConfigNameBuilder, new ResultHandle[]{this.readBootstrapConfig.load(rootName)});
                    }
                    this.readBootstrapConfig.invokeStaticMethod(initGroup, new ResultHandle[]{bootstrapConfig, this.readBootstrapConfigNameBuilder, instance});
                    this.readBootstrapConfig.invokeVirtualMethod(SB_SET_LENGTH, this.readBootstrapConfigNameBuilder, new ResultHandle[]{bcOldLen});
                    continue;
                }
                if (rootDefinition.getConfigPhase() == ConfigPhase.RUN_TIME) {
                    this.cc.getFieldCreator(rootFieldDescriptor).setModifiers(73);
                    instance = accessorCtor == null ? this.readConfig.newInstance(MethodDescriptor.ofConstructor(configurationClass, (Class[])new Class[0]), new ResultHandle[0]) : this.readConfig.invokeStaticMethod(accessorCtor, new ResultHandle[0]);
                    this.readConfig.writeStaticField(rootFieldDescriptor, instance);
                    if (!rootName.isEmpty()) {
                        this.readConfig.invokeVirtualMethod(SB_APPEND_CHAR, this.readConfigNameBuilder, new ResultHandle[]{this.readConfig.load('.')});
                        this.readConfig.invokeVirtualMethod(SB_APPEND_STRING, this.readConfigNameBuilder, new ResultHandle[]{this.readConfig.load(rootName)});
                    }
                    this.readConfig.invokeStaticMethod(initGroup, new ResultHandle[]{resultHandle, this.readConfigNameBuilder, instance});
                    this.readConfig.invokeVirtualMethod(SB_SET_LENGTH, this.readConfigNameBuilder, new ResultHandle[]{rcOldLen});
                    continue;
                }
                assert (rootDefinition.getConfigPhase() == ConfigPhase.BUILD_TIME);
            }
            GenerateOperation.configSweepLoop(siParserBody, this.clinit, this.clinitConfig);
            if (this.devMode) {
                GenerateOperation.configSweepLoop(siParserBody, this.readConfig, resultHandle);
            }
            GenerateOperation.configSweepLoop(rtParserBody, this.readConfig, resultHandle);
            if (this.bootstrapConfigSetupNeeded()) {
                GenerateOperation.configSweepLoop(bsParserBody, this.readBootstrapConfig, bootstrapConfig);
            }
            Throwable throwable = null;
            try (MethodCreator mc = this.cc.getMethodCreator(C_ENSURE_INITIALIZED);){
                mc.setModifiers(9);
                mc.returnValue(null);
            }
            catch (Throwable configurationClass) {
                Throwable throwable2 = configurationClass;
                throw configurationClass;
            }
            mc = this.cc.getMethodCreator(C_CREATE_BOOTSTRAP_CONFIG);
            Throwable throwable3 = null;
            try {
                mc.setModifiers(9);
                ResultHandle instance = mc.newInstance(MethodDescriptor.ofConstructor((String)RunTimeConfigurationGenerator.CONFIG_CLASS_NAME, (String[])new String[0]), new ResultHandle[0]);
                mc.writeStaticField(C_INSTANCE, instance);
                mc.invokeVirtualMethod(C_BOOTSTRAP_CONFIG, instance, new ResultHandle[0]);
                mc.returnValue(instance);
            }
            catch (Throwable instance) {
                Throwable throwable4 = instance;
                throw instance;
            }
            finally {
                if (mc != null) {
                    if (throwable3 != null) {
                        try {
                            mc.close();
                        }
                        catch (Throwable instance) {
                            throwable3.addSuppressed(instance);
                        }
                    } else {
                        mc.close();
                    }
                }
            }
            BytecodeCreator isError = this.readConfig.ifNonZero(this.readConfig.invokeStaticMethod(CD_IS_ERROR, new ResultHandle[0])).trueBranch();
            ResultHandle resultHandle2 = isError.invokeStaticMethod(MethodDescriptor.ofMethod(ConfigDiagnostic.class, (String)"getNiceErrorMessage", String.class, (Class[])new Class[0]), new ResultHandle[0]);
            isError.invokeStaticMethod(CD_RESET_ERROR, new ResultHandle[0]);
            ResultHandle finalErrorMessageBuilder = isError.newInstance(SB_NEW, new ResultHandle[0]);
            isError.invokeVirtualMethod(SB_APPEND_STRING, finalErrorMessageBuilder, new ResultHandle[]{isError.load("One or more configuration errors have prevented the application from starting. The errors are:\n")});
            isError.invokeVirtualMethod(SB_APPEND_STRING, finalErrorMessageBuilder, new ResultHandle[]{resultHandle2});
            ResultHandle finalErrorMessage = isError.invokeVirtualMethod(OBJ_TO_STRING, finalErrorMessageBuilder, new ResultHandle[0]);
            ResultHandle configurationException = isError.newInstance(MethodDescriptor.ofConstructor(ConfigurationException.class, (Class[])new Class[]{String.class}), new ResultHandle[]{finalErrorMessage});
            ResultHandle emptyStackTraceElement = isError.newArray(StackTraceElement.class, 0);
            isError.invokeVirtualMethod(MethodDescriptor.ofMethod(ConfigurationException.class, (String)"setStackTrace", Void.TYPE, (Class[])new Class[]{StackTraceElement[].class}), configurationException, new ResultHandle[]{emptyStackTraceElement});
            isError.throwException(configurationException);
            this.readBootstrapConfig.returnValue(null);
            this.readBootstrapConfig.close();
            this.readConfig.returnValue(null);
            this.readConfig.close();
            this.clinit.returnValue(null);
            this.clinit.close();
            this.cc.close();
            if (this.bootstrapConfigSetupNeeded()) {
                this.generateDefaultValuesConfigSourceClass(bootstrapPatternMap, RunTimeConfigurationGenerator.BSDVCS_CLASS_NAME);
            }
            this.generateDefaultValuesConfigSourceClass(runTimePatternMap, RunTimeConfigurationGenerator.RTDVCS_CLASS_NAME);
            this.generateDefaultValuesConfigSourceClass(buildTimeRunTimePatternMap, RunTimeConfigurationGenerator.BTRTDVCS_CLASS_NAME);
        }

        private static void configSweepLoop(MethodDescriptor parserBody, MethodCreator method, ResultHandle config) {
            ResultHandle nameSet = method.invokeVirtualMethod(SRC_GET_PROPERTY_NAMES, config, new ResultHandle[0]);
            ResultHandle iterator = method.invokeInterfaceMethod(ITRA_ITERATOR, nameSet, new ResultHandle[0]);
            try (BytecodeCreator sweepLoop = method.createScope();
                 BytecodeCreator hasNext = sweepLoop.ifNonZero(sweepLoop.invokeInterfaceMethod(ITR_HAS_NEXT, iterator, new ResultHandle[0])).trueBranch();){
                ResultHandle key = hasNext.checkCast(hasNext.invokeInterfaceMethod(ITR_NEXT, iterator, new ResultHandle[0]), String.class);
                ResultHandle keyIter = hasNext.newInstance(NI_NEW_STRING, new ResultHandle[]{key});
                hasNext.ifNonZero(hasNext.invokeVirtualMethod(NI_HAS_NEXT, keyIter, new ResultHandle[0])).falseBranch().continueScope(sweepLoop);
                hasNext.ifNonZero(hasNext.invokeVirtualMethod(NI_NEXT_EQUALS, keyIter, new ResultHandle[]{hasNext.load("quarkus")})).falseBranch().continueScope(sweepLoop);
                hasNext.invokeVirtualMethod(NI_NEXT, keyIter, new ResultHandle[0]);
                hasNext.invokeStaticMethod(parserBody, new ResultHandle[]{config, keyIter});
                hasNext.continueScope(sweepLoop);
            }
        }

        private void installConfiguration(ResultHandle config, MethodCreator methodCreator) {
            methodCreator.invokeStaticMethod(QCF_SET_CONFIG, new ResultHandle[]{config});
            ResultHandle configProviderResolver = methodCreator.invokeStaticMethod(CPR_INSTANCE, new ResultHandle[0]);
            try (TryBlock getConfigTry = methodCreator.tryBlock();){
                ResultHandle initialConfigHandle = getConfigTry.invokeVirtualMethod(CPR_GET_CONFIG, configProviderResolver, new ResultHandle[0]);
                getConfigTry.invokeVirtualMethod(CPR_RELEASE_CONFIG, configProviderResolver, new ResultHandle[]{initialConfigHandle});
                getConfigTry.addCatch(IllegalStateException.class);
            }
        }

        private void generateDefaultValuesConfigSourceClass(ConfigPatternMap<Container> patternMap, String className) {
            try (ClassCreator dvcc = ClassCreator.builder().classOutput(this.classOutput).className(className).superClass(AbstractRawDefaultConfigSource.class).setFinal(true).build();
                 MethodCreator mc = dvcc.getMethodCreator("getValue", String.class, new Class[]{NameIterator.class});){
                ResultHandle keyIter = mc.getMethodParam(0);
                MethodDescriptor md = GenerateOperation.generateDefaultValueParse(dvcc, patternMap, new StringBuilder("getDefaultFor"));
                if (md != null) {
                    BranchResult if1 = mc.ifNonZero(mc.invokeVirtualMethod(NI_HAS_NEXT, keyIter, new ResultHandle[0]));
                    try (BytecodeCreator true1 = if1.trueBranch();){
                        true1.invokeVirtualMethod(NI_NEXT, keyIter, new ResultHandle[0]);
                        BranchResult if2 = true1.ifNonZero(true1.invokeVirtualMethod(NI_PREVIOUS_EQUALS, keyIter, new ResultHandle[]{true1.load("quarkus")}));
                        try (BytecodeCreator true2 = if2.trueBranch();){
                            ResultHandle result = true2.invokeVirtualMethod(md, mc.getThis(), new ResultHandle[]{keyIter});
                            true2.returnValue(result);
                        }
                    }
                }
                mc.returnValue(mc.loadNull());
            }
        }

        private MethodDescriptor generateInitGroup(ClassDefinition definition) {
            Class<?> clazz = definition.getConfigurationClass();
            MethodDescriptor methodDescriptor = this.groupInitMethods.get(clazz);
            if (methodDescriptor != null) {
                return methodDescriptor;
            }
            methodDescriptor = MethodDescriptor.ofMethod((Object)RunTimeConfigurationGenerator.CONFIG_CLASS_NAME, (String)("initGroup$" + clazz.getName().replace('.', '$')), Void.TYPE, (Object[])new Object[]{SmallRyeConfig.class, StringBuilder.class, Object.class});
            MethodCreator bc = (MethodCreator)this.cc.getMethodCreator(methodDescriptor).setModifiers(8);
            ResultHandle config = bc.getMethodParam(0);
            ResultHandle nameBuilder = bc.getMethodParam(1);
            ResultHandle instance = bc.getMethodParam(2);
            ResultHandle length = bc.invokeVirtualMethod(SB_LENGTH, nameBuilder, new ResultHandle[0]);
            for (ClassDefinition.ClassMember member : definition.getMembers()) {
                String propertyName;
                block57: {
                    propertyName = member.getPropertyName();
                    MethodDescriptor setter = null;
                    if (!RunTimeConfigurationGenerator.isFieldEligibleForDirectAccess(member)) {
                        setter = this.accessorFinder.getSetterFor(member.getDescriptor());
                    }
                    if (!propertyName.isEmpty()) {
                        bc.invokeVirtualMethod(SB_APPEND_CHAR, nameBuilder, new ResultHandle[]{bc.load('.')});
                        bc.invokeVirtualMethod(SB_APPEND_STRING, nameBuilder, new ResultHandle[]{bc.load(propertyName)});
                    }
                    if (member instanceof ClassDefinition.ItemMember) {
                        ClassDefinition.ItemMember leafMember = (ClassDefinition.ItemMember)member;
                        FieldDescriptor convField = this.getOrCreateConverterInstance(leafMember.getField());
                        ResultHandle name = bc.invokeVirtualMethod(OBJ_TO_STRING, nameBuilder, new ResultHandle[0]);
                        ResultHandle converter = bc.readStaticField(convField);
                        try (TryBlock tryBlock = bc.tryBlock();){
                            ResultHandle val = tryBlock.invokeVirtualMethod(SRC_GET_VALUE, config, new ResultHandle[]{name, converter});
                            if (setter == null) {
                                tryBlock.writeInstanceField(member.getDescriptor(), instance, val);
                            } else {
                                tryBlock.invokeStaticMethod(setter, new ResultHandle[]{instance, val});
                            }
                            try (CatchBlockCreator catchBadValue = tryBlock.addCatch(IllegalArgumentException.class);){
                                catchBadValue.invokeStaticMethod(CD_INVALID_VALUE, new ResultHandle[]{name, catchBadValue.getCaughtException()});
                            }
                            var21_23 = null;
                            try (CatchBlockCreator catchNoValue = tryBlock.addCatch(NoSuchElementException.class);){
                                catchNoValue.invokeStaticMethod(CD_MISSING_VALUE, new ResultHandle[]{name, catchNoValue.getCaughtException()});
                                break block57;
                            }
                            catch (Throwable throwable) {
                                var21_23 = throwable;
                                throw throwable;
                            }
                        }
                    }
                    if (member instanceof ClassDefinition.GroupMember) {
                        ClassDefinition.GroupMember groupMember = (ClassDefinition.GroupMember)member;
                        if (groupMember.isOptional()) {
                            ResultHandle val = bc.invokeStaticMethod(OPT_EMPTY, new ResultHandle[0]);
                            if (setter == null) {
                                bc.writeInstanceField(member.getDescriptor(), instance, val);
                            } else {
                                bc.invokeStaticMethod(setter, new ResultHandle[]{instance, val});
                            }
                        } else {
                            ResultHandle nestedInstance;
                            GroupDefinition groupDefinition = groupMember.getGroupDefinition();
                            MethodDescriptor nested = this.generateInitGroup(groupDefinition);
                            if (Modifier.isPublic(groupDefinition.getConfigurationClass().getModifiers())) {
                                nestedInstance = bc.newInstance(MethodDescriptor.ofConstructor(groupDefinition.getConfigurationClass(), (Class[])new Class[0]), new ResultHandle[0]);
                            } else {
                                MethodDescriptor ctor = this.accessorFinder.getConstructorFor(MethodDescriptor.ofConstructor(groupDefinition.getConfigurationClass(), (Class[])new Class[0]));
                                nestedInstance = bc.invokeStaticMethod(ctor, new ResultHandle[0]);
                            }
                            bc.invokeStaticMethod(nested, new ResultHandle[]{config, nameBuilder, nestedInstance});
                            if (setter == null) {
                                bc.writeInstanceField(member.getDescriptor(), instance, nestedInstance);
                            } else {
                                bc.invokeStaticMethod(setter, new ResultHandle[]{instance, nestedInstance});
                            }
                        }
                    } else {
                        assert (member instanceof ClassDefinition.MapMember);
                        ResultHandle map = bc.newInstance(TM_NEW, new ResultHandle[0]);
                        if (setter == null) {
                            bc.writeInstanceField(member.getDescriptor(), instance, map);
                        } else {
                            bc.invokeStaticMethod(setter, new ResultHandle[]{instance, map});
                        }
                    }
                }
                if (propertyName.isEmpty()) continue;
                bc.invokeVirtualMethod(SB_SET_LENGTH, nameBuilder, new ResultHandle[]{length});
            }
            bc.returnValue(null);
            this.groupInitMethods.put(clazz, methodDescriptor);
            return methodDescriptor;
        }

        private static MethodDescriptor generateDefaultValueParse(ClassCreator dvcc, ConfigPatternMap<Container> keyMap, StringBuilder methodName) {
            boolean hasDefault;
            Container matched = keyMap.getMatched();
            if (matched != null) {
                ClassDefinition.ClassMember member = matched.getClassMember();
                assert (member instanceof ClassDefinition.ItemMember);
                ClassDefinition.ItemMember itemMember = (ClassDefinition.ItemMember)member;
                hasDefault = itemMember.getDefaultValue() != null;
            } else {
                hasDefault = false;
            }
            Iterable<String> names = keyMap.childNames();
            HashMap<String, MethodDescriptor> children = new HashMap<String, MethodDescriptor>();
            MethodDescriptor wildCard = null;
            for (String name : names) {
                int length = methodName.length();
                if (name.equals("{*}")) {
                    methodName.append(":*");
                    wildCard = GenerateOperation.generateDefaultValueParse(dvcc, keyMap.getChild("{*}"), methodName);
                } else {
                    methodName.append(':').append(name);
                    MethodDescriptor value = GenerateOperation.generateDefaultValueParse(dvcc, keyMap.getChild(name), methodName);
                    if (value != null) {
                        children.put(name, value);
                    }
                }
                methodName.setLength(length);
            }
            if (children.isEmpty() && wildCard == null && !hasDefault) {
                return null;
            }
            try (MethodCreator body = dvcc.getMethodCreator(methodName.toString(), String.class, new Class[]{NameIterator.class});){
                body.setModifiers(2);
                ResultHandle keyIter = body.getMethodParam(0);
                try (Object matchedBody = body.ifNonZero(body.invokeVirtualMethod(NI_HAS_NEXT, keyIter, new ResultHandle[0])).falseBranch();){
                    if (matched != null) {
                        ClassDefinition.ClassMember member = matched.getClassMember();
                        assert (member instanceof ClassDefinition.ItemMember);
                        ClassDefinition.ItemMember itemMember = (ClassDefinition.ItemMember)member;
                        String defaultValue = itemMember.getDefaultValue();
                        if (defaultValue != null) {
                            matchedBody.returnValue(matchedBody.load(defaultValue));
                        } else {
                            matchedBody.returnValue(matchedBody.loadNull());
                        }
                    } else {
                        matchedBody.returnValue(matchedBody.loadNull());
                    }
                }
                for (String name : children.keySet()) {
                    BytecodeCreator nameMatched = body.ifNonZero(body.invokeVirtualMethod(NI_NEXT_EQUALS, keyIter, new ResultHandle[]{body.load(name)})).trueBranch();
                    Throwable throwable = null;
                    try {
                        nameMatched.invokeVirtualMethod(NI_NEXT, keyIter, new ResultHandle[0]);
                        ResultHandle result = nameMatched.invokeVirtualMethod((MethodDescriptor)children.get(name), body.getThis(), new ResultHandle[]{keyIter});
                        nameMatched.returnValue(result);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (nameMatched == null) continue;
                        if (throwable != null) {
                            try {
                                nameMatched.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        nameMatched.close();
                    }
                }
                if (wildCard != null) {
                    matchedBody = body.ifNonZero(body.invokeVirtualMethod(NI_HAS_NEXT, keyIter, new ResultHandle[0])).trueBranch();
                    var12_14 = null;
                    try {
                        matchedBody.invokeVirtualMethod(NI_NEXT, keyIter, new ResultHandle[0]);
                        ResultHandle result = matchedBody.invokeVirtualMethod(wildCard, body.getThis(), new ResultHandle[]{keyIter});
                        matchedBody.returnValue(result);
                    }
                    catch (Throwable throwable) {
                        var12_14 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (matchedBody != null) {
                            if (var12_14 != null) {
                                try {
                                    matchedBody.close();
                                }
                                catch (Throwable throwable) {
                                    var12_14.addSuppressed(throwable);
                                }
                            } else {
                                matchedBody.close();
                            }
                        }
                    }
                }
                body.returnValue(body.loadNull());
                MethodDescriptor methodDescriptor = body.getMethodDescriptor();
                return methodDescriptor;
            }
        }

        private void generateEmptyParsers(ClassCreator cc) {
            MethodCreator body = cc.getMethodCreator(RT_EMPTY_PARSER);
            body.setModifiers(10);
            ResultHandle keyIter = body.getMethodParam(1);
            try (BytecodeCreator matchedBody = body.ifNonZero(body.invokeVirtualMethod(NI_HAS_NEXT, keyIter, new ResultHandle[0])).falseBranch();){
                matchedBody.returnValue(null);
            }
            body.invokeStaticMethod(CD_UNKNOWN_RT, new ResultHandle[]{keyIter});
            body.returnValue(null);
            body = cc.getMethodCreator(EMPTY_PARSER);
            body.setModifiers(10);
            keyIter = body.getMethodParam(1);
            matchedBody = body.ifNonZero(body.invokeVirtualMethod(NI_HAS_NEXT, keyIter, new ResultHandle[0])).falseBranch();
            var5_5 = null;
            try {
                matchedBody.returnValue(null);
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
            finally {
                if (matchedBody != null) {
                    if (var5_5 != null) {
                        try {
                            matchedBody.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        matchedBody.close();
                    }
                }
            }
            body.invokeStaticMethod(CD_UNKNOWN, new ResultHandle[]{keyIter});
            body.returnValue(null);
        }

        private MethodDescriptor generateParserBody(ConfigPatternMap<Container> keyMap, ConfigPatternMap<?> ignoredMap, StringBuilder methodName, boolean dynamic, Type type) {
            Object ignoreMatched;
            Container matched = keyMap == null ? null : keyMap.getMatched();
            Object v0 = ignoreMatched = ignoredMap == null ? null : ignoredMap.getMatched();
            if (!(matched != null || ignoreMatched == null || keyMap != null && keyMap.childNames().iterator().hasNext())) {
                Iterable<String> names = ignoredMap.childNames();
                boolean needsCode = false;
                for (String name : names) {
                    if (name.equals("{*}")) {
                        needsCode = true;
                        break;
                    }
                    ConfigPatternMap<Container> keyChildMap = keyMap == null ? null : keyMap.getChild(name);
                    if (keyChildMap != null) continue;
                    needsCode = true;
                    break;
                }
                if (!needsCode) {
                    return type == Type.BUILD_TIME ? EMPTY_PARSER : RT_EMPTY_PARSER;
                }
            }
            try (MethodCreator body = this.cc.getMethodCreator(methodName.toString(), Void.TYPE, new Class[]{SmallRyeConfig.class, NameIterator.class});){
                Iterable<String> names;
                Object lastSeg;
                body.setModifiers(10);
                ResultHandle config = body.getMethodParam(0);
                ResultHandle keyIter = body.getMethodParam(1);
                try (BytecodeCreator matchedBody = body.ifNonZero(body.invokeVirtualMethod(NI_HAS_NEXT, keyIter, new ResultHandle[0])).falseBranch();){
                    if (matched != null) {
                        ClassDefinition.ClassMember member = matched.getClassMember();
                        assert (member instanceof ClassDefinition.ItemMember);
                        ClassDefinition.ItemMember itemMember = (ClassDefinition.ItemMember)member;
                        if (matched instanceof FieldContainer) {
                            FieldContainer fieldContainer = (FieldContainer)matched;
                            if (dynamic) {
                                if (!itemMember.getPropertyName().isEmpty()) {
                                    matchedBody.invokeVirtualMethod(NI_PREVIOUS, keyIter, new ResultHandle[0]);
                                }
                                matchedBody.invokeStaticMethod(this.generateGetEnclosing(fieldContainer, type), new ResultHandle[]{keyIter, config});
                            }
                        } else {
                            assert (matched instanceof MapContainer);
                            MapContainer mapContainer = (MapContainer)matched;
                            lastSeg = matchedBody.invokeVirtualMethod(NI_GET_PREVIOUS_SEGMENT, keyIter, new ResultHandle[0]);
                            matchedBody.invokeVirtualMethod(NI_PREVIOUS, keyIter, new ResultHandle[0]);
                            ResultHandle mapHandle = matchedBody.invokeStaticMethod(this.generateGetEnclosing(mapContainer, type), new ResultHandle[]{keyIter, config});
                            Field field = mapContainer.findField();
                            FieldDescriptor fd = this.getOrCreateConverterInstance(field);
                            ResultHandle key = matchedBody.invokeVirtualMethod(NI_GET_NAME, keyIter, new ResultHandle[0]);
                            ResultHandle converter = matchedBody.readStaticField(fd);
                            ResultHandle value = matchedBody.invokeVirtualMethod(SRC_GET_VALUE, config, new ResultHandle[]{key, converter});
                            matchedBody.invokeInterfaceMethod(MAP_PUT, mapHandle, new ResultHandle[]{lastSeg, value});
                        }
                    } else if (ignoreMatched == null) {
                        matchedBody.invokeStaticMethod(type == Type.BUILD_TIME ? CD_UNKNOWN : CD_UNKNOWN_RT, new ResultHandle[]{keyIter});
                    }
                    matchedBody.returnValue(null);
                }
                boolean hasWildCard = false;
                if (keyMap != null) {
                    names = keyMap.childNames();
                    for (String name : names) {
                        if (name.equals("{*}")) {
                            hasWildCard = true;
                            continue;
                        }
                        BytecodeCreator nameMatched = body.ifNonZero(body.invokeVirtualMethod(NI_NEXT_EQUALS, keyIter, new ResultHandle[]{body.load(name)})).trueBranch();
                        lastSeg = null;
                        try {
                            nameMatched.invokeVirtualMethod(NI_NEXT, keyIter, new ResultHandle[0]);
                            int length = methodName.length();
                            methodName.append(':').append(name);
                            nameMatched.invokeStaticMethod(this.generateParserBody(keyMap.getChild(name), ignoredMap == null ? null : ignoredMap.getChild(name), methodName, dynamic, type), new ResultHandle[]{config, keyIter});
                            methodName.setLength(length);
                            nameMatched.returnValue(null);
                        }
                        catch (Throwable throwable) {
                            lastSeg = throwable;
                            throw throwable;
                        }
                        finally {
                            if (nameMatched == null) continue;
                            if (lastSeg != null) {
                                try {
                                    nameMatched.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)lastSeg).addSuppressed(throwable);
                                }
                                continue;
                            }
                            nameMatched.close();
                        }
                    }
                }
                if (ignoredMap != null) {
                    names = ignoredMap.childNames();
                    for (String name : names) {
                        ConfigPatternMap<Container> keyChildMap;
                        if (name.equals("{*}")) {
                            hasWildCard = true;
                            continue;
                        }
                        ConfigPatternMap<Container> configPatternMap = keyChildMap = keyMap == null ? null : keyMap.getChild(name);
                        if (keyChildMap != null) continue;
                        BytecodeCreator nameMatched = body.ifNonZero(body.invokeVirtualMethod(NI_NEXT_EQUALS, keyIter, new ResultHandle[]{body.load(name)})).trueBranch();
                        Throwable throwable = null;
                        try {
                            nameMatched.invokeVirtualMethod(NI_NEXT, keyIter, new ResultHandle[0]);
                            int length = methodName.length();
                            methodName.append(':').append(name);
                            nameMatched.invokeStaticMethod(this.generateParserBody(null, ignoredMap.getChild(name), methodName, false, type), new ResultHandle[]{config, keyIter});
                            methodName.setLength(length);
                            nameMatched.returnValue(null);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (nameMatched == null) continue;
                            if (throwable != null) {
                                try {
                                    nameMatched.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            nameMatched.close();
                        }
                    }
                }
                if (hasWildCard) {
                    assert (keyMap != null || ignoredMap != null);
                    BytecodeCreator matchedBody = body.ifNonZero(body.invokeVirtualMethod(NI_HAS_NEXT, keyIter, new ResultHandle[0])).trueBranch();
                    Object object = null;
                    try {
                        matchedBody.invokeVirtualMethod(NI_NEXT, keyIter, new ResultHandle[0]);
                        int length = methodName.length();
                        methodName.append(":*");
                        matchedBody.invokeStaticMethod(this.generateParserBody(keyMap == null ? null : keyMap.getChild("{*}"), ignoredMap == null ? null : ignoredMap.getChild("{*}"), methodName, true, type), new ResultHandle[]{config, keyIter});
                        methodName.setLength(length);
                        matchedBody.returnValue(null);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (matchedBody != null) {
                            if (object != null) {
                                try {
                                    matchedBody.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                matchedBody.close();
                            }
                        }
                    }
                }
                body.invokeStaticMethod(type == Type.BUILD_TIME ? CD_UNKNOWN : CD_UNKNOWN_RT, new ResultHandle[]{keyIter});
                body.returnValue(null);
                var13_16 = body.getMethodDescriptor();
                return var13_16;
            }
        }

        private MethodDescriptor generateGetEnclosing(FieldContainer matchNode, Type type) {
            MethodDescriptor md = this.enclosingMemberMethods.get(matchNode);
            if (md != null) {
                return md;
            }
            md = MethodDescriptor.ofMethod((Object)RunTimeConfigurationGenerator.CONFIG_CLASS_NAME, (String)(type.methodPrefix + "GetEnclosing:" + matchNode.getCombinedName()), Object.class, (Object[])new Object[]{NameIterator.class, SmallRyeConfig.class});
            try (MethodCreator mc = this.cc.getMethodCreator(md);){
                mc.setModifiers(8);
                ResultHandle keyIter = mc.getMethodParam(0);
                ResultHandle config = mc.getMethodParam(1);
                ClassDefinition.ClassMember member = matchNode.getClassMember();
                Container parent = matchNode.getParent();
                if (parent == null) {
                    RootDefinition definition = (RootDefinition)member.getEnclosingDefinition();
                    FieldDescriptor fieldDescriptor = this.configRootsByType.get(definition.getConfigurationClass());
                    assert (fieldDescriptor != null) : "Field descriptor defined for " + definition.getConfigurationClass();
                    mc.returnValue(mc.readStaticField(fieldDescriptor));
                } else if (parent instanceof FieldContainer) {
                    ResultHandle fieldVal;
                    FieldContainer fieldContainer = (FieldContainer)parent;
                    ClassDefinition.ClassMember classMember = fieldContainer.getClassMember();
                    if (!classMember.getPropertyName().isEmpty()) {
                        mc.invokeVirtualMethod(NI_PREVIOUS, keyIter, new ResultHandle[0]);
                    }
                    ResultHandle enclosing = mc.invokeStaticMethod(this.generateGetEnclosing(fieldContainer, type), new ResultHandle[]{keyIter, config});
                    if (RunTimeConfigurationGenerator.isFieldEligibleForDirectAccess(classMember)) {
                        fieldVal = mc.readInstanceField(classMember.getDescriptor(), enclosing);
                    } else {
                        MethodDescriptor getter = this.accessorFinder.getGetterFor(classMember.getDescriptor());
                        fieldVal = mc.invokeStaticMethod(getter, new ResultHandle[]{enclosing});
                    }
                    AssignableResultHandle group = mc.createVariable(Object.class);
                    if (classMember instanceof ClassDefinition.GroupMember && ((ClassDefinition.GroupMember)classMember).isOptional()) {
                        ResultHandle instance;
                        BranchResult isPresent = mc.ifNonZero(mc.invokeVirtualMethod(OPT_IS_PRESENT, fieldVal, new ResultHandle[0]));
                        BytecodeCreator trueBranch = isPresent.trueBranch();
                        BytecodeCreator falseBranch = isPresent.falseBranch();
                        trueBranch.assign(group, trueBranch.invokeVirtualMethod(OPT_GET, fieldVal, new ResultHandle[0]));
                        if (Modifier.isPublic(member.getEnclosingDefinition().getConfigurationClass().getModifiers())) {
                            instance = falseBranch.newInstance(MethodDescriptor.ofConstructor(member.getEnclosingDefinition().getConfigurationClass(), (Class[])new Class[0]), new ResultHandle[0]);
                        } else {
                            MethodDescriptor ctor = this.accessorFinder.getConstructorFor(MethodDescriptor.ofConstructor(member.getEnclosingDefinition().getConfigurationClass(), (Class[])new Class[0]));
                            instance = falseBranch.invokeStaticMethod(ctor, new ResultHandle[0]);
                        }
                        ResultHandle precedingKey = falseBranch.invokeVirtualMethod(NI_GET_ALL_PREVIOUS_SEGMENTS, keyIter, new ResultHandle[0]);
                        ResultHandle nameBuilder = falseBranch.newInstance(SB_NEW_STR, new ResultHandle[]{precedingKey});
                        falseBranch.invokeStaticMethod(this.generateInitGroup(member.getEnclosingDefinition()), new ResultHandle[]{config, nameBuilder, instance});
                        ResultHandle val = falseBranch.invokeStaticMethod(OPT_OF, new ResultHandle[]{instance});
                        if (RunTimeConfigurationGenerator.isFieldEligibleForDirectAccess(member)) {
                            falseBranch.writeInstanceField(member.getDescriptor(), instance, val);
                        } else {
                            MethodDescriptor setter = this.accessorFinder.getSetterFor(classMember.getDescriptor());
                            falseBranch.invokeStaticMethod(setter, new ResultHandle[]{fieldVal, val});
                        }
                        falseBranch.assign(group, instance);
                    } else {
                        mc.assign(group, fieldVal);
                    }
                    if (!classMember.getPropertyName().isEmpty()) {
                        mc.invokeVirtualMethod(NI_NEXT, keyIter, new ResultHandle[0]);
                    }
                    mc.returnValue((ResultHandle)group);
                } else {
                    ResultHandle instance;
                    assert (parent instanceof MapContainer);
                    MapContainer mapContainer = (MapContainer)parent;
                    ResultHandle key = mc.invokeVirtualMethod(NI_GET_PREVIOUS_SEGMENT, keyIter, new ResultHandle[0]);
                    mc.invokeVirtualMethod(NI_PREVIOUS, keyIter, new ResultHandle[0]);
                    ResultHandle map = mc.invokeStaticMethod(this.generateGetEnclosing(mapContainer, type), new ResultHandle[]{keyIter, config});
                    mc.invokeVirtualMethod(NI_NEXT, keyIter, new ResultHandle[0]);
                    ResultHandle existing = mc.invokeInterfaceMethod(MAP_GET, map, new ResultHandle[]{key});
                    mc.ifNull(existing).falseBranch().returnValue(existing);
                    if (Modifier.isPublic(member.getEnclosingDefinition().getConfigurationClass().getModifiers())) {
                        instance = mc.newInstance(MethodDescriptor.ofConstructor(member.getEnclosingDefinition().getConfigurationClass(), (Class[])new Class[0]), new ResultHandle[0]);
                    } else {
                        MethodDescriptor ctor = this.accessorFinder.getConstructorFor(MethodDescriptor.ofConstructor(member.getEnclosingDefinition().getConfigurationClass(), (Class[])new Class[0]));
                        instance = mc.invokeStaticMethod(ctor, new ResultHandle[0]);
                    }
                    ResultHandle precedingKey = mc.invokeVirtualMethod(NI_GET_ALL_PREVIOUS_SEGMENTS, keyIter, new ResultHandle[0]);
                    ResultHandle nameBuilder = mc.newInstance(SB_NEW_STR, new ResultHandle[]{precedingKey});
                    mc.invokeStaticMethod(this.generateInitGroup(member.getEnclosingDefinition()), new ResultHandle[]{config, nameBuilder, instance});
                    mc.invokeInterfaceMethod(MAP_PUT, map, new ResultHandle[]{key, instance});
                    mc.returnValue(instance);
                }
            }
            this.enclosingMemberMethods.put(matchNode, md);
            return md;
        }

        private MethodDescriptor generateGetEnclosing(MapContainer matchNode, Type type) {
            MethodDescriptor md = this.enclosingMemberMethods.get(matchNode);
            if (md != null) {
                return md;
            }
            md = MethodDescriptor.ofMethod((Object)RunTimeConfigurationGenerator.CONFIG_CLASS_NAME, (String)(type.methodPrefix + "GetEnclosing:" + matchNode.getCombinedName()), Object.class, (Object[])new Object[]{NameIterator.class, SmallRyeConfig.class});
            try (MethodCreator mc = this.cc.getMethodCreator(md);){
                mc.setModifiers(8);
                ResultHandle keyIter = mc.getMethodParam(0);
                ResultHandle config = mc.getMethodParam(1);
                Container parent = matchNode.getParent();
                if (parent instanceof FieldContainer) {
                    ResultHandle result;
                    FieldContainer fieldContainer = (FieldContainer)parent;
                    if (!fieldContainer.getClassMember().getPropertyName().isEmpty()) {
                        mc.invokeVirtualMethod(NI_PREVIOUS, keyIter, new ResultHandle[0]);
                    }
                    ResultHandle enclosing = mc.invokeStaticMethod(this.generateGetEnclosing(fieldContainer, type), new ResultHandle[]{keyIter, config});
                    if (!fieldContainer.getClassMember().getPropertyName().isEmpty()) {
                        mc.invokeVirtualMethod(NI_NEXT, keyIter, new ResultHandle[0]);
                    }
                    if (RunTimeConfigurationGenerator.isFieldEligibleForDirectAccess(fieldContainer.getClassMember())) {
                        result = mc.readInstanceField(fieldContainer.getClassMember().getDescriptor(), enclosing);
                    } else {
                        MethodDescriptor getter = this.accessorFinder.getGetterFor(fieldContainer.getClassMember().getDescriptor());
                        result = mc.invokeStaticMethod(getter, new ResultHandle[]{enclosing});
                    }
                    mc.returnValue(result);
                } else {
                    assert (parent instanceof MapContainer);
                    MapContainer mapContainer = (MapContainer)parent;
                    ResultHandle key = mc.invokeVirtualMethod(NI_GET_PREVIOUS_SEGMENT, keyIter, new ResultHandle[0]);
                    mc.invokeVirtualMethod(NI_PREVIOUS, keyIter, new ResultHandle[0]);
                    ResultHandle map = mc.invokeStaticMethod(this.generateGetEnclosing(mapContainer, type), new ResultHandle[]{keyIter, config});
                    mc.invokeVirtualMethod(NI_NEXT, keyIter, new ResultHandle[0]);
                    ResultHandle existing = mc.invokeInterfaceMethod(MAP_GET, map, new ResultHandle[]{key});
                    mc.ifNull(existing).falseBranch().returnValue(existing);
                    ResultHandle instance = mc.newInstance(TM_NEW, new ResultHandle[0]);
                    mc.invokeInterfaceMethod(MAP_PUT, map, new ResultHandle[]{key, instance});
                    mc.returnValue(instance);
                }
            }
            this.enclosingMemberMethods.put(matchNode, md);
            return md;
        }

        private FieldDescriptor getOrCreateConverterInstance(Field field) {
            return this.getOrCreateConverterInstance(field, ConverterType.of(field));
        }

        private FieldDescriptor getOrCreateConverterInstance(Field field, ConverterType type) {
            ResultHandle converter;
            FieldDescriptor fd = this.convertersByType.get(type);
            if (fd != null) {
                return fd;
            }
            fd = FieldDescriptor.of((String)this.cc.getClassName(), (String)("conv$" + this.converterIndex++), Converter.class);
            boolean storeConverter = false;
            if (type instanceof Leaf) {
                Leaf leaf = (Leaf)type;
                Class<? extends Converter<?>> convertWith = leaf.getConvertWith();
                if (convertWith != null) {
                    converter = convertWith == HyphenateEnumConverter.class.asSubclass(Converter.class) ? this.converterSetup.newInstance(MethodDescriptor.ofConstructor(convertWith, (Class[])new Class[]{Class.class}), new ResultHandle[]{this.converterSetup.loadClass(type.getLeafType())}) : this.converterSetup.newInstance(MethodDescriptor.ofConstructor(convertWith, (Class[])new Class[0]), new ResultHandle[0]);
                } else {
                    ResultHandle clazzHandle = this.converterSetup.loadClass(leaf.getLeafType());
                    converter = this.converterSetup.invokeVirtualMethod(SRC_GET_CONVERTER, this.clinitConfig, new ResultHandle[]{clazzHandle});
                    storeConverter = true;
                }
            } else if (type instanceof ArrayOf) {
                ArrayOf arrayOf = (ArrayOf)type;
                ResultHandle nestedConv = this.instanceCache.get(this.getOrCreateConverterInstance(field, arrayOf.getElementType()));
                converter = this.converterSetup.invokeStaticMethod(CONVS_NEW_ARRAY_CONVERTER, new ResultHandle[]{nestedConv, this.converterSetup.loadClass(arrayOf.getArrayType())});
            } else if (type instanceof CollectionOf) {
                ResultHandle factory;
                CollectionOf collectionOf = (CollectionOf)type;
                ResultHandle nestedConv = this.instanceCache.get(this.getOrCreateConverterInstance(field, collectionOf.getElementType()));
                Class<?> collectionClass = collectionOf.getCollectionClass();
                if (collectionClass == List.class) {
                    factory = this.converterSetup.invokeStaticMethod(CU_LIST_FACTORY, new ResultHandle[0]);
                } else if (collectionClass == Set.class) {
                    factory = this.converterSetup.invokeStaticMethod(CU_SET_FACTORY, new ResultHandle[0]);
                } else if (collectionClass == SortedSet.class) {
                    factory = this.converterSetup.invokeStaticMethod(CU_SORTED_SET_FACTORY, new ResultHandle[0]);
                } else {
                    throw ReflectUtil.reportError(field, "Unsupported configuration collection type: %s", collectionClass);
                }
                converter = this.converterSetup.invokeStaticMethod(CONVS_NEW_COLLECTION_CONVERTER, new ResultHandle[]{nestedConv, factory});
            } else if (type instanceof LowerBoundCheckOf) {
                LowerBoundCheckOf boundCheckOf = (LowerBoundCheckOf)type;
                converter = this.instanceCache.get(this.getOrCreateConverterInstance(field, boundCheckOf.getClassConverterType()));
            } else if (type instanceof UpperBoundCheckOf) {
                UpperBoundCheckOf boundCheckOf = (UpperBoundCheckOf)type;
                converter = this.instanceCache.get(this.getOrCreateConverterInstance(field, boundCheckOf.getClassConverterType()));
            } else if (type instanceof MinMaxValidated) {
                MinMaxValidated minMaxValidated = (MinMaxValidated)type;
                String min = minMaxValidated.getMin();
                boolean minInclusive = minMaxValidated.isMinInclusive();
                String max = minMaxValidated.getMax();
                boolean maxInclusive = minMaxValidated.isMaxInclusive();
                ResultHandle nestedConv = this.instanceCache.get(this.getOrCreateConverterInstance(field, minMaxValidated.getNestedType()));
                if (min != null) {
                    converter = max != null ? this.converterSetup.invokeStaticMethod(CONVS_RANGE_VALUE_STRING_CONVERTER, new ResultHandle[]{nestedConv, this.converterSetup.load(min), this.converterSetup.load(minInclusive), this.converterSetup.load(max), this.converterSetup.load(maxInclusive)}) : this.converterSetup.invokeStaticMethod(CONVS_MINIMUM_VALUE_STRING_CONVERTER, new ResultHandle[]{nestedConv, this.converterSetup.load(min), this.converterSetup.load(minInclusive)});
                } else {
                    assert (min == null && max != null);
                    converter = this.converterSetup.invokeStaticMethod(CONVS_MAXIMUM_VALUE_STRING_CONVERTER, new ResultHandle[]{nestedConv, this.converterSetup.load(max), this.converterSetup.load(maxInclusive)});
                }
            } else if (type instanceof OptionalOf) {
                OptionalOf optionalOf = (OptionalOf)type;
                ResultHandle nestedConv = this.instanceCache.get(this.getOrCreateConverterInstance(field, optionalOf.getNestedType()));
                converter = this.converterSetup.invokeStaticMethod(CONVS_NEW_OPTIONAL_CONVERTER, new ResultHandle[]{nestedConv});
            } else if (type instanceof PatternValidated) {
                PatternValidated patternValidated = (PatternValidated)type;
                ResultHandle nestedConv = this.instanceCache.get(this.getOrCreateConverterInstance(field, patternValidated.getNestedType()));
                ResultHandle patternStr = this.converterSetup.load(patternValidated.getPatternString());
                converter = this.converterSetup.invokeStaticMethod(CONVS_PATTERN_CONVERTER, new ResultHandle[]{nestedConv, patternStr});
            } else {
                throw Assert.unreachableCode();
            }
            this.cc.getFieldCreator(fd).setModifiers(24);
            this.converterSetup.writeStaticField(fd, converter);
            this.convertersByType.put(type, fd);
            this.instanceCache.put(fd, converter);
            if (storeConverter) {
                this.convertersToRegister.put(fd, type.getLeafType());
            }
            return fd;
        }

        @Override
        public void close() {
            try {
                this.clinit.close();
            }
            finally {
                this.cc.close();
            }
        }

        static final class Builder {
            private boolean devMode;
            private ClassOutput classOutput;
            private BuildTimeConfigurationReader.ReadResult buildTimeReadResult;
            private Map<String, String> runTimeDefaults;
            private List<Class<?>> additionalTypes;
            private List<String> additionalBootstrapConfigSourceProviders;

            Builder() {
            }

            ClassOutput getClassOutput() {
                return this.classOutput;
            }

            Builder setClassOutput(ClassOutput classOutput) {
                this.classOutput = classOutput;
                return this;
            }

            BuildTimeConfigurationReader.ReadResult getBuildTimeReadResult() {
                return this.buildTimeReadResult;
            }

            Builder setBuildTimeReadResult(BuildTimeConfigurationReader.ReadResult buildTimeReadResult) {
                this.buildTimeReadResult = buildTimeReadResult;
                return this;
            }

            Map<String, String> getRunTimeDefaults() {
                return this.runTimeDefaults;
            }

            Builder setRunTimeDefaults(Map<String, String> runTimeDefaults) {
                this.runTimeDefaults = runTimeDefaults;
                return this;
            }

            List<Class<?>> getAdditionalTypes() {
                return this.additionalTypes;
            }

            Builder setAdditionalTypes(List<Class<?>> additionalTypes) {
                this.additionalTypes = additionalTypes;
                return this;
            }

            public boolean isDevMode() {
                return this.devMode;
            }

            public Builder setDevMode(boolean devMode) {
                this.devMode = devMode;
                return this;
            }

            Builder setAdditionalBootstrapConfigSourceProviders(List<String> additionalBootstrapConfigSourceProviders) {
                this.additionalBootstrapConfigSourceProviders = additionalBootstrapConfigSourceProviders;
                return this;
            }

            GenerateOperation build() {
                return new GenerateOperation(this);
            }
        }
    }
}

