/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration.definition;

import io.quarkus.deployment.configuration.definition.ClassDefinition;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.util.StringUtil;
import java.util.Iterator;
import java.util.List;
import org.wildfly.common.Assert;

public final class RootDefinition
extends ClassDefinition {
    private final ConfigPhase configPhase;
    private final String rootName;
    private final FieldDescriptor descriptor;

    RootDefinition(Builder builder) {
        super(builder);
        this.configPhase = builder.configPhase;
        String rootName = builder.rootName;
        Class<?> configClass = this.getConfigurationClass();
        List segments = StringUtil.toList((Iterator)StringUtil.camelHumpsIterator((String)configClass.getSimpleName()));
        List trimmedSegments = this.configPhase == ConfigPhase.RUN_TIME ? StringUtil.withoutSuffix((List)StringUtil.withoutSuffix((List)StringUtil.withoutSuffix((List)StringUtil.withoutSuffix((List)StringUtil.withoutSuffix((List)StringUtil.withoutSuffix((List)segments, (Object[])new String[]{"Runtime", "Configuration"}), (Object[])new String[]{"Runtime", "Config"}), (Object[])new String[]{"Run", "Time", "Configuration"}), (Object[])new String[]{"Run", "Time", "Config"}), (Object[])new String[]{"Configuration"}), (Object[])new String[]{"Config"}) : (this.configPhase == ConfigPhase.BOOTSTRAP ? StringUtil.withoutSuffix((List)StringUtil.withoutSuffix((List)StringUtil.withoutSuffix((List)StringUtil.withoutSuffix((List)segments, (Object[])new String[]{"Bootstrap", "Configuration"}), (Object[])new String[]{"Bootstrap", "Config"}), (Object[])new String[]{"Configuration"}), (Object[])new String[]{"Config"}) : StringUtil.withoutSuffix((List)StringUtil.withoutSuffix((List)StringUtil.withoutSuffix((List)StringUtil.withoutSuffix((List)segments, (Object[])new String[]{"Build", "Time", "Configuration"}), (Object[])new String[]{"Build", "Time", "Config"}), (Object[])new String[]{"Configuration"}), (Object[])new String[]{"Config"}));
        if (rootName.equals("<<parent>>")) {
            rootName = "";
        } else if (rootName.equals("<<element name>>")) {
            rootName = String.join((CharSequence)"", () -> StringUtil.lowerCaseFirst(trimmedSegments.iterator()));
        } else if (rootName.equals("<<hyphenated element name>>")) {
            rootName = String.join((CharSequence)"-", () -> StringUtil.lowerCase(trimmedSegments.iterator()));
        }
        this.rootName = rootName;
        this.descriptor = FieldDescriptor.of((String)"io.quarkus.runtime.generated.Config", (String)String.join((CharSequence)"", segments), configClass);
    }

    public ConfigPhase getConfigPhase() {
        return this.configPhase;
    }

    public String getRootName() {
        return this.rootName;
    }

    public FieldDescriptor getDescriptor() {
        return this.descriptor;
    }

    public static final class Builder
    extends ClassDefinition.Builder {
        private ConfigPhase configPhase = ConfigPhase.BUILD_TIME;
        private String rootName = "<<hyphenated element name>>";

        public ConfigPhase getConfigPhase() {
            return this.configPhase;
        }

        public Builder setConfigPhase(ConfigPhase configPhase) {
            Assert.checkNotNullParam((String)"configPhase", (Object)configPhase);
            this.configPhase = configPhase;
            return this;
        }

        public String getRootName() {
            return this.rootName;
        }

        public Builder setRootName(String rootName) {
            Assert.checkNotNullParam((String)"rootName", (Object)rootName);
            this.rootName = rootName;
            return this;
        }

        @Override
        public RootDefinition build() {
            return new RootDefinition(this);
        }
    }
}

