/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.ide;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public enum Ide {
    IDEA("idea", "--help"),
    ECLIPSE("eclipse", null),
    VSCODE("code", "--version"),
    NETBEANS("netbeans", "--help");

    private final String defaultCommand;
    private final List<String> markerArgs;
    private String machineSpecificCommand;
    private String effectiveCommand;

    private Ide(String defaultCommand, String ... markerArgs) {
        this.defaultCommand = defaultCommand;
        this.markerArgs = markerArgs != null ? Arrays.asList(markerArgs) : Collections.emptyList();
    }

    public String getEffectiveCommand() {
        if (this.effectiveCommand != null) {
            return this.effectiveCommand;
        }
        this.effectiveCommand = this.doGetEffectiveCommand();
        return this.effectiveCommand;
    }

    private String doGetEffectiveCommand() {
        if (this.defaultCommand != null) {
            if (this.markerArgs == null) {
                return this.defaultCommand;
            }
            try {
                ArrayList<String> command = new ArrayList<String>(1 + this.markerArgs.size());
                command.add(this.defaultCommand);
                command.addAll(this.markerArgs);
                new ProcessBuilder(command).redirectError(ProcessBuilder.Redirect.DISCARD.file()).redirectOutput(ProcessBuilder.Redirect.DISCARD.file()).start().waitFor(10L, TimeUnit.SECONDS);
                return this.defaultCommand;
            }
            catch (Exception e) {
                return this.machineSpecificCommand;
            }
        }
        return this.machineSpecificCommand;
    }

    public void setMachineSpecificCommand(String machineSpecificCommand) {
        this.machineSpecificCommand = machineSpecificCommand;
    }

    public String toString() {
        return "Ide{defaultCommand='" + this.defaultCommand + "'}";
    }
}

