/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.bootstrap.logging.InitialConfigurator;
import io.quarkus.bootstrap.logging.QuarkusDelayedHandler;
import io.quarkus.bootstrap.runner.Timing;
import io.quarkus.builder.Version;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ApplicationClassNameBuildItem;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.BytecodeRecorderObjectLoaderBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.JavaLibraryPathAdditionalPathBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.MainBytecodeRecorderBuildItem;
import io.quarkus.deployment.builditem.MainClassBuildItem;
import io.quarkus.deployment.builditem.ObjectSubstitutionBuildItem;
import io.quarkus.deployment.builditem.QuarkusApplicationClassBuildItem;
import io.quarkus.deployment.builditem.RecordableConstructorBuildItem;
import io.quarkus.deployment.builditem.StaticBytecodeRecorderBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.configuration.RunTimeConfigurationGenerator;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.AppCDSRequestedBuildItem;
import io.quarkus.deployment.recording.BytecodeRecorderImpl;
import io.quarkus.dev.appstate.ApplicationStateNotification;
import io.quarkus.dev.console.QuarkusConsole;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.runtime.Application;
import io.quarkus.runtime.ApplicationLifecycleManager;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.NativeImageRuntimePropertiesRecorder;
import io.quarkus.runtime.Quarkus;
import io.quarkus.runtime.QuarkusApplication;
import io.quarkus.runtime.StartupContext;
import io.quarkus.runtime.StartupTask;
import io.quarkus.runtime.annotations.QuarkusMain;
import io.quarkus.runtime.appcds.AppCDSUtil;
import io.quarkus.runtime.configuration.ProfileManager;
import io.quarkus.runtime.util.StepTiming;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.stream.Collectors;
import org.graalvm.nativeimage.ImageInfo;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class MainClassBuildStep {
    static final String MAIN_CLASS = "io.quarkus.runner.GeneratedMain";
    static final String STARTUP_CONTEXT = "STARTUP_CONTEXT";
    static final String LOG = "LOG";
    static final String JAVA_LIBRARY_PATH = "java.library.path";
    public static final String GENERATE_APP_CDS_SYSTEM_PROPERTY = "quarkus.appcds.generate";
    private static final FieldDescriptor STARTUP_CONTEXT_FIELD = FieldDescriptor.of((String)"io.quarkus.runner.ApplicationImpl", (String)"STARTUP_CONTEXT", StartupContext.class);
    public static final MethodDescriptor PRINT_STEP_TIME_METHOD = MethodDescriptor.ofMethod((Object)StepTiming.class.getName(), (String)"printStepTime", Void.TYPE, (Object[])new Object[]{StartupContext.class});
    public static final MethodDescriptor CONFIGURE_STEP_TIME_ENABLED = MethodDescriptor.ofMethod((Object)StepTiming.class.getName(), (String)"configureEnabled", Void.TYPE, (Object[])new Object[0]);
    public static final MethodDescriptor CONFIGURE_STEP_TIME_START = MethodDescriptor.ofMethod((Object)StepTiming.class.getName(), (String)"configureStart", Void.TYPE, (Object[])new Object[0]);

    @BuildStep
    void build(List<StaticBytecodeRecorderBuildItem> staticInitTasks, List<ObjectSubstitutionBuildItem> substitutions, List<MainBytecodeRecorderBuildItem> mainMethod, List<SystemPropertyBuildItem> properties, List<JavaLibraryPathAdditionalPathBuildItem> javaLibraryPathAdditionalPaths, List<FeatureBuildItem> features, BuildProducer<ApplicationClassNameBuildItem> appClassNameProducer, List<BytecodeRecorderObjectLoaderBuildItem> loaders, List<RecordableConstructorBuildItem> recordableConstructorBuildItems, BuildProducer<GeneratedClassBuildItem> generatedClass, LaunchModeBuildItem launchMode, LiveReloadBuildItem liveReloadBuildItem, ApplicationInfoBuildItem applicationInfo, Optional<AppCDSRequestedBuildItem> appCDSRequested) {
        appClassNameProducer.produce(new ApplicationClassNameBuildItem("io.quarkus.runner.ApplicationImpl"));
        GeneratedClassGizmoAdaptor gizmoOutput = new GeneratedClassGizmoAdaptor(generatedClass, true);
        ClassCreator file = new ClassCreator((ClassOutput)gizmoOutput, "io.quarkus.runner.ApplicationImpl", null, Application.class.getName(), new String[0]);
        FieldCreator logField = (FieldCreator)file.getFieldCreator(LOG, Logger.class).setModifiers(8);
        FieldCreator scField = file.getFieldCreator(STARTUP_CONTEXT_FIELD);
        scField.setModifiers(9);
        MethodCreator ctor = file.getMethodCreator("<init>", Void.TYPE, new Class[0]);
        ctor.invokeSpecialMethod(MethodDescriptor.ofMethod(Application.class, (String)"<init>", Void.TYPE, (Class[])new Class[]{Boolean.TYPE}), ctor.getThis(), new ResultHandle[]{ctor.load(launchMode.isAuxiliaryApplication())});
        ctor.returnValue(null);
        MethodCreator mv = file.getMethodCreator("<clinit>", Void.TYPE, new Class[0]);
        mv.setModifiers(9);
        for (SystemPropertyBuildItem i : properties) {
            mv.invokeStaticMethod(MethodDescriptor.ofMethod(System.class, (String)"setProperty", String.class, (Class[])new Class[]{String.class, String.class}), new ResultHandle[]{mv.load(i.getKey()), mv.load(i.getValue())});
        }
        ResultHandle lm = mv.readStaticField(FieldDescriptor.of(LaunchMode.class, (String)launchMode.getLaunchMode().name(), LaunchMode.class));
        mv.invokeStaticMethod(MethodDescriptor.ofMethod(ProfileManager.class, (String)"setLaunchMode", Void.TYPE, (Class[])new Class[]{LaunchMode.class}), new ResultHandle[]{lm});
        mv.invokeStaticMethod(CONFIGURE_STEP_TIME_ENABLED, new ResultHandle[0]);
        mv.invokeStaticMethod(MethodDescriptor.ofMethod(Timing.class, (String)"staticInitStarted", Void.TYPE, (Class[])new Class[]{Boolean.TYPE}), new ResultHandle[]{mv.load(launchMode.isAuxiliaryApplication())});
        mv.invokeStaticMethod(RunTimeConfigurationGenerator.C_ENSURE_INITIALIZED, new ResultHandle[0]);
        if (liveReloadBuildItem.isLiveReload()) {
            mv.invokeStaticMethod(RunTimeConfigurationGenerator.REINIT, new ResultHandle[0]);
        }
        mv.writeStaticField(logField.getFieldDescriptor(), mv.invokeStaticMethod(MethodDescriptor.ofMethod(Logger.class, (String)"getLogger", Logger.class, (Class[])new Class[]{String.class}), new ResultHandle[]{mv.load("io.quarkus.application")}));
        ResultHandle startupContext = mv.newInstance(MethodDescriptor.ofConstructor(StartupContext.class, (Class[])new Class[0]), new ResultHandle[0]);
        mv.writeStaticField(scField.getFieldDescriptor(), startupContext);
        TryBlock tryBlock = mv.tryBlock();
        tryBlock.invokeStaticMethod(CONFIGURE_STEP_TIME_START, new ResultHandle[0]);
        for (StaticBytecodeRecorderBuildItem holder : staticInitTasks) {
            this.writeRecordedBytecode(holder.getBytecodeRecorder(), null, substitutions, recordableConstructorBuildItems, loaders, gizmoOutput, startupContext, (BytecodeCreator)tryBlock);
        }
        tryBlock.returnValue(null);
        CatchBlockCreator cb = tryBlock.addCatch(Throwable.class);
        cb.invokeStaticMethod(MethodDescriptor.ofMethod(ApplicationStateNotification.class, (String)"notifyStartupFailed", Void.TYPE, (Class[])new Class[]{Throwable.class}), new ResultHandle[]{cb.getCaughtException()});
        cb.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"close", Void.TYPE, (Class[])new Class[0]), startupContext, new ResultHandle[0]);
        cb.throwException(RuntimeException.class, "Failed to start quarkus", cb.getCaughtException());
        mv = file.getMethodCreator("doStart", Void.TYPE, new Class[]{String[].class});
        mv.setModifiers(20);
        if (appCDSRequested.isPresent()) {
            ResultHandle createAppCDsSysProp = mv.invokeStaticMethod(MethodDescriptor.ofMethod(System.class, (String)"getProperty", String.class, (Class[])new Class[]{String.class, String.class}), new ResultHandle[]{mv.load(GENERATE_APP_CDS_SYSTEM_PROPERTY), mv.load("false")});
            ResultHandle resultHandle = mv.invokeStaticMethod(MethodDescriptor.ofMethod(Boolean.class, (String)"parseBoolean", Boolean.TYPE, (Class[])new Class[]{String.class}), new ResultHandle[]{createAppCDsSysProp});
            BytecodeCreator bytecodeCreator = mv.ifTrue(resultHandle).trueBranch();
            bytecodeCreator.invokeStaticMethod(MethodDescriptor.ofMethod(AppCDSUtil.class, (String)"loadGeneratedClasses", Void.TYPE, (Class[])new Class[0]), new ResultHandle[0]);
            bytecodeCreator.invokeStaticMethod(MethodDescriptor.ofMethod(ApplicationLifecycleManager.class, (String)"exit", Void.TYPE, (Class[])new Class[0]), new ResultHandle[0]);
            bytecodeCreator.returnValue(null);
        }
        for (SystemPropertyBuildItem systemPropertyBuildItem : properties) {
            mv.invokeStaticMethod(MethodDescriptor.ofMethod(System.class, (String)"setProperty", String.class, (Class[])new Class[]{String.class, String.class}), new ResultHandle[]{mv.load(systemPropertyBuildItem.getKey()), mv.load(systemPropertyBuildItem.getValue())});
        }
        mv.invokeStaticMethod(MethodDescriptor.ofMethod(NativeImageRuntimePropertiesRecorder.class, (String)"doRuntime", Void.TYPE, (Class[])new Class[0]), new ResultHandle[0]);
        if (!javaLibraryPathAdditionalPaths.isEmpty()) {
            ResultHandle javaLibraryPath = mv.newInstance(MethodDescriptor.ofConstructor(StringBuilder.class, (Class[])new Class[]{String.class}), new ResultHandle[]{mv.invokeStaticMethod(MethodDescriptor.ofMethod(System.class, (String)"getProperty", String.class, (Class[])new Class[]{String.class}), new ResultHandle[]{mv.load(JAVA_LIBRARY_PATH)})});
            for (JavaLibraryPathAdditionalPathBuildItem javaLibraryPathAdditionalPathBuildItem : javaLibraryPathAdditionalPaths) {
                ResultHandle resultHandle = mv.invokeVirtualMethod(MethodDescriptor.ofMethod(StringBuilder.class, (String)"length", Integer.TYPE, (Class[])new Class[0]), javaLibraryPath, new ResultHandle[0]);
                mv.ifNonZero(resultHandle).trueBranch().invokeVirtualMethod(MethodDescriptor.ofMethod(StringBuilder.class, (String)"append", StringBuilder.class, (Class[])new Class[]{String.class}), javaLibraryPath, new ResultHandle[]{mv.load(File.pathSeparator)});
                mv.invokeVirtualMethod(MethodDescriptor.ofMethod(StringBuilder.class, (String)"append", StringBuilder.class, (Class[])new Class[]{String.class}), javaLibraryPath, new ResultHandle[]{mv.load(javaLibraryPathAdditionalPathBuildItem.getPath())});
            }
            mv.invokeStaticMethod(MethodDescriptor.ofMethod(System.class, (String)"setProperty", String.class, (Class[])new Class[]{String.class, String.class}), new ResultHandle[]{mv.load(JAVA_LIBRARY_PATH), mv.invokeVirtualMethod(MethodDescriptor.ofMethod(StringBuilder.class, (String)"toString", String.class, (Class[])new Class[0]), javaLibraryPath, new ResultHandle[0])});
        }
        BytecodeCreator inGraalVMCode = mv.ifNonZero(mv.invokeStaticMethod(MethodDescriptor.ofMethod(ImageInfo.class, (String)"inImageRuntimeCode", Boolean.TYPE, (Class[])new Class[0]), new ResultHandle[0])).trueBranch();
        mv.invokeStaticMethod(MethodDescriptor.ofMethod(Timing.class, (String)"mainStarted", Void.TYPE, (Class[])new Class[0]), new ResultHandle[0]);
        startupContext = mv.readStaticField(scField.getFieldDescriptor());
        mv.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"setCommandLineArguments", Void.TYPE, (Class[])new Class[]{String[].class}), startupContext, new ResultHandle[]{mv.getMethodParam(0)});
        mv.invokeStaticMethod(CONFIGURE_STEP_TIME_ENABLED, new ResultHandle[0]);
        ResultHandle resultHandle = mv.invokeStaticMethod(MethodDescriptor.ofMethod(ProfileManager.class, (String)"getActiveProfile", String.class, (Class[])new Class[0]), new ResultHandle[0]);
        tryBlock = mv.tryBlock();
        tryBlock.invokeStaticMethod(CONFIGURE_STEP_TIME_START, new ResultHandle[0]);
        for (MainBytecodeRecorderBuildItem mainBytecodeRecorderBuildItem : mainMethod) {
            this.writeRecordedBytecode(mainBytecodeRecorderBuildItem.getBytecodeRecorder(), mainBytecodeRecorderBuildItem.getGeneratedStartupContextClassName(), substitutions, recordableConstructorBuildItems, loaders, gizmoOutput, startupContext, (BytecodeCreator)tryBlock);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (FeatureBuildItem feature : features) {
            if (arrayList.contains(feature.getName())) {
                throw new IllegalStateException("Multiple extensions registered a feature of the same name: " + feature.getName());
            }
            arrayList.add(feature.getName());
        }
        ResultHandle resultHandle2 = tryBlock.load(arrayList.stream().sorted().collect(Collectors.joining(", ")));
        tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(Timing.class, (String)"printStartupTime", Void.TYPE, (Class[])new Class[]{String.class, String.class, String.class, String.class, String.class, Boolean.TYPE, Boolean.TYPE}), new ResultHandle[]{tryBlock.load(applicationInfo.getName()), tryBlock.load(applicationInfo.getVersion()), tryBlock.load(Version.getVersion()), resultHandle2, resultHandle, tryBlock.load(LaunchMode.DEVELOPMENT.equals((Object)launchMode.getLaunchMode())), tryBlock.load(launchMode.isAuxiliaryApplication())});
        tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(QuarkusConsole.class, (String)"start", Void.TYPE, (Class[])new Class[0]), new ResultHandle[0]);
        cb = tryBlock.addCatch(Throwable.class);
        if (launchMode.getLaunchMode() != LaunchMode.DEVELOPMENT) {
            ResultHandle delayedHandler = cb.readStaticField(FieldDescriptor.of(InitialConfigurator.class, (String)"DELAYED_HANDLER", QuarkusDelayedHandler.class));
            ResultHandle isActivated = cb.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusDelayedHandler.class, (String)"isActivated", Boolean.TYPE, (Class[])new Class[0]), delayedHandler, new ResultHandle[0]);
            BytecodeCreator isActivatedFalse = cb.ifNonZero(isActivated).falseBranch();
            ResultHandle handlersArray = isActivatedFalse.newArray(Handler.class, 1);
            isActivatedFalse.writeArrayValue(handlersArray, 0, isActivatedFalse.newInstance(MethodDescriptor.ofConstructor(ConsoleHandler.class, (Class[])new Class[0]), new ResultHandle[0]));
            isActivatedFalse.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusDelayedHandler.class, (String)"setHandlers", Handler[].class, (Class[])new Class[]{Handler[].class}), delayedHandler, new ResultHandle[]{handlersArray});
            isActivatedFalse.breakScope();
        }
        cb.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"close", Void.TYPE, (Class[])new Class[0]), startupContext, new ResultHandle[0]);
        cb.throwException(RuntimeException.class, "Failed to start quarkus", cb.getCaughtException());
        mv.returnValue(null);
        mv = file.getMethodCreator("doStop", Void.TYPE, new Class[0]);
        mv.setModifiers(20);
        startupContext = mv.readStaticField(scField.getFieldDescriptor());
        mv.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"close", Void.TYPE, (Class[])new Class[0]), startupContext, new ResultHandle[0]);
        mv.returnValue(null);
        mv = file.getMethodCreator("getName", String.class, new Class[0]);
        mv.returnValue(mv.load(applicationInfo.getName()));
        file.close();
    }

    @BuildStep
    public MainClassBuildItem mainClassBuildStep(BuildProducer<GeneratedClassBuildItem> generatedClass, ApplicationArchivesBuildItem applicationArchivesBuildItem, CombinedIndexBuildItem combinedIndexBuildItem, Optional<QuarkusApplicationClassBuildItem> quarkusApplicationClass, PackageConfig packageConfig) {
        String mainClassName = MAIN_CLASS;
        HashMap<String, String> quarkusMainAnnotations = new HashMap<String, String>();
        Collection quarkusMains = combinedIndexBuildItem.getIndex().getAnnotations(DotName.createSimple((String)QuarkusMain.class.getName()));
        for (AnnotationInstance i : quarkusMains) {
            AnnotationValue nameValue = i.value("name");
            String name = "";
            if (nameValue != null) {
                name = nameValue.asString();
            }
            if (quarkusMainAnnotations.containsKey(name)) {
                throw new RuntimeException("More than one @QuarkusMain method found with name '" + name + "': " + i.target().asClass().name() + " and " + (String)quarkusMainAnnotations.get(name));
            }
            quarkusMainAnnotations.put(name, i.target().asClass().name().toString());
        }
        if (packageConfig.mainClass.isPresent()) {
            String mainAnnotationClass = (String)quarkusMainAnnotations.get(packageConfig.mainClass.get());
            mainClassName = mainAnnotationClass != null ? mainAnnotationClass : packageConfig.mainClass.get();
        } else if (quarkusMainAnnotations.containsKey("")) {
            mainClassName = (String)quarkusMainAnnotations.get("");
        }
        if (mainClassName.equals(MAIN_CLASS)) {
            if (quarkusApplicationClass.isPresent()) {
                this.generateMainForQuarkusApplication(quarkusApplicationClass.get().getClassName(), generatedClass);
            } else {
                ClassCreator file = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClass, true), MAIN_CLASS, null, Object.class.getName(), new String[0]);
                MethodCreator mv = file.getMethodCreator("main", Void.TYPE, new Class[]{String[].class});
                mv.setModifiers(9);
                mv.invokeStaticMethod(MethodDescriptor.ofMethod(Quarkus.class, (String)"run", Void.TYPE, (Class[])new Class[]{String[].class}), new ResultHandle[]{mv.getMethodParam(0)});
                mv.returnValue(null);
                file.close();
            }
        } else {
            Collection impls = combinedIndexBuildItem.getIndex().getAllKnownImplementors(DotName.createSimple((String)QuarkusApplication.class.getName()));
            ClassInfo classByName = combinedIndexBuildItem.getIndex().getClassByName(DotName.createSimple((String)mainClassName));
            MethodInfo mainClassMethod = null;
            if (classByName != null) {
                mainClassMethod = classByName.method("main", new Type[]{Type.create((DotName)DotName.createSimple((String)String[].class.getName()), (Type.Kind)Type.Kind.ARRAY)});
            }
            if (mainClassMethod == null) {
                boolean found = false;
                for (ClassInfo i : impls) {
                    if (!i.name().toString().equals(mainClassName)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    this.generateMainForQuarkusApplication(mainClassName, generatedClass);
                    mainClassName = MAIN_CLASS;
                } else {
                    ClassInfo classInfo = combinedIndexBuildItem.getIndex().getClassByName(DotName.createSimple((String)mainClassName));
                    if (classInfo == null) {
                        throw new IllegalArgumentException("The supplied 'main-class' value of '" + mainClassName + "' does not correspond to either a fully qualified class name or a matching 'name' field of one of the '@QuarkusMain' annotations");
                    }
                }
            }
        }
        return new MainClassBuildItem(mainClassName);
    }

    private void generateMainForQuarkusApplication(String quarkusApplicationClassName, BuildProducer<GeneratedClassBuildItem> generatedClass) {
        ClassCreator file = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClass, true), MAIN_CLASS, null, Object.class.getName(), new String[0]);
        MethodCreator mv = file.getMethodCreator("main", Void.TYPE, new Class[]{String[].class});
        mv.setModifiers(9);
        mv.invokeStaticMethod(MethodDescriptor.ofMethod(Quarkus.class, (String)"run", Void.TYPE, (Class[])new Class[]{Class.class, String[].class}), new ResultHandle[]{mv.loadClass(quarkusApplicationClassName), mv.getMethodParam(0)});
        mv.returnValue(null);
        file.close();
    }

    private void writeRecordedBytecode(BytecodeRecorderImpl recorder, String fallbackGeneratedStartupTaskClassName, List<ObjectSubstitutionBuildItem> substitutions, List<RecordableConstructorBuildItem> recordableConstructorBuildItems, List<BytecodeRecorderObjectLoaderBuildItem> loaders, GeneratedClassGizmoAdaptor gizmoOutput, ResultHandle startupContext, BytecodeCreator bytecodeCreator) {
        if ((recorder == null || recorder.isEmpty()) && fallbackGeneratedStartupTaskClassName == null) {
            return;
        }
        if (recorder != null && !recorder.isEmpty()) {
            for (ObjectSubstitutionBuildItem objectSubstitutionBuildItem : substitutions) {
                ObjectSubstitutionBuildItem.Holder<?, ?> holder1 = objectSubstitutionBuildItem.holder;
                recorder.registerSubstitution(holder1.from, holder1.to, holder1.substitution);
            }
            for (BytecodeRecorderObjectLoaderBuildItem bytecodeRecorderObjectLoaderBuildItem : loaders) {
                recorder.registerObjectLoader(bytecodeRecorderObjectLoaderBuildItem.getObjectLoader());
            }
            for (RecordableConstructorBuildItem recordableConstructorBuildItem : recordableConstructorBuildItems) {
                recorder.markClassAsConstructorRecordable(recordableConstructorBuildItem.getClazz());
            }
            recorder.writeBytecode(gizmoOutput);
        }
        ResultHandle dup = bytecodeCreator.newInstance(MethodDescriptor.ofConstructor((String)(recorder != null ? recorder.getClassName() : fallbackGeneratedStartupTaskClassName), (String[])new String[0]), new ResultHandle[0]);
        bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(StartupTask.class, (String)"deploy", Void.TYPE, (Class[])new Class[]{StartupContext.class}), dup, new ResultHandle[]{startupContext});
        bytecodeCreator.invokeStaticMethod(PRINT_STEP_TIME_METHOD, new ResultHandle[]{startupContext});
    }

    @BuildStep
    ReflectiveClassBuildItem applicationReflection() {
        return new ReflectiveClassBuildItem(false, false, "io.quarkus.runner.ApplicationImpl");
    }
}

