/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem;

import io.quarkus.builder.item.SimpleBuildItem;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.logging.Logger;

public final class QuarkusBuildCloseablesBuildItem
extends SimpleBuildItem
implements Closeable {
    private static final Logger log = Logger.getLogger(QuarkusBuildCloseablesBuildItem.class);
    private final List<Closeable> closeables = Collections.synchronizedList(new ArrayList());

    public <T extends Closeable> T add(T closeable) {
        this.closeables.add(closeable);
        return closeable;
    }

    @Override
    public void close() {
        for (Closeable c : this.closeables) {
            try {
                c.close();
            }
            catch (Throwable e) {
                log.debugf(e, "Failed to close %s", (Object)c);
            }
        }
    }
}

