/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.extensions;

import io.quarkus.bootstrap.model.AppArtifactCoords;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.dependencies.Extension;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.model.Dependency;

public final class Extensions {
    private Extensions() {
    }

    public static AppArtifactKey toKey(Extension extension) {
        return Extensions.toKey(extension.toDependency(false));
    }

    public static AppArtifactKey toKey(Dependency dependency) {
        return new AppArtifactKey(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getType());
    }

    public static Optional<Extension> findInList(List<Extension> list, AppArtifactKey key) {
        return list.stream().filter(e -> Objects.equals(Extensions.toCoords(e).getKey(), key)).findFirst();
    }

    public static AppArtifactCoords toCoords(AppArtifactKey k, String version) {
        return new AppArtifactCoords(k, version);
    }

    public static AppArtifactCoords toCoords(Extension e) {
        return Extensions.toCoords(e.toDependency(false));
    }

    public static AppArtifactCoords toCoords(Dependency d, String overrideVersion) {
        return Extensions.overrideVersion(Extensions.toCoords(d), overrideVersion);
    }

    public static String toGAV(AppArtifactCoords c) {
        if (c.getVersion() == null) {
            return Extensions.toGA(c);
        }
        return c.getGroupId() + ":" + c.getArtifactId() + ":" + c.getVersion();
    }

    public static String toGA(AppArtifactCoords c) {
        return c.getGroupId() + ":" + c.getArtifactId();
    }

    public static String toGA(AppArtifactKey c) {
        return c.getGroupId() + ":" + c.getArtifactId();
    }

    public static String toGA(Extension e) {
        return e.getGroupId() + ":" + e.getArtifactId();
    }

    public static AppArtifactCoords stripVersion(AppArtifactCoords coords) {
        return Extensions.overrideVersion(coords, null);
    }

    public static AppArtifactCoords overrideVersion(AppArtifactCoords coords, String overrideVersion) {
        return new AppArtifactCoords(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType(), overrideVersion);
    }

    public static AppArtifactCoords toCoords(Dependency d) {
        return new AppArtifactCoords(d.getGroupId(), d.getArtifactId(), d.getClassifier(), d.getType(), d.getVersion());
    }
}

