/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.platform.catalog.processor;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

final class MetadataValue {
    private static final MetadataValue EMPTY_METADATA_VALUE = new MetadataValue(null);
    private final Object val;

    public MetadataValue(Object val) {
        this.val = val;
    }

    public static MetadataValue get(Map<String, Object> data, String path) {
        Map<String, Object> safeData;
        Map<String, Object> map = safeData = data != null ? data : Collections.emptyMap();
        if (!path.contains(".")) {
            return new MetadataValue(safeData.get(path));
        }
        int index = path.indexOf(".");
        String key = path.substring(0, index);
        if (safeData.get(key) instanceof Map) {
            return MetadataValue.get((Map)safeData.get(key), path.substring(index + 1));
        }
        return EMPTY_METADATA_VALUE;
    }

    public boolean isEmpty() {
        return this.val == null;
    }

    public String asString() {
        if (this.val instanceof String) {
            return (String)this.val;
        }
        return null;
    }

    public List<String> asStringList() {
        if (this.val instanceof String) {
            return Collections.singletonList((String)this.val);
        }
        if (this.val instanceof List && !((List)this.val).isEmpty() && ((List)this.val).get(0) instanceof String) {
            return (List)this.val;
        }
        return Collections.emptyList();
    }

    public boolean asBoolean() {
        if (this.val == null) {
            return false;
        }
        if (this.val instanceof Boolean) {
            return (Boolean)this.val;
        }
        if (this.val instanceof String) {
            return Boolean.parseBoolean((String)this.val);
        }
        return false;
    }

    public <T extends Enum<T>> T toEnum(Class<T> clazz) {
        return this.toEnum(clazz, null);
    }

    public <T extends Enum<T>> T toEnum(Class<T> clazz, T defaultValue) {
        String name = this.asString();
        if (name == null) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(clazz, name.toUpperCase(Locale.ROOT).replace('-', '_'));
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }
}

