/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.platform.tools;

import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.maven.dependency.GACTV;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.json.JsonCatalogMapperHelper;
import io.quarkus.registry.catalog.json.JsonCatalogMerger;
import io.quarkus.registry.catalog.json.JsonExtensionCatalog;
import io.quarkus.registry.catalog.selection.OriginPreference;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class ToolsUtils {
    public static String requireProperty(String name) {
        String value = ToolsUtils.getProperty(name);
        if (value == null) {
            throw new IllegalStateException("Failed to resolve required property " + name);
        }
        return value;
    }

    public static String getProperty(String name) {
        return ToolsUtils.getProperty(name, null);
    }

    public static String getProperty(String name, String defaultValue) {
        return System.getProperty(name, defaultValue);
    }

    public static Map<String, String> stringToMap(String str, String entrySeparator, String keyValueSeparator) {
        HashMap<String, String> result = new HashMap<String, String>();
        block4: for (String entry : StringUtils.splitByWholeSeparator((String)str, (String)entrySeparator)) {
            String[] pair = StringUtils.splitByWholeSeparator((String)entry, (String)keyValueSeparator, (int)2);
            if (pair.length > 0 && StringUtils.isBlank((CharSequence)pair[0])) {
                throw new IllegalArgumentException("Entry with empty key " + entry);
            }
            switch (pair.length) {
                case 1: {
                    result.put(pair[0].trim(), "");
                    continue block4;
                }
                case 2: {
                    result.put(pair[0].trim(), pair[1].trim());
                }
            }
        }
        return result;
    }

    public static boolean isNullOrEmpty(String arg) {
        return arg == null || arg.isEmpty();
    }

    public static String dotJoin(String ... parts) {
        if (parts.length == 0) {
            return null;
        }
        if (parts.length == 1) {
            return parts[0];
        }
        StringBuilder buf = new StringBuilder();
        buf.append(parts[0]);
        int i = 1;
        while (i < parts.length) {
            buf.append('.').append(parts[i++]);
        }
        return buf.toString();
    }

    public static ExtensionCatalog resolvePlatformDescriptorDirectly(String bomGroupId, String bomArtifactId, String bomVersion, MavenArtifactResolver artifactResolver, MessageWriter log) {
        Object members;
        Object o;
        ExtensionCatalog catalog;
        Path platformJson;
        DefaultArtifact catalogCoords;
        block14: {
            if (bomVersion == null) {
                throw new IllegalArgumentException("BOM version was not provided");
            }
            catalogCoords = new DefaultArtifact(bomGroupId == null ? "io.quarkus.platform" : bomGroupId, (bomArtifactId == null ? "quarkus-bom" : bomArtifactId) + "-quarkus-platform-descriptor", bomVersion, "json", bomVersion);
            platformJson = null;
            try {
                log.debug("Resolving platform descriptor %s", new Object[]{catalogCoords});
                platformJson = artifactResolver.resolve((Artifact)catalogCoords).getArtifact().getFile().toPath();
            }
            catch (Exception e) {
                if (bomGroupId == null && catalogCoords.getArtifactId().startsWith("quarkus-bom")) {
                    catalogCoords = new DefaultArtifact("io.quarkus", "quarkus-bom-quarkus-platform-descriptor", catalogCoords.getClassifier(), catalogCoords.getExtension(), catalogCoords.getVersion());
                    try {
                        log.debug("Resolving platform descriptor %s", new Object[]{catalogCoords});
                        platformJson = artifactResolver.resolve((Artifact)catalogCoords).getArtifact().getFile().toPath();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (platformJson != null) break block14;
                throw new RuntimeException("Failed to resolve the default platform JSON descriptor", e);
            }
        }
        try {
            catalog = (ExtensionCatalog)JsonCatalogMapperHelper.deserialize(platformJson, JsonExtensionCatalog.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to deserialize extension catalog " + platformJson, e);
        }
        Map md = catalog.getMetadata();
        if (md != null && (o = md.get("platform-release")) instanceof Map && (members = ((Map)o).get("members")) instanceof Collection) {
            Collection memberList = (Collection)members;
            ArrayList<ExtensionCatalog> catalogs = new ArrayList<ExtensionCatalog>(memberList.size());
            int memberIndex = 0;
            for (Object m : memberList) {
                ExtensionCatalog memberCatalog;
                if (!(m instanceof String)) continue;
                if (catalog.getId().equals(m)) {
                    memberCatalog = catalog;
                } else {
                    try {
                        ArtifactCoords coords = ArtifactCoords.fromString((String)((String)m));
                        catalogCoords = new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType(), coords.getVersion());
                        log.debug("Resolving platform descriptor %s", new Object[]{catalogCoords});
                        Path jsonPath = artifactResolver.resolve((Artifact)catalogCoords).getArtifact().getFile().toPath();
                        memberCatalog = (ExtensionCatalog)JsonCatalogMapperHelper.deserialize((Path)jsonPath, JsonExtensionCatalog.class);
                    }
                    catch (Exception e) {
                        log.warn("Failed to resolve member catalog " + m, new Object[]{e});
                        continue;
                    }
                }
                OriginPreference originPreference = new OriginPreference(1, 1, 1, ++memberIndex, 1);
                HashMap<String, OriginPreference> metadata = new HashMap<String, OriginPreference>(memberCatalog.getMetadata());
                metadata.put("origin-preference", originPreference);
                ((JsonExtensionCatalog)memberCatalog).setMetadata(metadata);
                catalogs.add(memberCatalog);
            }
            catalog = JsonCatalogMerger.merge(catalogs);
        }
        return catalog;
    }

    public static ExtensionCatalog mergePlatforms(List<ArtifactCoords> platforms, MavenArtifactResolver artifactResolver) {
        return ToolsUtils.mergePlatforms(platforms, (AppModelResolver)new BootstrapAppModelResolver(artifactResolver));
    }

    public static ExtensionCatalog mergePlatforms(List<ArtifactCoords> platforms, AppModelResolver artifactResolver) {
        ArrayList<ExtensionCatalog> catalogs = new ArrayList<ExtensionCatalog>(platforms.size());
        for (ArtifactCoords platform : platforms) {
            Path json;
            try {
                json = artifactResolver.resolve((io.quarkus.maven.dependency.ArtifactCoords)new GACTV(platform.getGroupId(), platform.getArtifactId(), platform.getClassifier(), platform.getType(), platform.getVersion())).getResolvedPaths().getSinglePath();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to resolve platform descriptor " + platform, e);
            }
            try {
                catalogs.add((ExtensionCatalog)JsonCatalogMapperHelper.deserialize((Path)json, JsonExtensionCatalog.class));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to deserialize platform descriptor " + json, e);
            }
        }
        return JsonCatalogMerger.merge(catalogs);
    }

    public static Properties readQuarkusProperties(ExtensionCatalog catalog) {
        Map map = catalog.getMetadata().getOrDefault("project", Collections.emptyMap());
        map = map.getOrDefault("properties", Collections.emptyMap());
        Properties properties = new Properties();
        map.entrySet().forEach(e -> properties.setProperty(e.getKey().toString(), e.getValue() == null ? null : e.getValue().toString()));
        return properties;
    }

    public static String requireProperty(Properties props, String name) {
        String value = props.getProperty(name);
        if (value == null) {
            throw new IllegalStateException("Failed to resolve required property " + name);
        }
        return value;
    }

    public static String getMavenPluginArtifactId(Properties props) {
        return props.getProperty("maven-plugin-artifactId");
    }

    public static String getMavenPluginGroupId(Properties props) {
        return props.getProperty("maven-plugin-groupId");
    }

    public static String getQuarkusCoreVersion(Properties props) {
        return props.getProperty("quarkus-core-version");
    }

    public static String requireQuarkusCoreVersion(Properties props) {
        return ToolsUtils.requireProperty(props, "quarkus-core-version");
    }

    public static String getMavenPluginVersion(Properties props) {
        return props.getProperty("maven-plugin-version");
    }

    public static String getGradlePluginVersion(Properties props) {
        return props.getProperty("gradle-plugin-version");
    }

    public static String getPluginKey(Properties props) {
        return ToolsUtils.getMavenPluginGroupId(props) + ":" + ToolsUtils.getMavenPluginArtifactId(props);
    }

    public static String getProposedMavenVersion(Properties props) {
        return props.getProperty("proposed-maven-version");
    }

    public static String getMavenWrapperVersion(Properties props) {
        return props.getProperty("maven-wrapper-version");
    }

    public static String getGradleWrapperVersion(Properties props) {
        return props.getProperty("gradle-wrapper-version");
    }
}

