/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands.handlers;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.ProjectInfoCommandHandler;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandler;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.devtools.project.state.ExtensionProvider;
import io.quarkus.devtools.project.state.ModuleState;
import io.quarkus.devtools.project.state.ProjectState;
import io.quarkus.devtools.project.state.TopExtensionDependency;
import io.quarkus.devtools.project.update.QuarkusUpdateCommand;
import io.quarkus.devtools.project.update.QuarkusUpdateException;
import io.quarkus.devtools.project.update.QuarkusUpdates;
import io.quarkus.devtools.project.update.QuarkusUpdatesRepository;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.ExtensionOrigin;
import io.quarkus.registry.catalog.selection.ExtensionOrigins;
import io.quarkus.registry.catalog.selection.OriginCombination;
import io.quarkus.registry.catalog.selection.OriginPreference;
import io.quarkus.registry.catalog.selection.OriginSelector;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class UpdateProjectCommandHandler
implements QuarkusCommandHandler {
    public static final String ADD = "Add:";
    public static final String REMOVE = "Remove:";
    public static final String UPDATE = "Update:";
    public static final String ITEM_FORMAT = "%-7s %s";

    @Override
    public QuarkusCommandOutcome execute(QuarkusCommandInvocation invocation) throws QuarkusCommandException {
        ApplicationModel appModel = (ApplicationModel)invocation.getValue("quarkus.update-project.app-model");
        ExtensionCatalog targetCatalog = (ExtensionCatalog)invocation.getValue("quarkus.update-project.target-catalog");
        String targetPlatformVersion = (String)invocation.getValue("quarkus.update-project.target-platform-version");
        boolean perModule = invocation.getValue("quarkus.update-project.per-module", false);
        ProjectState currentState = ProjectInfoCommandHandler.resolveProjectState(appModel, invocation.getQuarkusProject().getExtensionsCatalog());
        ArtifactCoords projectQuarkusPlatformBom = UpdateProjectCommandHandler.getProjectQuarkusPlatformBOM(currentState);
        if (projectQuarkusPlatformBom == null) {
            invocation.log().error("The project does not import any Quarkus platform BOM");
            return QuarkusCommandOutcome.failure();
        }
        if (Objects.equals(projectQuarkusPlatformBom.getVersion(), targetPlatformVersion)) {
            ProjectInfoCommandHandler.logState(currentState, perModule, true, invocation.getQuarkusProject().log());
        } else {
            invocation.log().info("Instructions to update this project from '%s' to '%s':", new Object[]{projectQuarkusPlatformBom.getVersion(), targetPlatformVersion});
            QuarkusProject quarkusProject = invocation.getQuarkusProject();
            UpdateProjectCommandHandler.logUpdates(currentState, targetCatalog, false, perModule, quarkusProject.log());
            boolean noRewrite = invocation.getValue("quarkus.update-project.rewrite.disabled", false);
            if (!noRewrite) {
                BuildTool buildTool = quarkusProject.getExtensionManager().getBuildTool();
                String kotlinVersion = (String)this.getMetadata(targetCatalog, "project", "properties", "kotlin-version");
                QuarkusUpdates.ProjectUpdateRequest request = new QuarkusUpdates.ProjectUpdateRequest(buildTool, projectQuarkusPlatformBom.getVersion(), targetPlatformVersion, kotlinVersion);
                Path recipe = null;
                try {
                    recipe = Files.createTempFile("quarkus-project-recipe-", ".yaml", new FileAttribute[0]);
                    String updateRecipesVersion = invocation.getValue("quarkus.update-project.rewrite.update-recipes-version", "LATEST");
                    QuarkusUpdatesRepository.FetchResult fetchResult = QuarkusUpdates.createRecipe(invocation.log(), recipe, QuarkusProjectHelper.artifactResolver(), buildTool, updateRecipesVersion, request);
                    String rewritePluginVersion = invocation.getValue("quarkus.update-project.rewrite.plugin-version", fetchResult.getRewritePluginVersion());
                    boolean rewriteDryRun = invocation.getValue("quarkus.update-project.rewrite.dry-run", false);
                    invocation.log().warn("The update feature does not yet handle updates of the extension versions. If needed, update your extensions manually.");
                    QuarkusUpdateCommand.handle(invocation.log(), buildTool, quarkusProject.getProjectDirPath(), rewritePluginVersion, fetchResult.getRecipesGAV(), recipe, rewriteDryRun);
                }
                catch (IOException e) {
                    throw new QuarkusCommandException("Error while generating the project update script", e);
                }
                catch (QuarkusUpdateException e) {
                    throw new QuarkusCommandException("Error while running the project update script", e);
                }
                finally {
                    if (recipe != null) {
                        try {
                            Files.deleteIfExists(recipe);
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        return QuarkusCommandOutcome.success();
    }

    private static ArtifactCoords getProjectQuarkusPlatformBOM(ProjectState currentState) {
        for (ArtifactCoords c : currentState.getPlatformBoms()) {
            if (!c.getArtifactId().equals("quarkus-bom")) continue;
            return c;
        }
        return null;
    }

    private static void logUpdates(ProjectState currentState, ExtensionCatalog recommendedCatalog, boolean recommendState, boolean perModule, MessageWriter log) {
        boolean platformUpdatesAvailable;
        if (currentState.getPlatformBoms().isEmpty()) {
            log.info("The project does not import any Quarkus platform BOM");
            return;
        }
        if (currentState.getExtensions().isEmpty()) {
            log.info("Quarkus extension were not found among the project dependencies");
            return;
        }
        ProjectState recommendedState = UpdateProjectCommandHandler.resolveRecommendedState(currentState, recommendedCatalog, log);
        if (currentState == recommendedState) {
            log.info("The project is up-to-date");
            return;
        }
        if (recommendState) {
            ProjectInfoCommandHandler.logState(recommendedState, perModule, false, log);
            return;
        }
        LinkedHashMap<ArtifactKey, Object> platformImports = new LinkedHashMap<ArtifactKey, Object>();
        for (ArtifactCoords c : currentState.getPlatformBoms()) {
            ProjectInfoCommandHandler.PlatformInfo info = new ProjectInfoCommandHandler.PlatformInfo();
            info.imported = c;
            platformImports.put(c.getKey(), info);
        }
        ArrayList<ProjectInfoCommandHandler.PlatformInfo> importVersionUpdates = new ArrayList<ProjectInfoCommandHandler.PlatformInfo>();
        ArrayList<ProjectInfoCommandHandler.PlatformInfo> newImports = new ArrayList<ProjectInfoCommandHandler.PlatformInfo>(0);
        for (ArtifactCoords c : recommendedState.getPlatformBoms()) {
            Iterator<Object> importInfo = platformImports.computeIfAbsent(c.getKey(), k -> new ProjectInfoCommandHandler.PlatformInfo());
            ((ProjectInfoCommandHandler.PlatformInfo)((Object)importInfo)).recommended = c;
            if (((ProjectInfoCommandHandler.PlatformInfo)((Object)importInfo)).isToBeImported()) {
                newImports.add((ProjectInfoCommandHandler.PlatformInfo)((Object)importInfo));
                continue;
            }
            if (!((ProjectInfoCommandHandler.PlatformInfo)((Object)importInfo)).isVersionUpdateRecommended()) continue;
            importVersionUpdates.add((ProjectInfoCommandHandler.PlatformInfo)((Object)importInfo));
        }
        log.info("");
        boolean importsToBeRemoved = platformImports.values().stream().filter(p -> p.recommended == null).findFirst().isPresent();
        boolean bl = platformUpdatesAvailable = !importVersionUpdates.isEmpty() || !newImports.isEmpty() || importsToBeRemoved;
        if (platformUpdatesAvailable) {
            log.info("Recommended Quarkus platform BOM updates:");
            if (!importVersionUpdates.isEmpty()) {
                for (ProjectInfoCommandHandler.PlatformInfo platformInfo : importVersionUpdates) {
                    log.info(String.format(ITEM_FORMAT, UPDATE, platformInfo.imported.toCompactCoords()) + " -> " + platformInfo.getRecommendedVersion());
                }
            }
            if (!newImports.isEmpty()) {
                for (ProjectInfoCommandHandler.PlatformInfo platformInfo : newImports) {
                    log.info(String.format(ITEM_FORMAT, ADD, platformInfo.recommended.toCompactCoords()));
                }
            }
            if (importsToBeRemoved) {
                for (ProjectInfoCommandHandler.PlatformInfo platformInfo : platformImports.values()) {
                    if (platformInfo.recommended != null) continue;
                    log.info(String.format(ITEM_FORMAT, REMOVE, platformInfo.imported.toCompactCoords()));
                }
            }
            log.info("");
        }
        ExtensionMap extensionInfo = new ExtensionMap(currentState.getExtensions().size());
        for (TopExtensionDependency dep : currentState.getExtensions()) {
            extensionInfo.add(new ExtensionInfo(dep));
        }
        for (TopExtensionDependency dep : recommendedState.getExtensions()) {
            ExtensionInfo info = extensionInfo.get(dep.getKey());
            if (info == null) continue;
            info.recommendedDep = dep;
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap(0);
        LinkedHashMap removedExtensions = new LinkedHashMap(0);
        LinkedHashMap addedExtensions = new LinkedHashMap(0);
        LinkedHashMap<String, List> nonPlatformExtensionUpdates = new LinkedHashMap<String, List>();
        for (ExtensionInfo extensionInfo2 : extensionInfo.values()) {
            if (!extensionInfo2.isUpdateRecommended()) continue;
            if (!extensionInfo2.currentDep.getKey().equals(extensionInfo2.getRecommendedDependency().getKey())) {
                if (extensionInfo2.currentDep.isPlatformExtension()) {
                    removedExtensions.computeIfAbsent(extensionInfo2.currentDep.getProviderKey(), k -> new ArrayList()).add(extensionInfo2.currentDep.getArtifact());
                } else {
                    nonPlatformExtensionUpdates.computeIfAbsent(extensionInfo2.currentDep.getProviderKey(), k -> new ArrayList()).add(extensionInfo2);
                }
                if (extensionInfo2.getRecommendedDependency().isPlatformExtension()) {
                    addedExtensions.computeIfAbsent(extensionInfo2.getRecommendedDependency().getProviderKey(), k -> new ArrayList()).add(extensionInfo2.getRecommendedDependency().getArtifact());
                    continue;
                }
                nonPlatformExtensionUpdates.computeIfAbsent(extensionInfo2.getRecommendedDependency().getProviderKey(), k -> new ArrayList()).add(extensionInfo2);
                continue;
            }
            if (extensionInfo2.getRecommendedDependency().isPlatformExtension()) {
                if (!extensionInfo2.currentDep.isNonRecommendedVersion()) continue;
                linkedHashMap.computeIfAbsent(extensionInfo2.getRecommendedDependency().getProviderKey(), k -> new ArrayList()).add(extensionInfo2);
                continue;
            }
            if (extensionInfo2.currentDep.getVersion().equals(extensionInfo2.getRecommendedDependency().getVersion())) continue;
            nonPlatformExtensionUpdates.computeIfAbsent(extensionInfo2.getRecommendedDependency().getProviderKey(), k -> new ArrayList()).add(extensionInfo2);
        }
        if (linkedHashMap.isEmpty() && removedExtensions.isEmpty() && addedExtensions.isEmpty() && nonPlatformExtensionUpdates.isEmpty()) {
            if (!platformUpdatesAvailable) {
                log.info("The project is up-to-date");
            }
            return;
        }
        for (ProjectInfoCommandHandler.PlatformInfo platformInfo : platformImports.values()) {
            String provider = platformInfo.getRecommendedProviderKey();
            if (!linkedHashMap.containsKey(provider) && !removedExtensions.containsKey(provider) && !addedExtensions.containsKey(provider)) continue;
            log.info("Extensions from " + platformInfo.getRecommendedProviderKey() + ":");
            for (ExtensionInfo e : linkedHashMap.getOrDefault(provider, Collections.emptyList())) {
                StringBuilder sb = new StringBuilder();
                sb.append(String.format(ITEM_FORMAT, UPDATE, e.currentDep.getArtifact().toCompactCoords()));
                sb.append(" -> remove version (managed)");
                log.info(sb.toString());
            }
            for (ExtensionInfo e : addedExtensions.getOrDefault(provider, Collections.emptyList())) {
                log.info(String.format(ITEM_FORMAT, ADD, e.getKey().toGacString()));
            }
            for (ExtensionInfo e : removedExtensions.getOrDefault(provider, Collections.emptyList())) {
                log.info(String.format(ITEM_FORMAT, REMOVE, e.getKey().toGacString()));
            }
            log.info("");
        }
        if (!nonPlatformExtensionUpdates.isEmpty()) {
            for (Map.Entry entry : nonPlatformExtensionUpdates.entrySet()) {
                log.info("Extensions from " + (String)entry.getKey() + ":");
                for (ExtensionInfo info : (List)entry.getValue()) {
                    if (info.currentDep.isPlatformExtension()) {
                        log.info(String.format(ITEM_FORMAT, ADD, info.getRecommendedDependency().getArtifact().toCompactCoords()));
                        continue;
                    }
                    if (info.getRecommendedDependency().isPlatformExtension()) {
                        log.info(String.format(ITEM_FORMAT, REMOVE, info.currentDep.getArtifact().toCompactCoords()));
                        continue;
                    }
                    log.info(String.format(ITEM_FORMAT, UPDATE, info.currentDep.getArtifact().toCompactCoords() + " -> " + info.getRecommendedDependency().getVersion()));
                }
                log.info("");
            }
        }
    }

    private static ProjectState resolveRecommendedState(ProjectState currentState, ExtensionCatalog latestCatalog, MessageWriter log) {
        List<ExtensionCatalog> recommendedOrigins;
        if (currentState.getPlatformBoms().isEmpty()) {
            return currentState;
        }
        if (currentState.getExtensions().isEmpty()) {
            return currentState;
        }
        ExtensionMap extensionInfo = new ExtensionMap();
        for (TopExtensionDependency dep : currentState.getExtensions()) {
            extensionInfo.add(new ExtensionInfo(dep));
        }
        for (Extension e2 : latestCatalog.getExtensions()) {
            ExtensionInfo candidate = extensionInfo.get(e2.getArtifact().getKey());
            if (candidate == null || candidate.latestMetadata != null) continue;
            candidate.latestMetadata = e2;
        }
        ArrayList<ExtensionInfo> unknownExtensions = new ArrayList<ExtensionInfo>(0);
        ArrayList<Extension> updateCandidates = new ArrayList<Extension>(extensionInfo.size());
        HashMap<String, ExtensionMap> updateCandidatesByOrigin = new HashMap<String, ExtensionMap>();
        for (ExtensionInfo i : extensionInfo.values()) {
            if (i.latestMetadata == null) {
                unknownExtensions.add(i);
                continue;
            }
            updateCandidates.add(i.latestMetadata);
            for (ExtensionOrigin extensionOrigin : i.latestMetadata.getOrigins()) {
                updateCandidatesByOrigin.computeIfAbsent(extensionOrigin.getId(), k -> new ExtensionMap()).add(i);
            }
        }
        if (extensionInfo.isEmpty()) {
            return currentState;
        }
        if (!unknownExtensions.isEmpty()) {
            log.warn("The configured Quarkus registries did not provide any compatibility information for the following extensions in the context of the currently recommended Quarkus platforms:");
            unknownExtensions.forEach(e -> log.warn(" " + e.currentDep.getArtifact().toCompactCoords()));
        }
        try {
            recommendedOrigins = UpdateProjectCommandHandler.getRecommendedOrigins(latestCatalog, updateCandidates);
        }
        catch (QuarkusCommandException e3) {
            log.info("Failed to find a compatible configuration update for the project");
            return currentState;
        }
        int collectedUpdates = 0;
        block6: for (ExtensionCatalog extensionCatalog : recommendedOrigins) {
            ExtensionMap candidates = (ExtensionMap)updateCandidatesByOrigin.get(extensionCatalog.getId());
            for (Extension e4 : extensionCatalog.getExtensions()) {
                ExtensionInfo info = candidates.get(e4.getArtifact().getKey());
                if (info == null || info.recommendedMetadata != null) continue;
                info.setRecommendedMetadata(e4);
                if (++collectedUpdates != updateCandidates.size()) continue;
                continue block6;
            }
        }
        ProjectState.Builder stateBuilder = ProjectState.builder();
        for (ExtensionCatalog c : recommendedOrigins) {
            if (!c.isPlatform()) continue;
            stateBuilder.addPlatformBom(c.getBom());
        }
        LinkedHashMap<String, ExtensionProvider.Builder> linkedHashMap = new LinkedHashMap<String, ExtensionProvider.Builder>(recommendedOrigins.size());
        for (ExtensionInfo info : extensionInfo.values()) {
            TopExtensionDependency ext = info.getRecommendedDependency();
            stateBuilder.addExtensionDependency(ext);
            linkedHashMap.computeIfAbsent(ext.getProviderKey(), k -> ExtensionProvider.builder().setOrigin(ext.getOrigin())).addExtension(ext);
        }
        linkedHashMap.values().forEach(b -> stateBuilder.addExtensionProvider(b.build()));
        for (ModuleState module : currentState.getModules()) {
            ModuleState.Builder moduleBuilder = ModuleState.builder().setMainModule(module.isMain()).setWorkspaceModule(module.getWorkspaceModule());
            for (TopExtensionDependency dep : module.getExtensions()) {
                TopExtensionDependency recommendedDep = extensionInfo.get(dep.getKey()).getRecommendedDependency();
                moduleBuilder.addExtensionDependency(recommendedDep);
                ExtensionOrigin origin = recommendedDep.getOrigin();
                if (origin == null || !origin.isPlatform()) continue;
                moduleBuilder.addPlatformBom(origin.getBom());
            }
            stateBuilder.addModule(moduleBuilder.build());
        }
        return stateBuilder.build();
    }

    private static List<ExtensionCatalog> getRecommendedOrigins(ExtensionCatalog extensionCatalog, List<Extension> extensions) throws QuarkusCommandException {
        ArrayList<ExtensionOrigins> extOrigins = new ArrayList<ExtensionOrigins>(extensions.size());
        for (Extension e : extensions) {
            UpdateProjectCommandHandler.addOrigins(extOrigins, e);
        }
        OriginCombination recommendedCombination = OriginSelector.of(extOrigins).calculateRecommendedCombination();
        if (recommendedCombination == null) {
            StringBuilder buf = new StringBuilder();
            buf.append("Failed to determine a compatible Quarkus version for the requested extensions: ");
            buf.append(extensions.get(0).getArtifact().getKey().toGacString());
            for (int i = 1; i < extensions.size(); ++i) {
                buf.append(", ").append(extensions.get(i).getArtifact().getKey().toGacString());
            }
            throw new QuarkusCommandException(buf.toString());
        }
        return recommendedCombination.getUniqueSortedOrigins().stream().map(o -> o.getCatalog()).collect(Collectors.toList());
    }

    private static void addOrigins(List<ExtensionOrigins> extOrigins, Extension e) {
        ExtensionOrigins.Builder eoBuilder = null;
        for (ExtensionOrigin o : e.getOrigins()) {
            ExtensionCatalog c;
            OriginPreference op;
            if (!(o instanceof ExtensionCatalog) || (op = (OriginPreference)(c = (ExtensionCatalog)o).getMetadata().get("origin-preference")) == null) continue;
            if (eoBuilder == null) {
                eoBuilder = ExtensionOrigins.builder((ArtifactKey)e.getArtifact().getKey());
            }
            eoBuilder.addOrigin(c, op);
        }
        if (eoBuilder != null) {
            extOrigins.add(eoBuilder.build());
        }
    }

    private <T> T getMetadata(ExtensionCatalog catalog, String ... path) {
        Map currentValue = catalog.getMetadata();
        for (String pathElement : path) {
            if (!(currentValue instanceof Map)) {
                return null;
            }
            currentValue = currentValue.get(pathElement);
        }
        return (T)currentValue;
    }

    private static class ExtensionMap {
        final Map<String, List<ExtensionInfo>> extensionInfo;
        final List<ExtensionInfo> list = new ArrayList<ExtensionInfo>();

        ExtensionMap() {
            this.extensionInfo = new LinkedHashMap<String, List<ExtensionInfo>>();
        }

        ExtensionMap(int size) {
            this.extensionInfo = new LinkedHashMap<String, List<ExtensionInfo>>(size);
        }

        void add(ExtensionInfo e) {
            this.extensionInfo.put(e.currentDep.getArtifact().getArtifactId(), Collections.singletonList(e));
            this.list.add(e);
        }

        ExtensionInfo get(ArtifactKey key) {
            List<ExtensionInfo> list = this.extensionInfo.get(key.getArtifactId());
            if (list == null || list.isEmpty()) {
                return null;
            }
            if (list.size() == 1) {
                return list.get(0);
            }
            for (ExtensionInfo e : list) {
                if (!e.currentDep.getKey().equals(key) && (e.getRecommendedDependency() == null || !e.getRecommendedDependency().getKey().equals(key))) continue;
                return e;
            }
            throw new IllegalArgumentException(key + " isn't found in the extension map");
        }

        Collection<ExtensionInfo> values() {
            return this.list;
        }

        int size() {
            return this.extensionInfo.size();
        }

        boolean isEmpty() {
            return this.extensionInfo.isEmpty();
        }
    }

    private static class ExtensionInfo {
        final TopExtensionDependency currentDep;
        Extension latestMetadata;
        Extension recommendedMetadata;
        TopExtensionDependency recommendedDep;

        ExtensionInfo(TopExtensionDependency currentDep) {
            this.currentDep = currentDep;
        }

        void setRecommendedMetadata(Extension e) {
            this.recommendedMetadata = e;
            if (!this.currentDep.getArtifact().getKey().equals(e.getArtifact().getKey())) {
                // empty if block
            }
        }

        Extension getRecommendedMetadata() {
            if (this.recommendedMetadata != null) {
                return this.recommendedMetadata;
            }
            if (this.recommendedDep == null) {
                return this.currentDep.getCatalogMetadata();
            }
            this.recommendedMetadata = this.currentDep.getCatalogMetadata();
            return this.recommendedMetadata;
        }

        TopExtensionDependency getRecommendedDependency() {
            if (this.recommendedDep != null) {
                return this.recommendedDep;
            }
            if (this.recommendedMetadata == null) {
                return this.currentDep;
            }
            this.recommendedDep = TopExtensionDependency.builder().setArtifact(this.recommendedMetadata.getArtifact()).setCatalogMetadata(this.recommendedMetadata).setTransitive(this.currentDep.isTransitive()).build();
            return this.recommendedDep;
        }

        boolean isUpdateRecommended() {
            return this.getRecommendedDependency() != this.currentDep;
        }
    }
}

